/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.BitWriteBuffer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;

public class TagValueEncoder {
    HashMap<String, Tag> tags = new HashMap();
    ArrayList<TagGroup> groups = new ArrayList();
    ByteArrayOutputStream baos;
    DataOutputStream dos;
    ArrayList<String> stringList;
    HashMap<String, Integer> stringMap;
    ArrayList<Tag> taglist;
    private int setId = 0;
    private int nextIdx = 0;
    private int pass;
    private static String[][] taggroups = new String[][]{{"highway", "name", "maxspeed", "lanes", "service", "tracktype", "surface"}, {"access", "foot", "bicycle", "motorcar", "motor_vehicle", "motorcycle", "vehicle"}, {"building", "addr:street", "addr:housenumber", "addr:city", "addr:postcode", "addr:housename"}};

    private void encodeString(BitWriteBuffer bc, String s) {
        Integer ii = this.stringMap.get(s);
        bc.encodeBit(ii == null);
        if (ii == null) {
            try {
                byte[] textBytes = s.getBytes("UTF8");
                bc.encodeInt(textBytes.length);
                this.dos.write(textBytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ii = this.stringList.size();
            this.stringList.add(s);
            this.stringMap.put(s, ii);
            return;
        }
        bc.encodeBounded(this.stringList.size() - 1, ii.intValue());
    }

    public TagValueEncoder() {
        for (String[] names : taggroups) {
            new TagGroup(names);
        }
    }

    public byte[] encodeDictionary(BitWriteBuffer bc) throws IOException {
        if (++this.pass == 1) {
            return null;
        }
        if (this.pass == 2) {
            this.nextIdx = 0;
            Collections.sort(this.groups);
            for (TagGroup g : this.groups) {
                g.indexTags();
            }
            this.taglist = new ArrayList();
            for (Tag t : this.tags.values()) {
                if (t.count <= 0) continue;
                this.taglist.add(t);
            }
            Collections.sort(this.taglist);
            return null;
        }
        this.stringList = new ArrayList();
        this.stringMap = new HashMap();
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        bc.encodeInt(this.taglist.size());
        for (Tag t : this.taglist) {
            t.encodeDictionary(bc);
        }
        this.dos.close();
        byte[] textData = this.baos.toByteArray();
        this.dos = null;
        this.baos = null;
        return textData;
    }

    public int getTagIndex(String name) {
        return this.tags.get((Object)name).idx;
    }

    public List<String> sortTagNames(Collection<String> col) {
        ArrayList<Tag> taglist = new ArrayList<Tag>(col.size());
        for (String name : col) {
            taglist.add(this.tags.get(name));
        }
        Collections.sort(taglist);
        ArrayList<String> res = new ArrayList<String>(taglist.size());
        for (Tag t : taglist) {
            res.add(t.name);
        }
        return res;
    }

    public void startTagSet() {
        if (this.pass == 1) {
            ++this.setId;
        }
    }

    public void encodeValue(BitWriteBuffer bc, String name, String value) {
        if (this.pass == 1) {
            Tag t = this.tags.get(name);
            if (t == null) {
                String[] names = new String[]{name};
                new TagGroup(names);
                t = this.tags.get(name);
            }
            t.addValue(value);
        } else {
            this.tags.get((Object)name).values.get(value).encode(bc);
        }
    }

    private class Value
    implements Comparable<Value> {
        String value;
        int code;
        int range;
        Value child1;
        Value child2;
        int frequency;

        Value(String value) {
            this.value = value;
        }

        Value(Value c1, Value c2) {
            this.child1 = c1;
            this.child2 = c2;
            this.frequency = c1.frequency + c2.frequency;
        }

        void encodeTree(BitWriteBuffer bc, int range, int code) throws IOException {
            this.range = range;
            this.code = code;
            boolean isNode = this.child1 != null;
            bc.encodeBit(isNode);
            if (isNode) {
                this.child1.encodeTree(bc, range << 1, code);
                this.child2.encodeTree(bc, range << 1, code + range);
                return;
            }
            bc.encodeBit(false);
            TagValueEncoder.this.encodeString(bc, this.value);
        }

        void encode(BitWriteBuffer bc) {
            bc.encodeBounded(this.range - 1, this.code);
        }

        @Override
        public int compareTo(Value v) {
            return this.frequency - v.frequency;
        }
    }

    public class Tag
    implements Comparable<Tag> {
        String name;
        int count;
        int idx;
        private Object tree;
        HashMap<String, Value> values = new HashMap();
        List<Value> valueList;
        TagGroup group;

        Tag(String name, TagGroup group) {
            this.name = name;
            this.group = group;
        }

        void addValue(String value) {
            Value v = this.values.get(value);
            if (v == null) {
                v = new Value(value);
                this.values.put(value, v);
            }
            ++v.frequency;
            ++this.count;
        }

        public void encodeDictionary(BitWriteBuffer bc) throws IOException {
            TagValueEncoder.this.encodeString(bc, this.name);
            PriorityQueue<Value> queue = new PriorityQueue<Value>(this.values.size());
            queue.addAll(this.values.values());
            while (queue.size() > 1) {
                queue.add(new Value((Value)queue.poll(), (Value)queue.poll()));
            }
            ((Value)queue.poll()).encodeTree(bc, 1, 0);
        }

        @Override
        public int compareTo(Tag t) {
            return this.idx - t.idx;
        }
    }

    private class TagGroup
    implements Comparable<TagGroup> {
        String[] names;
        int count;
        int lastSetId = 0;

        void incCount() {
            if (TagValueEncoder.this.setId != this.lastSetId) {
                ++this.count;
            }
            this.lastSetId = TagValueEncoder.this.setId;
        }

        TagGroup(String[] names) {
            this.names = names;
            for (String name : names) {
                TagValueEncoder.this.tags.put(name, new Tag(name, this));
            }
            TagValueEncoder.this.groups.add(this);
        }

        void indexTags() {
            for (String name : this.names) {
                Tag t = TagValueEncoder.this.tags.get(name);
                if (t.count <= 0) continue;
                t.idx = TagValueEncoder.this.nextIdx++;
            }
        }

        @Override
        public int compareTo(TagGroup g) {
            return g.count - this.count;
        }
    }
}

