/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.BitWriteBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;

public final class TagSetEncoder {
    private HashMap<TagSet, TagSet> identityMap = new HashMap();
    private BitWriteBuffer bwb;
    private int pass;
    private TagSet freq1;

    public void encodeTagSet(int[] data) {
        if (this.pass == 1) {
            return;
        }
        TagSet tvsProbe = new TagSet();
        tvsProbe.data = data;
        TagSet tvs = this.identityMap.get(tvsProbe);
        if (this.pass == 3) {
            if (tvs.frequency == 1) {
                this.bwb.encodeBounded(this.freq1.range - 1, this.freq1.code);
                TagSetEncoder.encodeTagSequence(this.bwb, data);
            } else {
                this.bwb.encodeBounded(tvs.range - 1, tvs.code);
            }
        } else if (this.pass == 2) {
            if (tvs == null) {
                tvs = tvsProbe;
                this.identityMap.put(tvs, tvs);
            }
            ++tvs.frequency;
        }
    }

    public void encodeDictionary(BitWriteBuffer bwb) {
        if (++this.pass == 3) {
            this.freq1 = new TagSet();
            PriorityQueue<TagSet> queue = new PriorityQueue<TagSet>(2 * this.identityMap.size(), new TagSet.FrequencyComparator());
            for (TagSet ts : this.identityMap.values()) {
                if (ts.frequency > 1) {
                    queue.add(ts);
                    continue;
                }
                ++this.freq1.frequency;
            }
            queue.add(this.freq1);
            while (queue.size() > 1) {
                TagSet node = new TagSet();
                node.child1 = queue.poll();
                node.child2 = queue.poll();
                node.frequency = node.child1.frequency + node.child2.frequency;
                queue.add(node);
            }
            TagSet root = queue.poll();
            root.encode(bwb, 1, 0);
        }
        this.bwb = bwb;
    }

    private static void encodeTagSequence(BitWriteBuffer bwb, int[] data) {
        int tagcount = data.length;
        bwb.encodeInt(tagcount);
        int lastIdx = -1;
        for (int i = 0; i < tagcount; ++i) {
            int idx = data[i];
            bwb.encodeInt(idx - lastIdx - 1);
            lastIdx = idx;
        }
    }

    public static final class TagSet {
        public int[] data;
        public int frequency;
        public int code;
        public int range;
        public TagSet child1;
        public TagSet child2;

        public void encode(BitWriteBuffer bwb, int range, int code) {
            this.range = range;
            this.code = code;
            boolean isNode = this.child1 != null;
            bwb.encodeBit(isNode);
            if (isNode) {
                this.child1.encode(bwb, range << 1, code);
                this.child2.encode(bwb, range << 1, code + range);
            } else {
                bwb.encodeBit(this.data == null);
                if (this.data != null) {
                    TagSetEncoder.encodeTagSequence(bwb, this.data);
                }
            }
        }

        public boolean equals(Object o) {
            if (o instanceof TagSet) {
                TagSet tvs = (TagSet)o;
                if (this.data == null) {
                    return tvs.data == null;
                }
                if (tvs.data == null) {
                    return this.data == null;
                }
                if (this.data.length != tvs.data.length) {
                    return false;
                }
                for (int i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == tvs.data[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.data == null) {
                return 0;
            }
            int h = 17;
            for (int i = 0; i < this.data.length; ++i) {
                h = (h << 8) + this.data[i];
            }
            return h;
        }

        public static class FrequencyComparator
        implements Comparator<TagSet> {
            @Override
            public int compare(TagSet tvs1, TagSet tvs2) {
                if (tvs1.frequency < tvs2.frequency) {
                    return -1;
                }
                if (tvs1.frequency > tvs2.frequency) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

