/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.BitWriteBuffer;
import btools.mapsplitter.HuffmanTreeEncoder;
import java.util.TreeMap;

public final class CharEncoder
extends HuffmanTreeEncoder<Character> {
    private long[] alphabet;
    private int range;
    private TreeMap<Character, Integer> chars = new TreeMap();

    @Override
    public void encode(Character c) {
        if (this.pass == 1) {
            this.chars.put(c, null);
        }
        super.encode(c);
    }

    @Override
    public void encodeDictionary(BitWriteBuffer bwb) {
        if (this.pass == 1) {
            int idx = 0;
            this.alphabet = new long[this.chars.size()];
            this.range = this.chars.size() - 1;
            for (Character c : this.chars.keySet()) {
                System.out.println("assigning index " + idx + " to char=" + c);
                this.alphabet[idx] = c.charValue();
                this.chars.put(c, idx++);
            }
        }
        if (this.alphabet != null) {
            bwb.encodeSortedArray(this.alphabet);
        }
        super.encodeDictionary(bwb);
    }

    @Override
    protected void encodeItem(Character c) {
        int idx = this.chars.get(c);
        System.out.println("encoding item: c=" + c + " idx=" + idx);
        this.bwb.encodeBounded(this.range, idx);
    }

    @Override
    public boolean itemEquals(Character c1, Character c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        return c1.charValue() == c2.charValue();
    }

    @Override
    public int itemHashCode(Character c) {
        return c.charValue() == '\u0000' ? (char)'\u0000' : c.charValue();
    }
}

