/*
 * Decompiled with CFR 0.152.
 */
package btools.mapdecoder;

import btools.mapdecoder.OsmNode;
import btools.mapdecoder.OsmObject;
import java.util.List;

public class OsmWay
extends OsmObject {
    public List<OsmNode> nodes;
    int minx;
    int miny;
    int maxx;
    int maxy;

    public void calcBBox() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            OsmNode n = this.nodes.get(i);
            if (i == 0) {
                this.minx = this.maxx = n.ilon;
                this.miny = this.maxy = n.ilat;
                continue;
            }
            if (n.ilon < this.minx) {
                this.minx = n.ilon;
            }
            if (n.ilon > this.maxx) {
                this.maxx = n.ilon;
            }
            if (n.ilat < this.miny) {
                this.miny = n.ilat;
            }
            if (n.ilat <= this.maxy) continue;
            this.maxy = n.ilat;
        }
    }

    public boolean inBBox(int z, int x, int y) {
        int shift = 28 - z;
        int x0 = x << shift;
        int x1 = x + 1 << shift;
        int y0 = y << shift;
        int y1 = y + 1 << shift;
        boolean outofbox = x1 < this.minx || x0 >= this.maxx || y1 < this.miny || y0 >= this.maxy;
        return !outofbox;
    }
}

