/*
 * Decompiled with CFR 0.152.
 */
package btools.mapdecoder;

public final class BitReadBuffer {
    private byte[] ab;
    private int idxMax;
    private int idx = -1;
    private int bits;
    private long b;

    public BitReadBuffer(byte[] ab) {
        this.ab = ab;
        this.idxMax = ab.length - 1;
    }

    public boolean decodeBit() {
        this.fillBuffer();
        boolean value = (this.b & 1L) != 0L;
        this.b >>>= 1;
        --this.bits;
        return value;
    }

    public long decodeBits(int count) {
        if (count == 0) {
            return 0L;
        }
        this.fillBuffer();
        long mask = -1L >>> 64 - count;
        long value = this.b & mask;
        this.b >>>= count;
        this.bits -= count;
        return value;
    }

    public long decodeBounded(long max) {
        long value = 0L;
        long im = 1L;
        this.fillBuffer();
        while ((value | im) <= max) {
            if ((this.b & 1L) != 0L) {
                value |= im;
            }
            this.b >>>= 1;
            --this.bits;
            im <<= 1;
        }
        return value;
    }

    public int decodeInt() {
        long range = 1L;
        int cnt = 1;
        this.fillBuffer();
        while ((this.b & range) == 0L) {
            range = range << 1 | 1L;
            ++cnt;
        }
        this.b >>>= cnt;
        this.bits -= cnt;
        return (int)((range >>> 1) + (cnt > 1 ? this.decodeBits(cnt - 1) : 0L));
    }

    public long decodeLong() {
        int n = this.decodeInt();
        return (1L << n) + this.decodeBits(n) - 1L;
    }

    public long[] decodeSortedArray() {
        int size = this.decodeInt();
        long[] values = new long[size];
        if (size == 0) {
            return values;
        }
        int offset = 0;
        long value = 0L;
        int bits = this.decodeInt();
        int[] sizestack = new int[bits];
        int stackpointer = 0;
        while (true) {
            if (size > 1 && bits > 0) {
                int size2 = (int)this.decodeBounded(size);
                sizestack[stackpointer++] = size2;
                size -= size2;
                value <<= 1;
                --bits;
                continue;
            }
            if (size == 1) {
                values[offset++] = value << bits | this.decodeBits(bits);
            } else {
                while (size-- > 0) {
                    values[offset++] = value;
                }
            }
            if (stackpointer == 0) {
                return values;
            }
            while ((value & 1L) == 1L) {
                value >>= 1;
                ++bits;
            }
            value |= 1L;
            size = sizestack[--stackpointer];
        }
    }

    private void fillBuffer() {
        while (this.bits <= 56) {
            if (this.idx < this.idxMax) {
                this.b |= ((long)this.ab[++this.idx] & 0xFFL) << this.bits;
            }
            this.bits += 8;
        }
    }
}

