/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.util.CompactLongMap;

public class OsmNodePairSet {
    private long[] n1a;
    private long[] n2a;
    private int tempNodes = 0;
    private int maxTempNodes = 0;
    private int npairs = 0;
    private int freezecount = 0;
    private CompactLongMap<OsmNodePair> map;

    public OsmNodePairSet(int maxTempNodeCount) {
        this.maxTempNodes = maxTempNodeCount;
        this.n1a = new long[this.maxTempNodes];
        this.n2a = new long[this.maxTempNodes];
    }

    public void addTempPair(long n1, long n2) {
        if (this.tempNodes < this.maxTempNodes) {
            this.n1a[this.tempNodes] = n1;
            this.n2a[this.tempNodes] = n2;
            ++this.tempNodes;
        }
    }

    public void freezeTempPairs() {
        ++this.freezecount;
        for (int i = 0; i < this.tempNodes; ++i) {
            this.addPair(this.n1a[i], this.n2a[i]);
        }
        this.tempNodes = 0;
    }

    public void clearTempPairs() {
        this.tempNodes = 0;
    }

    private void addPair(long n1, long n2) {
        if (this.map == null) {
            this.map = new CompactLongMap();
        }
        ++this.npairs;
        OsmNodePair e = this.getElement(n1, n2);
        if (e == null) {
            e = new OsmNodePair();
            e.node2 = n2;
            OsmNodePair e0 = this.map.get(n1);
            if (e0 != null) {
                while (e0.next != null) {
                    e0 = e0.next;
                }
                e0.next = e;
            } else {
                this.map.fastPut(n1, e);
            }
        }
    }

    public int size() {
        return this.npairs;
    }

    public int tempSize() {
        return this.tempNodes;
    }

    public int getFreezeCount() {
        return this.freezecount;
    }

    public boolean hasPair(long n1, long n2) {
        return this.map != null && (this.getElement(n1, n2) != null || this.getElement(n2, n1) != null);
    }

    private OsmNodePair getElement(long n1, long n2) {
        OsmNodePair e = this.map.get(n1);
        while (e != null) {
            if (e.node2 == n2) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private static class OsmNodePair {
        public long node2;
        public OsmNodePair next;

        private OsmNodePair() {
        }
    }
}

