/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.LruMapNode;

public final class LruMap {
    private int hashbins;
    private int maxsize;
    private int size;
    private LruMapNode lru;
    private LruMapNode mru;
    private LruMapNode[] binArray;

    public LruMap(int bins, int size) {
        this.hashbins = bins;
        this.maxsize = size;
        this.binArray = new LruMapNode[this.hashbins];
    }

    public LruMapNode get(LruMapNode key) {
        int bin = (key.hashCode() & 0xFFFFFFF) % this.hashbins;
        LruMapNode e = this.binArray[bin];
        while (e != null) {
            if (key.equals(e)) {
                return e;
            }
            e = e.nextInBin;
        }
        return null;
    }

    public void touch(LruMapNode e) {
        LruMapNode n = e.next;
        LruMapNode p = e.previous;
        if (n == null) {
            return;
        }
        n.previous = p;
        if (p != null) {
            p.next = n;
        } else {
            this.lru = n;
        }
        this.mru.next = e;
        e.previous = this.mru;
        e.next = null;
        this.mru = e;
    }

    public LruMapNode removeLru() {
        if (this.size < this.maxsize) {
            return null;
        }
        --this.size;
        int bin = (this.lru.hashCode() & 0xFFFFFFF) % this.hashbins;
        LruMapNode e = this.binArray[bin];
        if (e == this.lru) {
            this.binArray[bin] = this.lru.nextInBin;
        } else {
            while (e != null) {
                LruMapNode prev = e;
                e = e.nextInBin;
                if (e != this.lru) continue;
                prev.nextInBin = this.lru.nextInBin;
                break;
            }
        }
        LruMapNode res = this.lru;
        this.lru = this.lru.next;
        this.lru.previous = null;
        return res;
    }

    public void put(LruMapNode val) {
        int bin = (val.hashCode() & 0xFFFFFFF) % this.hashbins;
        val.nextInBin = this.binArray[bin];
        this.binArray[bin] = val;
        val.previous = this.mru;
        val.next = null;
        if (this.mru == null) {
            this.lru = val;
        } else {
            this.mru.next = val;
        }
        this.mru = val;
        ++this.size;
    }
}

