/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContextNode;
import btools.expressions.BExpressionContextWay;
import btools.router.KinematicPath;
import btools.router.KinematicPrePath;
import btools.router.OsmPath;
import btools.router.OsmPathModel;
import btools.router.OsmPrePath;

class KinematicModel
extends OsmPathModel {
    public double turnAngleDecayLength;
    public double f_roll;
    public double f_air;
    public double f_recup;
    public double p_standby;
    public double recup_efficiency;
    public double totalweight;
    public double vmax;
    public double leftWaySpeed;
    public double rightWaySpeed;
    public double xweight;
    public double timecost0;
    private int wayIdxMaxspeed;
    private int wayIdxMinspeed;
    private int nodeIdxMaxspeed;
    protected BExpressionContextWay ctxWay;
    protected BExpressionContextNode ctxNode;

    KinematicModel() {
    }

    @Override
    public OsmPrePath createPrePath() {
        return new KinematicPrePath();
    }

    @Override
    public OsmPath createPath() {
        return new KinematicPath();
    }

    @Override
    public void init(BExpressionContextWay expctxWay, BExpressionContextNode expctxNode) {
        this.ctxWay = expctxWay;
        this.ctxNode = expctxNode;
        BExpressionContextWay expctxGlobal = expctxWay;
        this.turnAngleDecayLength = expctxGlobal.getVariableValue("turnAngleDecayLength", 50.0f);
        this.f_roll = expctxGlobal.getVariableValue("f_roll", 232.0f);
        this.f_air = expctxGlobal.getVariableValue("f_air", 0.4f);
        this.f_recup = expctxGlobal.getVariableValue("f_recup", 400.0f);
        this.p_standby = expctxGlobal.getVariableValue("p_standby", 250.0f);
        this.recup_efficiency = expctxGlobal.getVariableValue("recup_efficiency", 0.7f);
        this.totalweight = expctxGlobal.getVariableValue("totalweight", 1640.0f);
        this.vmax = (double)expctxGlobal.getVariableValue("vmax", 80.0f) / 3.6;
        this.leftWaySpeed = (double)expctxGlobal.getVariableValue("leftWaySpeed", 12.0f) / 3.6;
        this.rightWaySpeed = (double)expctxGlobal.getVariableValue("rightWaySpeed", 12.0f) / 3.6;
        this.xweight = 1.0 / (2.0 * this.f_air * this.vmax * this.vmax * this.vmax - this.p_standby);
        this.timecost0 = 1.0 / this.vmax + this.xweight * (this.f_roll + this.f_air * this.vmax * this.vmax + this.p_standby / this.vmax);
        this.wayIdxMaxspeed = this.ctxWay.getOutputVariableIndex("maxspeed", false);
        this.wayIdxMinspeed = this.ctxWay.getOutputVariableIndex("minspeed", false);
        this.nodeIdxMaxspeed = this.ctxNode.getOutputVariableIndex("maxspeed", false);
    }

    public float getWayMaxspeed() {
        return this.ctxWay.getBuildInVariable(this.wayIdxMaxspeed) / 3.6f;
    }

    public float getWayMinspeed() {
        return this.ctxWay.getBuildInVariable(this.wayIdxMinspeed) / 3.6f;
    }

    public float getNodeMaxspeed() {
        return this.ctxNode.getBuildInVariable(this.nodeIdxMaxspeed) / 3.6f;
    }

    public double getMaxKineticEnergy() {
        double mspeed = Math.min((double)this.getWayMaxspeed(), Math.max((double)this.getWayMinspeed(), this.vmax));
        return 0.5 * this.totalweight * mspeed * mspeed;
    }
}

