/*
 * Decompiled with CFR 0.152.
 */
package btools.memrouter;

import btools.memrouter.OffsetSet;
import btools.memrouter.ScheduledDeparture;
import btools.memrouter.TrainSchedule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ScheduledLine {
    String name;
    List<Integer> offsetMinutes = new ArrayList<Integer>();
    TrainSchedule schedule;

    ScheduledLine() {
    }

    public List<ScheduledDeparture> getScheduledDepartures(int idx, long timeFrom, OffsetSet offsets) {
        ArrayList<ScheduledDeparture> result = new ArrayList<ScheduledDeparture>();
        long minutesFrom = (timeFrom + 59999L) / 60000L;
        long timeFromCorrection = minutesFrom * 60000L - timeFrom;
        if (idx < 0 || idx >= this.offsetMinutes.size() - 1) {
            return result;
        }
        int offsetStart = this.offsetMinutes.get(idx);
        int offsetEnd = this.offsetMinutes.get(idx + 1);
        Map<Integer, List<Integer>> waitOffsets = this.getDepartures(offsetStart, timeFrom + timeFromCorrection, offsets);
        for (Map.Entry<Integer, List<Integer>> e : waitOffsets.entrySet()) {
            ScheduledDeparture depart = new ScheduledDeparture();
            depart.waitTime = (long)e.getKey().intValue() * 60000L + timeFromCorrection;
            depart.offsets = offsets.create(e.getValue());
            depart.rideTime = (long)(offsetEnd - offsetStart) * 60000L;
            result.add(depart);
        }
        return result;
    }

    private Map<Integer, List<Integer>> getDepartures(int offsetStart, long timeFrom, OffsetSet offsets) {
        HashMap<Integer, List<Integer>> waitOffsets = new HashMap<Integer, List<Integer>>();
        int size = offsets.size();
        int offset = 0;
        while (true) {
            if (offset < size && !offsets.contains(offset)) {
                ++offset;
                continue;
            }
            if (offset >= size) {
                return waitOffsets;
            }
            int toNext = this.schedule.getMinutesToNext(timeFrom + 60000L * (long)(offset - offsetStart));
            if (toNext < 0) {
                return waitOffsets;
            }
            int departOffset = offset + toNext;
            int lastOffset = offset;
            while (toNext-- >= 0 && offset < size) {
                if (offsets.contains(offset)) {
                    lastOffset = offset;
                }
                ++offset;
            }
            int waitTime = departOffset - lastOffset;
            ArrayList<Integer> offsetList = (ArrayList<Integer>)waitOffsets.get(waitTime);
            if (offsetList == null) {
                offsetList = new ArrayList<Integer>();
                waitOffsets.put(waitTime, offsetList);
            }
            offsetList.add(lastOffset);
        }
    }
}

