/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.BitWriteBuffer;
import btools.mapsplitter.MapCreatorBase;
import btools.mapsplitter.NodeData;
import btools.mapsplitter.NodeIterator;
import btools.mapsplitter.RelationData;
import btools.mapsplitter.RelationIterator;
import btools.mapsplitter.TagSetEncoder;
import btools.mapsplitter.TagValueEncoder;
import btools.mapsplitter.TileData;
import btools.mapsplitter.WayData;
import btools.mapsplitter.WayIterator;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;

public class TileEncoder
extends MapCreatorBase {
    private Map<NodeData, NodeData> nodeMap;
    private Map<WayData, WayData> wayMap;
    private List<NodeData> used = new ArrayList<NodeData>();
    private NodeData templateNode = new NodeData(0L, 0, 0);
    private WayData templateWay = new WayData(0L, null);
    private TileData tile;
    private BitWriteBuffer bwb;
    private byte[] buffer;
    private List<WayData> wayList;
    private List<RelationData> relationList;
    private int nTagSets;
    private int nTaggedNodes;
    private long totalNodes;
    private long totalTaggedNodes;
    private long totalWays;
    private long totalTextBytes;
    private long totalTiles;
    private int pass;
    private boolean dostats;
    private TagValueEncoder tagValueEncoder;
    private TagSetEncoder tagSetEnoder;

    public static void main(String[] args) throws Exception {
        System.out.println("*** TileEncoder: encodes a given node/way file pair");
        if (args.length != 1) {
            System.out.println("usage: java TileEncoder <node-file>");
            return;
        }
        new TileEncoder().process(new File(args[0]));
    }

    public void process(File nodeFile) throws Exception {
        TileData t0 = new TileData();
        this.process(nodeFile, t0);
        System.out.println("**** total statistics ****");
        System.out.println("tiles=" + this.totalTiles + " nodes=" + this.totalNodes + " taggedNodes=" + this.totalTaggedNodes + " ways=" + this.totalWays + " textBytes= " + this.totalTextBytes);
        TileEncoder tileEncoder = this;
        System.out.println(tileEncoder.bwb.getBitReport());
    }

    public void process(File nodeFile, TileData tile) throws Exception {
        this.tile = tile;
        if (!nodeFile.exists()) {
            return;
        }
        System.out.println("******* processing: " + nodeFile);
        new NodeIterator(this).processFile(nodeFile);
        int zoomStep = 2;
        int xyStep = 1 << zoomStep;
        int nextZoom = tile.zoom + zoomStep;
        int x0 = tile.x << zoomStep;
        int y0 = tile.y << zoomStep;
        File childDir = new File(nodeFile.getParentFile().getParentFile(), "" + nextZoom);
        for (int dx = 0; dx < xyStep; ++dx) {
            for (int dy = 0; dy < xyStep; ++dy) {
                TileData nextTile = new TileData();
                nextTile.zoom = nextZoom;
                nextTile.x = x0 + dx;
                nextTile.y = y0 + dy;
                nextTile.parent = tile;
                File nextFile = new File(childDir, nextTile.x + "_" + nextTile.y + ".ntl");
                this.process(nextFile, nextTile);
            }
        }
    }

    @Override
    public void nodeFileStart(File nodeFile) throws Exception {
        this.tile.nodeList = new ArrayList<NodeData>();
        this.nodeMap = new HashMap<NodeData, NodeData>();
        this.wayMap = new HashMap<WayData, WayData>();
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        if (n.zoom == -1 || n.zoom == this.tile.zoom) {
            n.zoom = this.tile.zoom;
            n.used = true;
            this.tile.nodeList.add(n);
        }
        n.localeIndex = this.nodeMap.size();
        this.nodeMap.put(n, n);
        n.calcGeoId();
    }

    @Override
    public void nodeFileEnd(File nodeFile) throws Exception {
        NodeData.sortByGeoId(this.tile.nodeList);
        int idx = 0;
        for (NodeData n : this.tile.nodeList) {
            n.nativeIndex = idx++;
        }
        this.wayList = new ArrayList<WayData>();
        String name = nodeFile.getName();
        String wayfilename = name.substring(0, name.length() - 3) + "wtl";
        File wayfile = new File(nodeFile.getParent(), wayfilename);
        if (wayfile.exists()) {
            new WayIterator(this).processFile(wayfile);
        }
        this.relationList = new ArrayList<RelationData>();
        String relfilename = name.substring(0, name.length() - 3) + "rtl";
        File relfile = new File(nodeFile.getParent(), relfilename);
        if (relfile.exists()) {
            new RelationIterator(this).processFile(relfile);
        }
        int nnodes = this.tile.nodeList.size();
        this.tagValueEncoder = new TagValueEncoder();
        this.tagSetEnoder = new TagSetEncoder();
        long[] nodePositions = new long[nnodes];
        for (int i = 0; i < nnodes; ++i) {
            nodePositions[i] = this.tile.nodeList.get((int)i).gid;
        }
        this.pass = 1;
        while (this.pass <= 3) {
            this.nTagSets = 0;
            this.dostats = this.pass == 3;
            this.buffer = new byte[10000000];
            this.bwb = new BitWriteBuffer(this.buffer);
            this.tagSetEnoder.encodeDictionary(this.bwb);
            if (this.dostats) {
                this.bwb.assignBits("tagset-dictionary");
            }
            byte[] textData = this.tagValueEncoder.encodeDictionary(this.bwb);
            if (this.dostats) {
                this.bwb.assignBits("value-dictionary");
            }
            this.bwb.encodeSortedArray(nodePositions);
            if (this.dostats) {
                this.bwb.assignBits("node-positions");
            }
            if (this.pass == 3) {
                this.writeDownzoomRefs(this.bwb);
            }
            this.writeTaggedNodes();
            this.writeWays(this.bwb);
            this.writeRelations(this.bwb);
            if (this.pass == 1 && this.nTagSets == 0) break;
            if (this.pass == 1) {
                this.assignLocalIndexes();
            }
            if (this.pass == 3) {
                Deflater compresser = new Deflater();
                compresser.setInput(textData);
                compresser.finish();
                byte[] textHeader = new byte[textData.length + 1024];
                int textHeaderLen = compresser.deflate(textHeader);
                ++this.totalTiles;
                this.totalNodes += (long)this.tile.nodeList.size();
                this.totalTaggedNodes += (long)this.nTaggedNodes;
                this.totalTextBytes += (long)textHeaderLen;
                System.out.println("nodes=" + this.tile.nodeList.size() + " taggedNodes=" + this.nTaggedNodes + " ways=" + this.wayList.size() + " textBytes= " + textHeaderLen);
                String datafilename = name.substring(0, name.length() - 3) + "osb";
                File datafile = new File(nodeFile.getParent(), datafilename);
                DataOutputStream dos = new DataOutputStream(new FileOutputStream(datafile));
                dos.writeInt(textData.length);
                dos.writeInt(textHeaderLen);
                dos.write(textHeader, 0, textHeaderLen);
                int size = this.bwb.getEncodedLength();
                dos.writeInt(size);
                dos.write(this.buffer, 0, size);
                dos.close();
            }
            ++this.pass;
        }
        if (relfile.exists()) {
            relfile.delete();
        }
        if (wayfile.exists()) {
            wayfile.delete();
        }
        if (nodeFile.exists()) {
            nodeFile.delete();
        }
    }

    @Override
    public void nextWay(WayData way) throws Exception {
        if (way.zoom == -1 || way.zoom == this.tile.zoom) {
            way.zoom = this.tile.zoom;
            way.startNodeIdx = -1;
            this.wayList.add(way);
        }
        this.wayMap.put(way, way);
    }

    @Override
    public void nextRelation(RelationData r) throws Exception {
        this.relationList.add(r);
    }

    private void assignLocalIndexes() {
        this.used = new ArrayList<NodeData>();
        for (NodeData n : this.nodeMap.values()) {
            if (!n.used) continue;
            this.used.add(n);
        }
        NodeData.sortByGeoId(this.used);
        int idx = 0;
        for (NodeData n : this.used) {
            n.localeIndex = idx++;
        }
    }

    private void writeDownzoomRefs(BitWriteBuffer bwb) {
        bwb.encodeInt(this.used.size());
        for (int zoom = 0; zoom < this.tile.zoom; ++zoom) {
            int cnt = 0;
            for (NodeData n : this.used) {
                if (n.zoom != zoom) continue;
                ++cnt;
            }
            long[] localeIndexes = new long[cnt];
            long[] nativeIndexes = new long[cnt];
            int idx = 0;
            for (NodeData n : this.used) {
                if (n.zoom != zoom) continue;
                localeIndexes[idx] = n.localeIndex;
                nativeIndexes[idx] = n.nativeIndex;
                ++idx;
            }
            bwb.encodeSortedArray(localeIndexes);
            if (this.dostats) {
                bwb.assignBits("localindexes");
            }
            bwb.encodeSortedArray(nativeIndexes);
            if (!this.dostats) continue;
            bwb.assignBits("nativeindexes");
        }
    }

    private int getLocaleIndexForNid(long nid) {
        this.templateNode.nid = nid;
        NodeData n = this.nodeMap.get(this.templateNode);
        if (n == null) {
            throw new IllegalArgumentException("nid=" + nid + " not found");
        }
        n.used = true;
        return n.localeIndex;
    }

    private void encodeWay(BitWriteBuffer bwb, WayData way) throws Exception {
        boolean closedPoly;
        int nnodes = way.nodes.size();
        boolean bl = closedPoly = way.nodes.get(0) == way.nodes.get(nnodes - 1);
        if (closedPoly) {
            --nnodes;
        }
        if (nnodes < 2) {
            return;
        }
        this.writeTags(way.getTagsOrNull());
        bwb.encodeBit(closedPoly);
        bwb.encodeInt(nnodes - 2);
        if (this.dostats) {
            bwb.assignBits("way-node-count");
        }
        int lastIdx = 0;
        for (int i = 0; i < nnodes; ++i) {
            long nid = way.nodes.get(i);
            int idx = this.getLocaleIndexForNid(nid);
            if (i == 0) {
                way.startNodeIdx = idx;
            } else {
                int delta = idx - lastIdx;
                if (delta == 0) {
                    System.out.println("double node in way, ignoring");
                    way.startNodeIdx = -1;
                    return;
                }
                boolean negative = delta < 0;
                bwb.encodeBit(negative);
                bwb.encodeLong((negative ? -delta : delta) - 1);
                if (this.dostats) {
                    bwb.assignBits("way-node-idx-delta");
                }
            }
            lastIdx = idx;
        }
    }

    private void writeWays(BitWriteBuffer bwb) throws Exception {
        if (this.pass == 3) {
            if (this.wayList.size() > 0) {
                ArrayList<WayData> goodWays = new ArrayList<WayData>();
                for (WayData w : this.wayList) {
                    if (w.startNodeIdx < 0) continue;
                    goodWays.add(w);
                }
                WayData.sortByStartNode(goodWays);
                this.wayList = goodWays;
            }
            int waycount = this.wayList.size();
            long[] startIndexes = new long[waycount];
            int i = 0;
            for (WayData w : this.wayList) {
                w.nativeIndex = i;
                startIndexes[i++] = w.startNodeIdx;
            }
            bwb.encodeSortedArray(startIndexes);
            if (this.dostats) {
                bwb.assignBits("way-start-idx");
            }
        }
        for (WayData way : this.wayList) {
            this.encodeWay(bwb, way);
        }
    }

    private void writeRelations(BitWriteBuffer bwb) throws Exception {
        bwb.encodeInt(this.relationList.size());
        if (this.dostats) {
            bwb.assignBits("relation-count");
        }
        for (RelationData rel : this.relationList) {
            this.encodeRelation(bwb, rel);
        }
    }

    private void encodeRelation(BitWriteBuffer bwb, RelationData rel) throws Exception {
        WayData w;
        String role;
        long wid;
        int i;
        this.writeTags(rel.getTagsOrNull());
        int size = rel.ways.size();
        if (this.dostats) {
            bwb.assignBits("way-node-count");
        }
        int validMembers = 0;
        for (i = 0; i < size; ++i) {
            wid = rel.ways.get(i);
            role = rel.roles.get(i);
            this.templateWay.wid = wid;
            w = this.wayMap.get(this.templateWay);
            if (w == null) continue;
            ++validMembers;
        }
        bwb.encodeInt(validMembers);
        for (i = 0; i < size; ++i) {
            wid = rel.ways.get(i);
            role = rel.roles.get(i);
            this.templateWay.wid = wid;
            w = this.wayMap.get(this.templateWay);
            if (w == null) continue;
            int zoomDelta = this.tile.zoom - w.zoom;
            bwb.encodeInt(zoomDelta);
            bwb.encodeInt(w.nativeIndex);
            this.tagValueEncoder.encodeValue(bwb, "role", role);
        }
    }

    private void writeTaggedNodes() throws Exception {
        int idx;
        int cnt = 0;
        for (int idx2 = 0; idx2 < this.tile.nodeList.size(); ++idx2) {
            NodeData n = this.tile.nodeList.get(idx2);
            if (n.zoom != this.tile.zoom || n.getTagsOrNull() == null) continue;
            ++cnt;
        }
        long[] taggedIndexes = new long[cnt];
        int i = 0;
        for (idx = 0; idx < this.tile.nodeList.size(); ++idx) {
            if (this.tile.nodeList.get(idx).getTagsOrNull() == null) continue;
            taggedIndexes[i++] = idx;
        }
        this.nTaggedNodes = cnt;
        this.bwb.encodeSortedArray(taggedIndexes);
        if (this.dostats) {
            this.bwb.assignBits("tagged-node-idx");
        }
        for (idx = 0; idx < this.tile.nodeList.size(); ++idx) {
            NodeData n = this.tile.nodeList.get(idx);
            if (n.getTagsOrNull() == null) continue;
            this.writeTags(n.getTagsOrNull());
        }
    }

    private void writeTags(HashMap<String, String> tags) throws Exception {
        List<String> names;
        if (tags == null) {
            tags = new HashMap();
        }
        if (this.pass > 1) {
            names = this.tagValueEncoder.sortTagNames(tags.keySet());
            int ntags = names.size();
            int[] tagset = new int[ntags];
            for (int i = 0; i < ntags; ++i) {
                tagset[i] = this.tagValueEncoder.getTagIndex(names.get(i));
            }
            this.tagSetEnoder.encodeTagSet(tagset);
            if (this.dostats) {
                this.bwb.assignBits("tag-set");
            }
        } else {
            ++this.nTagSets;
            names = new ArrayList<String>(tags.keySet());
        }
        this.tagValueEncoder.startTagSet();
        for (String name : names) {
            String value = tags.get(name);
            this.tagValueEncoder.encodeValue(this.bwb, name, value);
            if (!this.dostats) continue;
            this.bwb.assignBits("value-index");
        }
    }
}

