/*
 * Decompiled with CFR 0.152.
 */
package btools.mapsplitter;

import btools.mapsplitter.MapCreatorBase;
import btools.util.LongList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RelationData
extends MapCreatorBase {
    public long rid;
    public LongList ways;
    public List<String> roles;

    public RelationData(long id, LongList ways, List<String> roles) {
        this.rid = id;
        this.ways = ways;
        this.roles = roles;
    }

    public RelationData(DataInputStream di) throws Exception {
        long wid;
        String key;
        this.ways = new LongList(16);
        this.roles = new ArrayList<String>();
        this.rid = RelationData.readId(di);
        while ((key = di.readUTF()).length() != 0) {
            String value = di.readUTF();
            this.putTag(key, value);
        }
        while ((wid = RelationData.readId(di)) != -1L) {
            this.ways.add(wid);
            this.roles.add(di.readUTF());
        }
    }

    public void writeTo(DataOutputStream dos) throws Exception {
        RelationData.writeId(dos, this.rid);
        if (this.getTagsOrNull() != null) {
            for (Map.Entry<String, String> me : this.getTagsOrNull().entrySet()) {
                if (me.getKey().length() <= 0) continue;
                dos.writeUTF(me.getKey());
                dos.writeUTF(me.getValue());
            }
        }
        dos.writeUTF("");
        int size = this.ways.size();
        for (int i = 0; i < size; ++i) {
            RelationData.writeId(dos, this.ways.get(i));
            dos.writeUTF(this.roles.get(i));
        }
        RelationData.writeId(dos, -1L);
    }
}

