/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.codec.MicroCache;
import btools.codec.MicroCache2;
import btools.mapcreator.OsmLinkP;
import btools.mapcreator.RestrictionData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class OsmNodeP
extends OsmLinkP {
    public int ilat;
    public int ilon;
    public short selev;
    public static final int NO_BRIDGE_BIT = 1;
    public static final int NO_TUNNEL_BIT = 2;
    public static final int BORDER_BIT = 4;
    public static final int TRAFFIC_BIT = 8;
    public static final int ANY_WAY_BIT = 16;
    public static final int MULTI_WAY_BIT = 32;
    public byte bits = 0;

    public int getILat() {
        return this.ilat;
    }

    public int getILon() {
        return this.ilon;
    }

    public short getSElev() {
        return (this.bits & 1) == 0 || (this.bits & 2) == 0 ? (short)Short.MIN_VALUE : this.selev;
    }

    public double getElev() {
        return (double)this.selev / 4.0;
    }

    public OsmLinkP createLink(OsmNodeP source) {
        if (this.sourceNode == null && this.targetNode == null) {
            this.sourceNode = source;
            this.targetNode = this;
            source.addLink(this);
            return this;
        }
        OsmLinkP link = new OsmLinkP(source, this);
        this.addLink(link);
        source.addLink(link);
        return link;
    }

    public void addLink(OsmLinkP link) {
        link.setNext(this.previous, this);
        this.previous = link;
    }

    public OsmLinkP getFirstLink() {
        return this.sourceNode == null && this.targetNode == null ? this.previous : this;
    }

    public byte[] getNodeDecsription() {
        return null;
    }

    public RestrictionData getFirstRestriction() {
        return null;
    }

    public void writeNodeData(MicroCache mc) throws IOException {
        boolean valid = true;
        if (!(mc instanceof MicroCache2)) {
            throw new IllegalArgumentException("unknown cache version: " + mc.getClass());
        }
        valid = this.writeNodeData2((MicroCache2)mc);
        if (valid) {
            mc.finishNode(this.getIdFromPos());
        } else {
            mc.discardNode();
        }
    }

    public void checkDuplicateTargets() {
        HashMap<OsmNodeP, OsmLinkP> targets = new HashMap<OsmNodeP, OsmLinkP>();
        for (OsmLinkP link0 = this.getFirstLink(); link0 != null; link0 = link0.getNext(this)) {
            OsmLinkP oldLink;
            OsmLinkP link = link0;
            OsmNodeP origin = this;
            OsmNodeP target = null;
            while (link != null && (target = link.getTarget(origin)).isTransferNode()) {
                for (link = target.getFirstLink(); link != null && link.getTarget(target) == origin; link = link.getNext(target)) {
                }
                origin = target;
            }
            if (link == null || (oldLink = targets.put(target, link0)) == null) continue;
            this.unifyLink(oldLink);
            this.unifyLink(link0);
        }
    }

    private void unifyLink(OsmLinkP link) {
        if (link.isReverse(this)) {
            return;
        }
        OsmNodeP target = link.getTarget(this);
        if (target.isTransferNode()) {
            target.incWayCount();
        }
    }

    public boolean writeNodeData2(MicroCache2 mc) throws IOException {
        boolean hasLinks = false;
        RestrictionData r = this.getFirstRestriction();
        while (r != null) {
            if (r.fromLon != 0 && r.toLon != 0) {
                mc.writeBoolean(true);
                mc.writeShort(r.exceptions);
                mc.writeBoolean(r.isPositive);
                mc.writeInt(r.fromLon);
                mc.writeInt(r.fromLat);
                mc.writeInt(r.toLon);
                mc.writeInt(r.toLat);
            }
            r = r.next;
        }
        mc.writeBoolean(false);
        mc.writeShort(this.getSElev());
        mc.writeVarBytes(this.getNodeDecsription());
        ArrayList<OsmNodeP> internalReverse = new ArrayList<OsmNodeP>();
        for (OsmLinkP link0 = this.getFirstLink(); link0 != null; link0 = link0.getNext(this)) {
            OsmLinkP link = link0;
            OsmNodeP origin = this;
            OsmNodeP target = null;
            while (link != null && (target = link.getTarget(origin)).isTransferNode()) {
                for (link = target.getFirstLink(); link != null && link.getTarget(target) == origin; link = link.getNext(target)) {
                }
                if (link != null && link.descriptionBitmap != link0.descriptionBitmap) {
                    throw new IllegalArgumentException("assertion failed: description change along transfer nodes");
                }
                origin = target;
            }
            if (link == null || target == this) continue;
            hasLinks = true;
            boolean isReverse = link0.isReverse(this);
            if (isReverse && mc.isInternal(target.ilon, target.ilat)) {
                internalReverse.add(target);
                continue;
            }
            int sizeoffset = mc.writeSizePlaceHolder();
            mc.writeVarLengthSigned(target.ilon - this.ilon);
            mc.writeVarLengthSigned(target.ilat - this.ilat);
            mc.writeModeAndDesc(isReverse, link0.descriptionBitmap);
            if (!isReverse) {
                OsmNodeP tranferNode;
                link = link0;
                origin = this;
                while (link != null && (tranferNode = link.getTarget(origin)).isTransferNode()) {
                    mc.writeVarLengthSigned(tranferNode.ilon - origin.ilon);
                    mc.writeVarLengthSigned(tranferNode.ilat - origin.ilat);
                    mc.writeVarLengthSigned(tranferNode.getSElev() - origin.getSElev());
                    for (link = tranferNode.getFirstLink(); link != null && link.getTarget(tranferNode) == origin; link = link.getNext(tranferNode)) {
                    }
                    if (link == null) {
                        throw new RuntimeException("follow-up link not found for transfer-node!");
                    }
                    origin = tranferNode;
                }
            }
            mc.injectSize(sizeoffset);
        }
        while (internalReverse.size() > 0) {
            int nextIdx = 0;
            if (internalReverse.size() > 1) {
                int max32 = Integer.MIN_VALUE;
                for (int i = 0; i < internalReverse.size(); ++i) {
                    int id32 = mc.shrinkId(((OsmNodeP)internalReverse.get(i)).getIdFromPos());
                    if (id32 <= max32) continue;
                    max32 = id32;
                    nextIdx = i;
                }
            }
            OsmNodeP target = (OsmNodeP)internalReverse.remove(nextIdx);
            int sizeoffset = mc.writeSizePlaceHolder();
            mc.writeVarLengthSigned(target.ilon - this.ilon);
            mc.writeVarLengthSigned(target.ilat - this.ilat);
            mc.writeModeAndDesc(true, null);
            mc.injectSize(sizeoffset);
        }
        return hasLinks;
    }

    public String toString2() {
        return this.ilon - 180000000 + "_" + (this.ilat - 90000000) + "_" + this.selev / 4;
    }

    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public boolean isBorderNode() {
        return (this.bits & 4) != 0;
    }

    public boolean hasTraffic() {
        return (this.bits & 8) != 0;
    }

    public void incWayCount() {
        if ((this.bits & 0x10) != 0) {
            this.bits = (byte)(this.bits | 0x20);
        }
        this.bits = (byte)(this.bits | 0x10);
    }

    public boolean isTransferNode() {
        return (this.bits & 4) == 0 && (this.bits & 0x20) == 0 && this._linkCnt() == 2;
    }

    private int _linkCnt() {
        int cnt = 0;
        for (OsmLinkP link = this.getFirstLink(); link != null; link = link.getNext(this)) {
            ++cnt;
        }
        return cnt;
    }
}

