/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.RasterCoder;
import btools.mapcreator.SrtmRaster;
import btools.util.MixCoderDataOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ConvertSrtmTile {
    public static int NROWS;
    public static int NCOLS;
    public static final short SKIPDATA = -32766;
    public static final short NODATA2 = -32767;
    public static final short NODATA = Short.MIN_VALUE;
    static short[] imagePixels;
    public static int[] diffs;

    private static void readBilZip(String filename, int rowOffset, int colOffset, boolean halfCols) throws Exception {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(filename)));
        try {
            while (true) {
                ZipEntry ze;
                if (!(ze = zis.getNextEntry()).getName().endsWith(".bil")) continue;
                ConvertSrtmTile.readBilFromStream(zis, rowOffset, colOffset, halfCols);
                return;
            }
        }
        finally {
            zis.close();
        }
    }

    private static void readBilFromStream(InputStream is, int rowOffset, int colOffset, boolean halfCols) throws Exception {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
        for (int ir = 0; ir < 3601; ++ir) {
            int row = rowOffset + ir;
            for (int ic = 0; ic < 3601; ++ic) {
                int col = colOffset + ic;
                if (ic % 2 == 1 && halfCols) {
                    if (ConvertSrtmTile.getPixel(row, col) != Short.MIN_VALUE) continue;
                    ConvertSrtmTile.setPixel(row, col, (short)-32766);
                    continue;
                }
                int i0 = dis.read();
                int i1 = dis.read();
                if (i0 == -1 || i1 == -1) {
                    throw new RuntimeException("unexcepted end of file reading bil entry!");
                }
                short val = (short)(i1 << 8 | i0);
                if (val == -32767) {
                    val = Short.MIN_VALUE;
                }
                ConvertSrtmTile.setPixel(row, col, val);
            }
        }
    }

    private static void setPixel(int row, int col, short val) {
        if (row >= 0 && row < NROWS && col >= 0 && col < NCOLS) {
            ConvertSrtmTile.imagePixels[row * ConvertSrtmTile.NCOLS + col] = val;
        }
    }

    private static short getPixel(int row, int col) {
        if (row >= 0 && row < NROWS && col >= 0 && col < NCOLS) {
            return imagePixels[row * NCOLS + col];
        }
        return Short.MIN_VALUE;
    }

    public static void doConvert(String inputDir, String v1Dir, int lonDegreeStart, int latDegreeStart, String outputFile, SrtmRaster raster90) throws Exception {
        int extraBorder = 10;
        int datacells = 0;
        int mismatches = 0;
        NROWS = 18001 + 2 * extraBorder;
        NCOLS = 18001 + 2 * extraBorder;
        imagePixels = new short[NROWS * NCOLS];
        for (int row = 0; row < NROWS; ++row) {
            for (int col = 0; col < NCOLS; ++col) {
                ConvertSrtmTile.imagePixels[row * ConvertSrtmTile.NCOLS + col] = Short.MIN_VALUE;
            }
        }
        for (int latIdx = -1; latIdx <= 5; ++latIdx) {
            int latDegree = latDegreeStart + latIdx;
            int rowOffset = extraBorder + (4 - latIdx) * 3600;
            for (int lonIdx = -1; lonIdx <= 5; ++lonIdx) {
                int lonDegree = lonDegreeStart + lonIdx;
                int colOffset = extraBorder + lonIdx * 3600;
                String filename = inputDir + "/" + ConvertSrtmTile.formatLat(latDegree) + "_" + ConvertSrtmTile.formatLon(lonDegree) + "_1arc_v3_bil.zip";
                File f = new File(filename);
                if (f.exists() && f.length() > 0L) {
                    System.out.println("exist: " + filename);
                    boolean halfCol = latDegree >= 50 || latDegree < -50;
                    ConvertSrtmTile.readBilZip(filename, rowOffset, colOffset, halfCol);
                    continue;
                }
                System.out.println("none : " + filename);
            }
        }
        boolean halfCol5 = latDegreeStart >= 50 || latDegreeStart < -50;
        for (int row90 = 0; row90 < 6001; ++row90) {
            int crow = 3 * row90 + extraBorder;
            for (int col90 = 0; col90 < 6001; ++col90) {
                boolean doReplace;
                int ccol = 3 * col90 + extraBorder;
                if (raster90 == null || halfCol5 && col90 % 2 != 0) continue;
                short v90 = raster90.eval_array[row90 * 6001 + col90];
                int sum = 0;
                int nodatas = 0;
                int datas = 0;
                int colstep = halfCol5 ? 2 : 1;
                for (int row = crow - 1; row <= crow + 1; ++row) {
                    for (int col = ccol - colstep; col <= ccol + colstep; col += colstep) {
                        short v30 = imagePixels[row * NCOLS + col];
                        if (v30 == Short.MIN_VALUE) {
                            ++nodatas;
                            continue;
                        }
                        if (v30 == -32766) continue;
                        sum += v30;
                        ++datas;
                    }
                }
                boolean bl = doReplace = nodatas > 0 || v90 == Short.MIN_VALUE || datas < 7;
                if (!doReplace) {
                    ++datacells;
                    int diff = sum - datas * v90;
                    if (diff < -4 || diff > 4) {
                        doReplace = true;
                        ++mismatches;
                    }
                    if (diff > -50 && diff < 50 && row90 % 1200 != 0 && col90 % 1200 != 0) {
                        int n = diff + 50;
                        diffs[n] = diffs[n] + 1;
                    }
                }
                if (!doReplace) continue;
                for (int row = crow - 1; row <= crow + 1; ++row) {
                    for (int col = ccol - colstep; col <= ccol + colstep; col += colstep) {
                        ConvertSrtmTile.imagePixels[row * ConvertSrtmTile.NCOLS + col] = v90;
                    }
                }
            }
        }
        SrtmRaster raster = new SrtmRaster();
        raster.nrows = NROWS;
        raster.ncols = NCOLS;
        raster.halfcol = halfCol5;
        raster.noDataValue = Short.MIN_VALUE;
        raster.cellsize = 2.777777777777778E-4;
        raster.xllcorner = (double)lonDegreeStart - (0.5 + (double)extraBorder) * raster.cellsize;
        raster.yllcorner = (double)latDegreeStart - (0.5 + (double)extraBorder) * raster.cellsize;
        raster.eval_array = imagePixels;
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));
        new RasterCoder().encodeRaster(raster, os);
        ((OutputStream)os).close();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(outputFile));
        SrtmRaster raster2 = new RasterCoder().decodeRaster(is);
        ((InputStream)is).close();
        short[] pix2 = raster2.eval_array;
        if (pix2.length != imagePixels.length) {
            throw new RuntimeException("length mismatch!");
        }
        for (int row = 0; row < NROWS; ++row) {
            int colstep = halfCol5 ? 2 : 1;
            for (int col = 0; col < NCOLS; col += colstep) {
                int idx = row * NCOLS + col;
                if (imagePixels[idx] == -32766) continue;
                short p2 = pix2[idx];
                if (p2 > -32766) {
                    p2 = (short)(p2 / 2);
                }
                if (p2 == imagePixels[idx]) continue;
                throw new RuntimeException("content mismatch!");
            }
        }
        for (int i = 1; i < 100; ++i) {
            System.out.println("diff[" + (i - 50) + "] = " + diffs[i]);
        }
        System.out.println("datacells=" + datacells + " mismatch%=" + 100.0 * (double)mismatches / (double)datacells);
        MixCoderDataOutputStream.stats();
    }

    private static void test(SrtmRaster raster) {
        int lat0 = 39828330;
        int lon0 = 3115280;
        for (int iy = -9; iy <= 9; ++iy) {
            StringBuilder sb = new StringBuilder();
            for (int ix = -9; ix <= 9; ++ix) {
                int lat = lat0 + 90000000 - 100 * iy;
                int lon = lon0 + 180000000 + 100 * ix;
                int ival = (int)((double)raster.getElevation(lon, lat) / 4.0);
                String sval = "     " + ival;
                sb.append(sval.substring(sval.length() - 4));
            }
            System.out.println(sb);
            System.out.println();
        }
    }

    private static String formatLon(int lon) {
        if (lon >= 180) {
            lon -= 180;
        }
        String s = "e";
        if (lon < 0) {
            lon = -lon;
            s = "w";
        }
        String n = "000" + lon;
        return s + n.substring(n.length() - 3);
    }

    private static String formatLat(int lat) {
        String s = "n";
        if (lat < 0) {
            lat = -lat;
            s = "s";
        }
        String n = "00" + lat;
        return s + n.substring(n.length() - 2);
    }

    static {
        diffs = new int[100];
    }
}

