/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.DataBuffers;
import btools.codec.MicroCache;
import btools.codec.WaypointMatcher;
import btools.expressions.BExpressionContextWay;
import btools.mapaccess.OsmFile;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.PhysicalFile;
import btools.mapaccess.StorageConfigHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public final class NodesCache {
    private File segmentDir;
    private File secondarySegmentsDir = null;
    private OsmNodesMap nodesMap;
    private BExpressionContextWay expCtxWay;
    private int lookupVersion;
    private int lookupMinorVersion;
    private boolean forceSecondaryData;
    private String currentFileName;
    private HashMap<String, PhysicalFile> fileCache;
    private DataBuffers dataBuffers;
    private OsmFile[][] fileRows;
    public WaypointMatcher waypointMatcher;
    public boolean first_file_access_failed = false;
    public String first_file_access_name;
    private long cacheSum = 0L;
    private long maxmem;
    private boolean detailed;
    private boolean garbageCollectionEnabled = false;
    private boolean ghostCleaningDone = false;
    private long cacheSumClean = 0L;
    private long ghostSum = 0L;
    private long ghostWakeup = 0L;

    public String formatStatus() {
        return "collecting=" + this.garbageCollectionEnabled + " noGhosts=" + this.ghostCleaningDone + " cacheSum=" + this.cacheSum + " cacheSumClean=" + this.cacheSumClean + " ghostSum=" + this.ghostSum + " ghostWakeup=" + this.ghostWakeup;
    }

    public NodesCache(String segmentDir, OsmNodesMap nodesMap, BExpressionContextWay ctxWay, boolean forceSecondaryData, long maxmem, NodesCache oldCache, boolean detailed) {
        this.segmentDir = new File(segmentDir);
        this.nodesMap = nodesMap;
        this.expCtxWay = ctxWay;
        this.lookupVersion = ctxWay.meta.lookupVersion;
        this.lookupMinorVersion = ctxWay.meta.lookupMinorVersion;
        this.forceSecondaryData = forceSecondaryData;
        this.maxmem = maxmem;
        this.detailed = detailed;
        if (ctxWay != null) {
            ctxWay.setDecodeForbidden(detailed);
        }
        this.first_file_access_failed = false;
        this.first_file_access_name = null;
        if (!this.segmentDir.isDirectory()) {
            throw new RuntimeException("segment directory " + segmentDir + " does not exist");
        }
        if (oldCache != null) {
            this.fileCache = oldCache.fileCache;
            this.dataBuffers = oldCache.dataBuffers;
            this.secondarySegmentsDir = oldCache.secondarySegmentsDir;
            if (oldCache.detailed == detailed) {
                for (OsmFile[] fileRow : this.fileRows = oldCache.fileRows) {
                    if (fileRow == null) continue;
                    for (OsmFile osmf : fileRow) {
                        this.cacheSum += osmf.setGhostState();
                    }
                }
            } else {
                this.fileRows = new OsmFile[180][];
            }
        } else {
            this.fileCache = new HashMap(4);
            this.fileRows = new OsmFile[180][];
            this.dataBuffers = new DataBuffers();
            this.secondarySegmentsDir = StorageConfigHelper.getSecondarySegmentDir(segmentDir);
        }
        this.ghostSum = this.cacheSum;
    }

    public void cleanNonVirgin() {
        for (OsmFile[] fileRow : this.fileRows) {
            if (fileRow == null) continue;
            for (OsmFile osmf : fileRow) {
                osmf.cleanNonVirgin();
            }
        }
    }

    private void checkEnableCacheCleaning() {
        if (this.cacheSum < this.maxmem) {
            return;
        }
        for (int i = 0; i < this.fileRows.length; ++i) {
            OsmFile[] fileRow = this.fileRows[i];
            if (fileRow == null) continue;
            for (OsmFile osmf : fileRow) {
                if (this.garbageCollectionEnabled && !this.ghostCleaningDone) {
                    this.cacheSum -= osmf.cleanGhosts();
                    continue;
                }
                this.cacheSum -= osmf.collectAll();
            }
        }
        if (this.garbageCollectionEnabled) {
            this.ghostCleaningDone = true;
            this.maxmem *= 2L;
        } else {
            this.cacheSumClean = this.cacheSum;
            this.garbageCollectionEnabled = true;
        }
    }

    public int loadSegmentFor(int ilon, int ilat) {
        MicroCache mc = this.getSegmentFor(ilon, ilat);
        return mc == null ? 0 : mc.getSize();
    }

    public MicroCache getSegmentFor(int ilon, int ilat) {
        try {
            int lonDegree = ilon / 1000000;
            int latDegree = ilat / 1000000;
            OsmFile osmf = null;
            OsmFile[] fileRow = this.fileRows[latDegree];
            int ndegrees = fileRow == null ? 0 : fileRow.length;
            for (int i = 0; i < ndegrees; ++i) {
                if (fileRow[i].lonDegree != lonDegree) continue;
                osmf = fileRow[i];
                break;
            }
            if (osmf == null) {
                osmf = this.fileForSegment(lonDegree, latDegree);
                OsmFile[] newFileRow = new OsmFile[ndegrees + 1];
                for (int i = 0; i < ndegrees; ++i) {
                    newFileRow[i] = fileRow[i];
                }
                newFileRow[ndegrees] = osmf;
                this.fileRows[latDegree] = newFileRow;
            }
            this.currentFileName = osmf.filename;
            if (!osmf.hasData()) {
                return null;
            }
            MicroCache segment = osmf.getMicroCache(ilon, ilat);
            if (segment == null) {
                this.checkEnableCacheCleaning();
                segment = osmf.createMicroCache(ilon, ilat, this.dataBuffers, this.expCtxWay, this.waypointMatcher);
                this.cacheSum += (long)segment.getDataSize();
            } else if (segment.ghost) {
                segment.unGhost();
                this.ghostWakeup += (long)segment.getDataSize();
            }
            return segment;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("error reading datafile " + this.currentFileName + ": " + e, e);
        }
    }

    public boolean obtainNonHollowNode(OsmNode node) {
        if (!node.isHollow()) {
            return true;
        }
        MicroCache segment = this.getSegmentFor(node.ilon, node.ilat);
        if (segment == null) {
            return false;
        }
        long id = node.getIdFromPos();
        if (segment.getAndClear(id)) {
            node.parseNodeBody(segment, this.nodesMap, this.expCtxWay);
        }
        if (this.garbageCollectionEnabled) {
            this.cacheSum -= (long)segment.collect(segment.getSize() >> 1);
        }
        return !node.isHollow();
    }

    private OsmFile fileForSegment(int lonDegree, int latDegree) throws Exception {
        int lonMod5 = lonDegree % 5;
        int latMod5 = latDegree % 5;
        int lon = lonDegree - 180 - lonMod5;
        String slon = lon < 0 ? "W" + -lon : "E" + lon;
        int lat = latDegree - 90 - latMod5;
        String slat = lat < 0 ? "S" + -lat : "N" + lat;
        String filenameBase = slon + "_" + slat;
        this.currentFileName = filenameBase + ".rd5";
        PhysicalFile ra = null;
        if (!this.fileCache.containsKey(filenameBase)) {
            File secondary;
            File primary;
            File f = null;
            if (!this.forceSecondaryData && (primary = new File(this.segmentDir, filenameBase + ".rd5")).exists()) {
                f = primary;
            }
            if (f == null && (secondary = new File(this.secondarySegmentsDir, filenameBase + ".rd5")).exists()) {
                f = secondary;
            }
            if (f != null) {
                this.currentFileName = f.getName();
                ra = new PhysicalFile(f, this.dataBuffers, this.lookupVersion, this.lookupMinorVersion);
            }
            this.fileCache.put(filenameBase, ra);
        }
        ra = this.fileCache.get(filenameBase);
        OsmFile osmf = new OsmFile(ra, lonDegree, latDegree, this.dataBuffers);
        if (this.first_file_access_name == null) {
            this.first_file_access_name = this.currentFileName;
            this.first_file_access_failed = osmf.filename == null;
        }
        return osmf;
    }

    public void close() {
        for (PhysicalFile f : this.fileCache.values()) {
            try {
                if (f == null) continue;
                f.ra.close();
            }
            catch (IOException iOException) {}
        }
    }
}

