/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.router.MessageData;
import java.util.ArrayList;
import java.util.List;

public class VoiceHint {
    static final int C = 1;
    static final int TL = 2;
    static final int TSLL = 3;
    static final int TSHL = 4;
    static final int TR = 5;
    static final int TSLR = 6;
    static final int TSHR = 7;
    static final int KL = 8;
    static final int KR = 9;
    static final int TU = 10;
    static final int TRU = 11;
    static final int OFFR = 12;
    static final int RNDB = 13;
    static final int RNLB = 14;
    int ilon;
    int ilat;
    int cmd;
    MessageData oldWay;
    MessageData goodWay;
    List<MessageData> badWays;
    double distanceToNext;
    int indexInTrack;
    float angle;
    boolean turnAngleConsumed;
    boolean needsRealTurn;
    int roundaboutExit;

    boolean isRoundabout() {
        return this.roundaboutExit != 0;
    }

    public void addBadWay(MessageData badWay) {
        if (badWay == null) {
            return;
        }
        if (this.badWays == null) {
            this.badWays = new ArrayList<MessageData>();
        }
        this.badWays.add(badWay);
    }

    public String getCommandString() {
        switch (this.cmd) {
            case 10: {
                return "TU";
            }
            case 4: {
                return "TSHL";
            }
            case 2: {
                return "TL";
            }
            case 3: {
                return "TSLL";
            }
            case 8: {
                return "KL";
            }
            case 1: {
                return "C";
            }
            case 9: {
                return "KR";
            }
            case 6: {
                return "TSLR";
            }
            case 5: {
                return "TR";
            }
            case 7: {
                return "TSHR";
            }
            case 11: {
                return "TRU";
            }
            case 13: {
                return "RNDB" + this.roundaboutExit;
            }
            case 14: {
                return "RNLB" + -this.roundaboutExit;
            }
        }
        throw new IllegalArgumentException("unknown command: " + this.cmd);
    }

    public String getSymbolString() {
        switch (this.cmd) {
            case 10: {
                return "TU";
            }
            case 4: {
                return "TSHL";
            }
            case 2: {
                return "Left";
            }
            case 3: {
                return "TSLL";
            }
            case 8: {
                return "TSLL";
            }
            case 1: {
                return "Straight";
            }
            case 9: {
                return "TSLR";
            }
            case 6: {
                return "TSLR";
            }
            case 5: {
                return "Right";
            }
            case 7: {
                return "TSHR";
            }
            case 11: {
                return "TU";
            }
            case 13: {
                return "RNDB" + this.roundaboutExit;
            }
            case 14: {
                return "RNLB" + -this.roundaboutExit;
            }
        }
        throw new IllegalArgumentException("unknown command: " + this.cmd);
    }

    public String getMessageString() {
        switch (this.cmd) {
            case 10: {
                return "u-turn";
            }
            case 4: {
                return "sharp left";
            }
            case 2: {
                return "left";
            }
            case 3: {
                return "slight left";
            }
            case 8: {
                return "keep left";
            }
            case 1: {
                return "straight";
            }
            case 9: {
                return "keep right";
            }
            case 6: {
                return "slight right";
            }
            case 5: {
                return "right";
            }
            case 7: {
                return "sharp right";
            }
            case 11: {
                return "u-turn";
            }
            case 13: {
                return "Take exit " + this.roundaboutExit;
            }
            case 14: {
                return "Take exit " + -this.roundaboutExit;
            }
        }
        throw new IllegalArgumentException("unknown command: " + this.cmd);
    }

    public int getLocusAction() {
        switch (this.cmd) {
            case 10: {
                return 12;
            }
            case 4: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 8: {
                return 9;
            }
            case 1: {
                return 1;
            }
            case 9: {
                return 10;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 11: {
                return 12;
            }
            case 13: {
                return 26 + this.roundaboutExit;
            }
            case 14: {
                return 26 - this.roundaboutExit;
            }
        }
        throw new IllegalArgumentException("unknown command: " + this.cmd);
    }

    public void calcCommand() {
        if (this.roundaboutExit > 0) {
            this.cmd = 13;
        } else if (this.roundaboutExit < 0) {
            this.cmd = 14;
        } else if ((double)this.angle < -159.0) {
            this.cmd = 10;
        } else if ((double)this.angle < -113.0) {
            this.cmd = 4;
        } else if ((double)this.angle < -67.0) {
            this.cmd = 2;
        } else if ((double)this.angle < -21.0) {
            if (this.cmd != 9) {
                this.cmd = 3;
            }
        } else if ((double)this.angle < 21.0) {
            if (this.cmd != 9 && this.cmd != 8) {
                this.cmd = 1;
            }
        } else if ((double)this.angle < 67.0) {
            if (this.cmd != 8) {
                this.cmd = 6;
            }
        } else {
            this.cmd = (double)this.angle < 113.0 ? 5 : ((double)this.angle < 159.0 ? 7 : 11);
        }
    }

    public String formatGeometry() {
        float oldPrio = this.oldWay == null ? 0.0f : (float)this.oldWay.priorityclassifier;
        StringBuilder sb = new StringBuilder(30);
        sb.append(' ').append((int)oldPrio);
        this.appendTurnGeometry(sb, this.goodWay);
        if (this.badWays != null) {
            for (MessageData badWay : this.badWays) {
                sb.append(" ");
                this.appendTurnGeometry(sb, badWay);
            }
        }
        return sb.toString();
    }

    private void appendTurnGeometry(StringBuilder sb, MessageData msg) {
        sb.append("(").append((int)((double)msg.turnangle + 0.5)).append(")").append(msg.priorityclassifier);
    }
}

