/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.RasterCoder;
import btools.mapcreator.SrtmRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ConvertSrtmTile {
    public static int NROWS;
    public static int NCOLS;
    public static final short NODATA2 = -32767;
    public static final short NODATA = Short.MIN_VALUE;
    static short[] imagePixels;
    public static int[] diffs;

    private static void readBilZip(String filename, int rowOffset, int colOffset, boolean halfCols) throws Exception {
        int fileRows = 3601;
        int fileCols = 3601;
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(filename)));
        try {
            while (true) {
                ZipEntry ze;
                if (!(ze = zis.getNextEntry()).getName().endsWith(".bil")) continue;
                ConvertSrtmTile.readBilFromStream(zis, rowOffset, colOffset, fileRows, fileCols, halfCols);
                return;
            }
        }
        finally {
            zis.close();
        }
    }

    private static void readBilFromStream(InputStream is, int rowOffset, int colOffset, int fileRows, int fileCols, boolean halfCols) throws Exception {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
        for (int ir = 0; ir < fileRows; ++ir) {
            int row = rowOffset + ir;
            short lastVal = 0;
            boolean fillGap = false;
            for (int ic = 0; ic < fileCols; ++ic) {
                int col = colOffset + ic;
                if (ic % 2 == 1 && halfCols) {
                    fillGap = true;
                    continue;
                }
                int i0 = dis.read();
                int i1 = dis.read();
                if (i0 == -1 || i1 == -1) {
                    throw new RuntimeException("unexcepted end of file reading bil entry!");
                }
                short val = (short)(i1 << 8 | i0);
                if (val == -32767) {
                    val = Short.MIN_VALUE;
                }
                if (fillGap) {
                    ConvertSrtmTile.setPixel(row, col - 1, val, lastVal);
                    fillGap = false;
                }
                if (row == 18010) {
                    System.out.print(val + " ");
                }
                ConvertSrtmTile.setPixel(row, col, val, val);
                lastVal = val;
            }
        }
    }

    private static void setPixel(int row, int col, short val1, short val2) {
        if (row >= 0 && row < NROWS && col >= 0 && col < NCOLS && val1 != Short.MIN_VALUE && val2 != Short.MIN_VALUE) {
            int val = val1 + val2;
            if (val < Short.MIN_VALUE || val > Short.MAX_VALUE) {
                throw new IllegalArgumentException("val1=" + val1 + " val2=" + val2);
            }
            ConvertSrtmTile.imagePixels[row * ConvertSrtmTile.NCOLS + col] = (short)val;
        }
    }

    public static void main(String[] args) throws Exception {
        ConvertSrtmTile.doConvert(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]), args[3], null);
    }

    public static void doConvert(String inputDir, int lonDegreeStart, int latDegreeStart, String outputFile, SrtmRaster raster90) throws Exception {
        int i;
        int extraBorder = 10;
        int datacells = 0;
        int matchingdatacells = 0;
        NROWS = 18001 + 2 * extraBorder;
        NCOLS = 18001 + 2 * extraBorder;
        imagePixels = new short[NROWS * NCOLS];
        for (int row = 0; row < NROWS; ++row) {
            for (int col = 0; col < NCOLS; ++col) {
                ConvertSrtmTile.imagePixels[row * ConvertSrtmTile.NCOLS + col] = Short.MIN_VALUE;
            }
        }
        for (int latIdx = -1; latIdx <= 5; ++latIdx) {
            int latDegree = latDegreeStart + latIdx;
            int rowOffset = extraBorder + (4 - latIdx) * 3600;
            for (int lonIdx = -1; lonIdx <= 5; ++lonIdx) {
                int lonDegree = lonDegreeStart + lonIdx;
                int colOffset = extraBorder + lonIdx * 3600;
                String filename = inputDir + "/" + ConvertSrtmTile.formatLat(latDegree) + "_" + ConvertSrtmTile.formatLon(lonDegree) + "_1arc_v3_bil.zip";
                File f = new File(filename);
                if (f.exists() && f.length() > 0L) {
                    System.out.println("exist: " + filename);
                    boolean halfCol = latDegree >= 50 || latDegree < -50;
                    ConvertSrtmTile.readBilZip(filename, rowOffset, colOffset, halfCol);
                    continue;
                }
                System.out.println("none : " + filename);
            }
        }
        if (raster90 != null) {
            for (int row90 = 0; row90 < 6001; ++row90) {
                int crow = 3 * row90 + extraBorder;
                for (int col90 = 0; col90 < 6001; ++col90) {
                    int ccol = 3 * col90 + extraBorder;
                    short v90 = raster90.eval_array[row90 * 6001 + col90];
                    int sum = 0;
                    int nodatas = 0;
                    for (int row = crow - 1; row <= crow + 1; ++row) {
                        for (int col = ccol - 1; col <= ccol + 1; ++col) {
                            short v30 = imagePixels[row * NCOLS + col];
                            sum += v30;
                            if (v30 != Short.MIN_VALUE) continue;
                            ++nodatas;
                        }
                    }
                    boolean doReplace = nodatas > 0 || v90 == Short.MIN_VALUE;
                    int replaceValue = Short.MIN_VALUE;
                    if (!doReplace) {
                        ++datacells;
                        int diff = sum - 9 * v90;
                        replaceValue = (short)(diff / 9);
                        doReplace = true;
                        if (diff < -9 || diff > 9) {
                            doReplace = true;
                        }
                        if (diff > -50 && diff < 50) {
                            ++matchingdatacells;
                            int n = diff + 50;
                            diffs[n] = diffs[n] + 1;
                        }
                    }
                    if (!doReplace) continue;
                    for (int row = crow - 1; row <= crow + 1; ++row) {
                        for (int col = ccol - 1; col <= ccol + 1; ++col) {
                            ConvertSrtmTile.imagePixels[row * ConvertSrtmTile.NCOLS + col] = replaceValue;
                        }
                    }
                }
            }
        }
        SrtmRaster raster = new SrtmRaster();
        raster.nrows = NROWS;
        raster.ncols = NCOLS;
        raster.noDataValue = Short.MIN_VALUE;
        raster.cellsize = 2.777777777777778E-4;
        raster.xllcorner = (double)lonDegreeStart - (0.5 + (double)extraBorder) * raster.cellsize;
        raster.yllcorner = (double)latDegreeStart - (0.5 + (double)extraBorder) * raster.cellsize;
        raster.eval_array = imagePixels;
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));
        new RasterCoder().encodeRaster(raster, os);
        ((OutputStream)os).close();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(outputFile));
        SrtmRaster raster2 = new RasterCoder().decodeRaster(is);
        ((InputStream)is).close();
        short[] pix2 = raster2.eval_array;
        if (pix2.length != imagePixels.length) {
            throw new RuntimeException("length mismatch!");
        }
        for (i = 0; i < pix2.length; ++i) {
            if (pix2[i] == imagePixels[i]) continue;
            throw new RuntimeException("content mismatch!");
        }
        for (i = 0; i < 100; ++i) {
            System.out.println("diff[" + (i - 50) + "] = " + diffs[i]);
        }
        System.out.println("datacells=" + datacells + " mismatch%=" + 100.0 * (double)(datacells - matchingdatacells) / (double)datacells);
    }

    private static void test(SrtmRaster raster) {
        int lat0 = 39828330;
        int lon0 = 3115280;
        for (int iy = -9; iy <= 9; ++iy) {
            StringBuilder sb = new StringBuilder();
            for (int ix = -9; ix <= 9; ++ix) {
                int lat = lat0 + 90000000 - 100 * iy;
                int lon = lon0 + 180000000 + 100 * ix;
                int ival = (int)((double)raster.getElevation(lon, lat) / 4.0);
                String sval = "     " + ival;
                sb.append(sval.substring(sval.length() - 4));
            }
            System.out.println(sb);
            System.out.println();
        }
    }

    private static String formatLon(int lon) {
        if (lon >= 180) {
            lon -= 180;
        }
        String s = "e";
        if (lon < 0) {
            lon = -lon;
            s = "w";
        }
        String n = "000" + lon;
        return s + n.substring(n.length() - 3);
    }

    private static String formatLat(int lat) {
        String s = "n";
        if (lat < 0) {
            lat = -lat;
            s = "s";
        }
        String n = "00" + lat;
        return s + n.substring(n.length() - 2);
    }

    static {
        diffs = new int[100];
    }
}

