/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.expressions.BExpression;
import btools.expressions.BExpressionLookupValue;
import btools.expressions.BExpressionMetaData;
import btools.expressions.BExpressionReceiver;
import btools.util.BitCoderContext;
import btools.util.Crc32;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;

public abstract class BExpressionContext {
    private static final String CONTEXT_TAG = "---context:";
    private String context;
    private boolean _inOurContext = false;
    private BufferedReader _br = null;
    private boolean _readerDone = false;
    private BExpressionReceiver _receiver;
    private Map<String, Integer> lookupNumbers = new HashMap<String, Integer>();
    private ArrayList<BExpressionLookupValue[]> lookupValues = new ArrayList();
    private ArrayList<String> lookupNames = new ArrayList();
    private ArrayList<int[]> lookupHistograms = new ArrayList();
    private boolean lookupDataFrozen = false;
    private int[] lookupData = new int[0];
    private byte[] abBuf = new byte[256];
    private Map<String, Integer> variableNumbers = new HashMap<String, Integer>();
    private float[] variableData;
    private byte[][] _arrayBitmap;
    private boolean[] _arrayInverse;
    private int[] _arrayCrc;
    private int currentHashBucket = -1;
    private byte[] currentByteArray = null;
    private boolean currentInverseDirection = false;
    public List<BExpression> expressionList;
    private int minWriteIdx;
    private int[] buildInVariableIdx;
    protected float[][] arrayBuildInVariablesCache;
    private int linenr;
    public BExpressionMetaData meta;
    private boolean lookupDataValid = false;
    private int parsedLines = 0;
    private boolean fixTagsWritten = false;
    public long requests;
    public long requests2;
    public long cachemisses;

    abstract String[] getBuildInVariableNames();

    protected float getBuildInVariable(int idx) {
        return this.arrayBuildInVariablesCache[idx][this.currentHashBucket];
    }

    protected BExpressionContext(String context, BExpressionMetaData meta) {
        this(context, 4096, meta);
    }

    protected BExpressionContext(String context, int hashSize, BExpressionMetaData meta) {
        this.context = context;
        this.meta = meta;
        if (meta != null) {
            meta.registerListener(context, this);
        }
        if (Boolean.getBoolean("disableExpressionCache")) {
            hashSize = 1;
        }
        this._arrayBitmap = new byte[hashSize][];
        this._arrayInverse = new boolean[hashSize];
        this._arrayCrc = new int[hashSize];
        int nBuildInVars = this.getBuildInVariableNames().length;
        this.arrayBuildInVariablesCache = new float[nBuildInVars][];
        for (int vi = 0; vi < nBuildInVars; ++vi) {
            this.arrayBuildInVariablesCache[vi] = new float[hashSize];
        }
    }

    public byte[] encode() {
        if (!this.lookupDataValid) {
            throw new IllegalArgumentException("internal error: encoding undefined data?");
        }
        return this.encode(this.lookupData);
    }

    public byte[] encode(int[] ld) {
        BitCoderContext ctx = new BitCoderContext(this.abBuf);
        ctx.encodeBit(ld[0] != 0);
        int skippedTags = 0;
        int nonNullTags = 0;
        for (int inum = 1; inum < this.lookupValues.size(); ++inum) {
            int d = ld[inum];
            if (d == 0) {
                ++skippedTags;
                continue;
            }
            ctx.encodeVarBits(skippedTags + 1);
            ++nonNullTags;
            skippedTags = 0;
            int dd = d < 2 ? 7 : (d < 9 ? d - 2 : d - 1);
            ctx.encodeVarBits(dd);
        }
        ctx.encodeVarBits(0);
        if (nonNullTags == 0) {
            return null;
        }
        int len = ctx.getEncodedLength();
        byte[] ab = new byte[len];
        System.arraycopy(this.abBuf, 0, ab, 0, len);
        int[] ld2 = new int[this.lookupValues.size()];
        this.decode(ld2, false, ab);
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            if (ld2[inum] == ld[inum]) continue;
            throw new RuntimeException("assertion failed encoding inum=" + inum + " val=" + ld[inum] + " " + this.getKeyValueDescription(false, ab));
        }
        return ab;
    }

    public void decode(byte[] ab) {
        this.decode(this.lookupData, false, ab);
        this.lookupDataValid = true;
    }

    private void decode(int[] ld, boolean inverseDirection, byte[] ab) {
        int delta;
        BitCoderContext ctx = new BitCoderContext(ab);
        ld[0] = inverseDirection ^ ctx.decodeBit() ? 2 : 0;
        int inum = 1;
        while ((delta = ctx.decodeVarBits()) != 0 && inum + delta <= ld.length) {
            int d;
            while (delta-- > 1) {
                ld[inum++] = 0;
            }
            int dd = ctx.decodeVarBits();
            int n = dd == 7 ? 1 : (d = dd < 7 ? dd + 2 : dd + 1);
            if (d >= this.lookupValues.get(inum).length) {
                d = 1;
            }
            ld[inum++] = d;
        }
        while (inum < ld.length) {
            ld[inum++] = 0;
        }
    }

    public String getKeyValueDescription(boolean inverseDirection, byte[] ab) {
        StringBuilder sb = new StringBuilder(200);
        this.decode(this.lookupData, inverseDirection, ab);
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            BExpressionLookupValue[] va = this.lookupValues.get(inum);
            String value = va[this.lookupData[inum]].toString();
            if (value == null || value.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(this.lookupNames.get(inum) + "=" + value);
        }
        return sb.toString();
    }

    public void parseMetaLine(String line) {
        ++this.parsedLines;
        StringTokenizer tk = new StringTokenizer(line, " ");
        String name = tk.nextToken();
        String value = tk.nextToken();
        int idx = name.indexOf(59);
        if (idx >= 0) {
            name = name.substring(0, idx);
        }
        if (!this.fixTagsWritten) {
            this.fixTagsWritten = true;
            if ("way".equals(this.context)) {
                this.addLookupValue("reversedirection", "yes", null);
            } else if ("node".equals(this.context)) {
                this.addLookupValue("nodeaccessgranted", "yes", null);
            }
        }
        if ("reversedirection".equals(name)) {
            return;
        }
        if ("nodeaccessgranted".equals(name)) {
            return;
        }
        BExpressionLookupValue newValue = this.addLookupValue(name, value, null);
        while (newValue != null && tk.hasMoreTokens()) {
            newValue.addAlias(tk.nextToken());
        }
    }

    public void finishMetaParsing() {
        if (this.parsedLines == 0 && !"global".equals(this.context)) {
            throw new IllegalArgumentException("lookup table does not contain data for context " + this.context + " (old version?)");
        }
        this.lookupDataFrozen = true;
    }

    public void evaluate(int[] lookupData2) {
        this.lookupData = lookupData2;
        for (BExpression exp : this.expressionList) {
            exp.evaluate(this);
        }
    }

    public boolean evaluate(boolean inverseDirection, byte[] ab, BExpressionReceiver receiver) {
        ++this.requests;
        this.lookupDataValid = false;
        int inverseBitByteIndex = 0;
        int lastHashBucket = this.currentHashBucket;
        int crc = Crc32.crcWithInverseBit(ab, inverseDirection ? inverseBitByteIndex : -1);
        int hashSize = this._arrayBitmap.length;
        this.currentHashBucket = (crc & 0xFFFFFFF) % hashSize;
        this.currentByteArray = ab;
        this.currentInverseDirection = inverseDirection;
        byte[] abBucket = this._arrayBitmap[this.currentHashBucket];
        boolean inverseBucket = this._arrayInverse[this.currentHashBucket];
        if (ab == abBucket && inverseBucket == inverseDirection) {
            return lastHashBucket == this.currentHashBucket;
        }
        ++this.requests2;
        boolean hashBucketEquals = false;
        if (crc == this._arrayCrc[this.currentHashBucket]) {
            int abLen = ab.length;
            if (abBucket != null && abBucket.length == ab.length) {
                hashBucketEquals = true;
                boolean isInverse = inverseDirection ^ inverseBucket;
                for (int i = 0; i < abLen; ++i) {
                    byte b = ab[i];
                    if (isInverse && i == inverseBitByteIndex) {
                        b = (byte)(b ^ 1);
                    }
                    if (abBucket[i] == b) continue;
                    hashBucketEquals = false;
                    break;
                }
            }
        }
        if (hashBucketEquals) {
            return lastHashBucket == this.currentHashBucket;
        }
        ++this.cachemisses;
        this._arrayBitmap[this.currentHashBucket] = this.currentByteArray;
        this._arrayInverse[this.currentHashBucket] = this.currentInverseDirection;
        this._arrayCrc[this.currentHashBucket] = crc;
        this._receiver = receiver;
        this.decode(this.lookupData, this.currentInverseDirection, this.currentByteArray);
        this.evaluate(this.lookupData);
        for (int vi = 0; vi < this.buildInVariableIdx.length; ++vi) {
            int idx = this.buildInVariableIdx[vi];
            this.arrayBuildInVariablesCache[vi][this.currentHashBucket] = idx == -1 ? 0.0f : this.variableData[idx];
        }
        this._receiver = null;
        return false;
    }

    public void dumpStatistics() {
        int[] histo;
        TreeMap<String, String> counts = new TreeMap<String, String>();
        for (String name : this.lookupNumbers.keySet()) {
            int cnt = 0;
            int inum = this.lookupNumbers.get(name);
            histo = this.lookupHistograms.get(inum);
            for (int i = 2; i < histo.length; ++i) {
                cnt += histo[i];
            }
            counts.put("" + (1000000000 + cnt) + "_" + name, name);
        }
        while (counts.size() > 0) {
            int i;
            String name;
            String key = (String)counts.lastEntry().getKey();
            name = (String)counts.get(key);
            counts.remove(key);
            int inum = this.lookupNumbers.get(name);
            BExpressionLookupValue[] values = this.lookupValues.get(inum);
            histo = this.lookupHistograms.get(inum);
            if (values.length == 1000) continue;
            Object[] svalues = new String[values.length];
            for (i = 0; i < values.length; ++i) {
                String scnt = "0000000000" + histo[i];
                scnt = scnt.substring(scnt.length() - 10);
                svalues[i] = scnt + " " + values[i].toString();
            }
            Arrays.sort(svalues);
            for (i = svalues.length - 1; i >= 0; --i) {
                System.out.println(name + ";" + (String)svalues[i]);
            }
        }
    }

    public int[] createNewLookupData() {
        if (this.lookupDataFrozen) {
            return new int[this.lookupValues.size()];
        }
        return null;
    }

    public int[] generateRandomValues(Random rnd) {
        int[] data = this.createNewLookupData();
        data[0] = 2 * rnd.nextInt(2);
        for (int inum = 1; inum < data.length; ++inum) {
            int nvalues = this.lookupValues.get(inum).length;
            data[inum] = 0;
            if (inum > 1 && rnd.nextInt(10) > 0) continue;
            data[inum] = rnd.nextInt(nvalues);
        }
        this.lookupDataValid = true;
        return data;
    }

    public void assertAllVariablesEqual(BExpressionContext other) {
        int nv = this.variableData.length;
        int nv2 = other.variableData.length;
        if (nv != nv2) {
            throw new RuntimeException("mismatch in variable-count: " + nv + "<->" + nv2);
        }
        for (int i = 0; i < nv; ++i) {
            if (this.variableData[i] == other.variableData[i]) continue;
            throw new RuntimeException("mismatch in variable " + this.variableName(i) + " " + this.variableData[i] + "<->" + other.variableData[i] + "\ntags = " + this.getKeyValueDescription(false, this.encode()));
        }
    }

    private String variableName(int idx) {
        for (Map.Entry<String, Integer> e : this.variableNumbers.entrySet()) {
            if (e.getValue() != idx) continue;
            return e.getKey();
        }
        throw new RuntimeException("no variable for index" + idx);
    }

    public BExpressionLookupValue addLookupValue(String name, String value, int[] lookupData2) {
        BExpressionLookupValue v;
        int i;
        BExpressionLookupValue newValue = null;
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            if (lookupData2 != null) {
                return newValue;
            }
            num = new Integer(this.lookupValues.size());
            this.lookupNumbers.put(name, num);
            this.lookupNames.add(name);
            this.lookupValues.add(new BExpressionLookupValue[]{new BExpressionLookupValue(""), new BExpressionLookupValue("unknown")});
            this.lookupHistograms.add(new int[2]);
            int[] ndata = new int[this.lookupData.length + 1];
            System.arraycopy(this.lookupData, 0, ndata, 0, this.lookupData.length);
            this.lookupData = ndata;
        }
        int inum = num;
        BExpressionLookupValue[] values = this.lookupValues.get(inum);
        int[] histo = this.lookupHistograms.get(inum);
        for (i = 0; i < values.length && !(v = values[i]).matches(value); ++i) {
        }
        if (i == values.length) {
            if (lookupData2 != null) {
                lookupData2[inum] = 1;
                return newValue;
            }
            if (i == 499) {
                // empty if block
            }
            if (i == 500) {
                return newValue;
            }
            BExpressionLookupValue[] nvalues = new BExpressionLookupValue[values.length + 1];
            int[] nhisto = new int[values.length + 1];
            System.arraycopy(values, 0, nvalues, 0, values.length);
            System.arraycopy(histo, 0, nhisto, 0, histo.length);
            values = nvalues;
            histo = nhisto;
            values[i] = newValue = new BExpressionLookupValue(value);
            this.lookupHistograms.set(inum, histo);
            this.lookupValues.set(inum, values);
        }
        int n = i;
        histo[n] = histo[n] + 1;
        if (lookupData2 != null) {
            lookupData2[inum] = i;
        } else {
            this.lookupData[inum] = i;
        }
        return newValue;
    }

    public void addLookupValue(String name, int valueIndex) {
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            return;
        }
        int inum = num;
        int nvalues = this.lookupValues.get(inum).length;
        if (valueIndex < 0 || valueIndex >= nvalues) {
            throw new IllegalArgumentException("value index out of range for name " + name + ": " + valueIndex);
        }
        this.lookupData[inum] = valueIndex;
    }

    public void addSmallestLookupValue(String name, int valueIndex) {
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            return;
        }
        int inum = num;
        int nvalues = this.lookupValues.get(inum).length;
        int oldValueIndex = this.lookupData[inum];
        if (oldValueIndex > 1 && oldValueIndex < valueIndex) {
            return;
        }
        if (valueIndex >= nvalues) {
            valueIndex = nvalues - 1;
        }
        if (valueIndex < 0) {
            throw new IllegalArgumentException("value index out of range for name " + name + ": " + valueIndex);
        }
        this.lookupData[inum] = valueIndex;
    }

    public boolean getBooleanLookupValue(String name) {
        Integer num = this.lookupNumbers.get(name);
        return num != null && this.lookupData[num] == 2;
    }

    public void parseFile(File file, String readOnlyContext) {
        if (!file.exists()) {
            throw new IllegalArgumentException("profile " + file + " does not exist");
        }
        try {
            if (readOnlyContext != null) {
                this.linenr = 1;
                String realContext = this.context;
                this.context = readOnlyContext;
                this.expressionList = this._parseFile(file);
                this.variableData = new float[this.variableNumbers.size()];
                this.evaluate(this.lookupData);
                this.context = realContext;
            }
            this.linenr = 1;
            this.minWriteIdx = this.variableData == null ? 0 : this.variableData.length;
            this.expressionList = this._parseFile(file);
            String[] varNames = this.getBuildInVariableNames();
            this.buildInVariableIdx = new int[varNames.length];
            for (int vi = 0; vi < varNames.length; ++vi) {
                this.buildInVariableIdx[vi] = this.getVariableIdx(varNames[vi], false);
            }
            float[] readOnlyData = this.variableData;
            this.variableData = new float[this.variableNumbers.size()];
            for (int i = 0; i < this.minWriteIdx; ++i) {
                this.variableData[i] = readOnlyData[i];
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalArgumentException("ParseException at line " + this.linenr + ": " + e.getMessage());
            }
            throw new RuntimeException(e);
        }
        if (this.expressionList.size() == 0) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " does not contain expressions for context " + this.context + " (old version?)");
        }
    }

    private List<BExpression> _parseFile(File file) throws Exception {
        BExpression exp;
        this._br = new BufferedReader(new FileReader(file));
        this._readerDone = false;
        ArrayList<BExpression> result = new ArrayList<BExpression>();
        while ((exp = BExpression.parse(this, 0)) != null) {
            result.add(exp);
        }
        this._br.close();
        this._br = null;
        return result;
    }

    public float getVariableValue(String name, float defaultValue) {
        Integer num = this.variableNumbers.get(name);
        return num == null ? defaultValue : this.getVariableValue(num);
    }

    float getVariableValue(int variableIdx) {
        return this.variableData[variableIdx];
    }

    int getVariableIdx(String name, boolean create) {
        Integer num = this.variableNumbers.get(name);
        if (num == null) {
            if (create) {
                num = new Integer(this.variableNumbers.size());
                this.variableNumbers.put(name, num);
            } else {
                return -1;
            }
        }
        return num;
    }

    int getMinWriteIdx() {
        return this.minWriteIdx;
    }

    float getLookupMatch(int nameIdx, int[] valueIdxArray) {
        for (int i = 0; i < valueIdxArray.length; ++i) {
            if (this.lookupData[nameIdx] != valueIdxArray[i]) continue;
            return 1.0f;
        }
        return 0.0f;
    }

    public int getLookupNameIdx(String name) {
        Integer num = this.lookupNumbers.get(name);
        return num == null ? -1 : num;
    }

    int getLookupValueIdx(int nameIdx, String value) {
        BExpressionLookupValue[] values = this.lookupValues.get(nameIdx);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    String parseToken() throws Exception {
        String token;
        while (true) {
            if ((token = this._parseToken()) == null) {
                return null;
            }
            if (token.startsWith(CONTEXT_TAG)) {
                this._inOurContext = token.substring(CONTEXT_TAG.length()).equals(this.context);
                continue;
            }
            if (this._inOurContext) break;
        }
        return token;
    }

    private String _parseToken() throws Exception {
        StringBuilder sb = new StringBuilder(32);
        boolean inComment = false;
        while (true) {
            int ic;
            int n = ic = this._readerDone ? -1 : this._br.read();
            if (ic < 0) {
                if (sb.length() == 0) {
                    return null;
                }
                this._readerDone = true;
                return sb.toString();
            }
            char c = (char)ic;
            if (c == '\n') {
                ++this.linenr;
            }
            if (inComment) {
                if (c != '\r' && c != '\n') continue;
                inComment = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
            if (c == '#' && sb.length() == 0) {
                inComment = true;
                continue;
            }
            sb.append(c);
        }
    }

    float assign(int variableIdx, float value) {
        this.variableData[variableIdx] = value;
        return value;
    }

    void expressionWarning(String message) {
        this._arrayBitmap[this.currentHashBucket] = null;
        if (this._receiver != null) {
            this._receiver.expressionWarning(this.context, message);
        }
    }
}

