/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.util.ArrayList;
import java.util.List;

public class SortedHeap<V> {
    private int[][] al;
    private int[] pa;
    private int[] lp;
    private Object[][] vla;
    protected static final int MAXLISTS = 31;
    private int size;
    private boolean isClear = false;

    public SortedHeap() {
        this.clear();
    }

    public V popLowestKeyValue() {
        int[] ali;
        int minId = 0;
        int minIdx = -1;
        int i = 1;
        while ((ali = this.al[i]) != null) {
            int lpi = this.lp[i];
            if (lpi < ali.length) {
                int currentId = ali[lpi];
                if (minIdx < 0 || currentId < minId) {
                    minIdx = i;
                    minId = currentId;
                }
            }
            ++i;
        }
        if (minIdx == -1) {
            return null;
        }
        int n = minIdx;
        int n2 = this.lp[n];
        this.lp[n] = n2 + 1;
        int lp_minIdx = n2;
        Object[] vla_minIdx = this.vla[minIdx];
        Object res = vla_minIdx[lp_minIdx];
        vla_minIdx[lp_minIdx] = null;
        --this.size;
        return (V)res;
    }

    public void add(int key, V value) {
        int n;
        this.isClear = false;
        ++this.size;
        if (this.lp[1] == 1) {
            this.al[1][0] = key;
            this.vla[1][0] = value;
            this.lp[1] = 0;
            return;
        }
        if (this.lp[2] > 0) {
            Object val1;
            int key1;
            int[] al2 = this.al[2];
            Object[] vla2 = this.vla[2];
            if (this.lp[2] == 2) {
                key1 = this.al[1][0];
                val1 = this.vla[1][0];
                this.lp[1] = 1;
            } else {
                key1 = al2[1];
                val1 = vla2[1];
            }
            this.lp[2] = 0;
            if (key1 < key) {
                al2[0] = key1;
                vla2[0] = val1;
                al2[1] = key;
                vla2[1] = value;
            } else {
                al2[1] = key1;
                vla2[1] = val1;
                al2[0] = key;
                vla2[0] = value;
            }
            return;
        }
        this.al[0][0] = key;
        this.vla[0][0] = value;
        this.pa[0] = 1;
        this.pa[1] = 1;
        this.pa[2] = 2;
        int cnt = 4;
        int idx = 3;
        for (n = 4; (cnt += n - this.lp[idx]) > n; n <<= 1) {
            this.pa[idx++] = n;
        }
        if (idx == 31) {
            throw new IllegalArgumentException("overflow");
        }
        if (this.al[idx] == null) {
            this.al[idx] = new int[n];
            this.vla[idx] = new Object[n];
        }
        int[] al_t = this.al[idx];
        Object[] vla_t = this.vla[idx];
        int lp_t = this.lp[idx];
        if (lp_t < n) {
            System.arraycopy(al_t, lp_t, al_t, 0, n - lp_t);
            System.arraycopy(vla_t, lp_t, vla_t, 0, n - lp_t);
        }
        this.lp[idx] = 0;
        this.pa[idx] = n - lp_t;
        while (cnt > 0) {
            int i = 0;
            while (this.pa[i] == this.lp[i]) {
                ++i;
            }
            int maxId = this.al[i][this.pa[i] - 1];
            int maxIdx = i++;
            while (i <= idx) {
                int currentId;
                int p = this.pa[i];
                if (p > this.lp[i] && (currentId = this.al[i][p - 1]) > maxId) {
                    maxIdx = i;
                    maxId = currentId;
                }
                ++i;
            }
            this.al[idx][--n] = maxId;
            this.vla[idx][n] = this.vla[maxIdx][this.pa[maxIdx] - 1];
            --cnt;
            int n2 = maxIdx;
            this.pa[n2] = this.pa[n2] - 1;
        }
        this.lp[idx] = n;
        while (--idx > 0) {
            this.lp[idx] = this.al[idx].length;
        }
    }

    public void clear() {
        if (!this.isClear) {
            this.isClear = true;
            this.size = 0;
            this.pa = new int[31];
            this.lp = new int[31];
            this.al = new int[31][];
            this.al[0] = new int[1];
            this.al[1] = new int[1];
            this.al[2] = new int[2];
            this.vla = new Object[31][];
            this.vla[0] = new Object[1];
            this.vla[1] = new Object[1];
            this.vla[2] = new Object[2];
            int n = 1;
            this.lp[0] = 0;
            for (int idx = 1; idx < 31; ++idx) {
                this.lp[idx] = n;
                n <<= 1;
            }
        }
    }

    public List<V> getExtract() {
        int[] ali;
        int div = this.size / 1000 + 1;
        ArrayList<Object> res = new ArrayList<Object>(this.size / div);
        int cnt = 0;
        int i = 1;
        while ((ali = this.al[i]) != null) {
            Object[] vlai = this.vla[i];
            int n = ali.length;
            for (int lpi = this.lp[i]; lpi < n; ++lpi) {
                if (++cnt % div != 0) continue;
                res.add(this.vla[i][lpi]);
            }
            ++i;
        }
        return res;
    }
}

