/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.DataBuffers;
import btools.mapaccess.OsmFile;
import btools.util.ByteDataReader;
import btools.util.Crc32;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class PhysicalFile {
    RandomAccessFile ra = null;
    long[] fileIndex = new long[25];
    int[] fileHeaderCrcs;
    private int fileIndexCrc;
    public long creationTime;
    String fileName;
    public int divisor = 80;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkFileIntegrity(File f) {
        PhysicalFile pf = null;
        try {
            DataBuffers dataBuffers = new DataBuffers();
            pf = new PhysicalFile(f, dataBuffers, -1, -1);
            int div = pf.divisor;
            for (int lonDegree = 0; lonDegree < 5; ++lonDegree) {
                for (int latDegree = 0; latDegree < 5; ++latDegree) {
                    OsmFile osmf = new OsmFile(pf, lonDegree, latDegree, dataBuffers);
                    if (!osmf.hasData()) continue;
                    for (int lonIdx = 0; lonIdx < div; ++lonIdx) {
                        for (int latIdx = 0; latIdx < div; ++latIdx) {
                            osmf.createMicroCache(lonDegree * div + lonIdx, latDegree * div + latIdx, dataBuffers, null, null, false);
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException iae) {
            String string = iae.getMessage();
            return string;
        }
        catch (Exception e) {
            String string = e.toString();
            return string;
        }
        finally {
            if (pf != null) {
                try {
                    pf.ra.close();
                }
                catch (Exception ee) {}
            }
        }
        return null;
    }

    public PhysicalFile(File f, DataBuffers dataBuffers, int lookupVersion, int lookupMinorVersion) throws Exception {
        this.fileName = f.getName();
        byte[] iobuffer = dataBuffers.iobuffer;
        this.ra = new RandomAccessFile(f, "r");
        this.ra.readFully(iobuffer, 0, 200);
        this.fileIndexCrc = Crc32.crc(iobuffer, 0, 200);
        ByteDataReader dis = new ByteDataReader(iobuffer);
        for (int i = 0; i < 25; ++i) {
            long lv = dis.readLong();
            short readVersion = (short)(lv >> 48);
            if (i == 0 && lookupVersion != -1 && readVersion != lookupVersion) {
                throw new IllegalArgumentException("lookup version mismatch (old rd5?) lookups.dat=" + lookupVersion + " " + f.getAbsolutePath() + "=" + readVersion);
            }
            if (i == 1 && lookupMinorVersion != -1 && readVersion < lookupMinorVersion) {
                throw new IllegalArgumentException("lookup minor version mismatch (old rd5?) lookups.dat=" + lookupMinorVersion + " " + f.getAbsolutePath() + "=" + readVersion);
            }
            this.fileIndex[i] = lv & 0xFFFFFFFFFFFFL;
        }
        long len = this.ra.length();
        long pos = this.fileIndex[24];
        int extraLen = 112;
        if (len == pos) {
            return;
        }
        if (len < pos + (long)extraLen) {
            throw new IOException("file of size " + len + " too short, should be " + (pos + (long)extraLen));
        }
        this.ra.seek(pos);
        this.ra.readFully(iobuffer, 0, extraLen);
        dis = new ByteDataReader(iobuffer);
        this.creationTime = dis.readLong();
        int crcData = dis.readInt();
        if (crcData == this.fileIndexCrc) {
            this.divisor = 80;
        } else if ((crcData ^ 2) == this.fileIndexCrc) {
            this.divisor = 32;
        } else {
            throw new IOException("top index checksum error");
        }
        this.fileHeaderCrcs = new int[25];
        for (int i = 0; i < 25; ++i) {
            this.fileHeaderCrcs[i] = dis.readInt();
        }
    }
}

