/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class MixCoderDataOutputStream
extends DataOutputStream {
    private long lastValue;
    private long lastLastValue;
    private long repCount;
    private boolean doFlush;

    public MixCoderDataOutputStream(OutputStream os) {
        super(os);
    }

    public void writeSigned(long v) throws IOException {
        this.writeUnsigned(v < 0L ? -v << 1 | 1L : v << 1);
    }

    public void writeUnsigned(long v) throws IOException {
        if (v < 0L) {
            throw new IllegalArgumentException("writeUnsigned: " + v);
        }
        do {
            long i7 = v & 0x7FL;
            if ((v >>= 7) != 0L) {
                i7 |= 0x80L;
            }
            this.writeByte((byte)(i7 & 0xFFL));
        } while (v != 0L);
    }

    public void writeMixed(long v) throws IOException {
        if (v != this.lastValue && this.repCount > 0L) {
            long d = this.lastValue - this.lastLastValue;
            this.lastLastValue = this.lastValue;
            int repCode = this.repCount < 4L ? (int)this.repCount : 0;
            int diffcode = (int)(d > -32L && d < 32L ? d + 32L : 0L);
            this.writeByte((byte)(diffcode | repCode << 6));
            if (repCode == 0) {
                this.writeUnsigned(this.repCount);
            }
            if (diffcode == 0) {
                this.writeSigned(d);
            }
            this.repCount = 0L;
        }
        this.lastValue = v;
        ++this.repCount;
    }

    @Override
    public void flush() throws IOException {
        long v = this.lastValue;
        this.writeMixed(v + 1L);
        this.lastValue = v;
        this.repCount = 0L;
    }
}

