/*
 * Decompiled with CFR 0.152.
 */
package btools.codec;

import btools.codec.MicroCache;
import btools.util.ByteDataWriter;

public final class MicroCache1
extends MicroCache {
    private int lonIdxBase;
    private int latIdxBase;

    public MicroCache1(int size, byte[] databuffer, int lonIdx80, int latIdx80) throws Exception {
        super(databuffer);
        this.faid = new int[size];
        this.fapos = new int[size];
        this.size = 0;
        this.lonIdxBase = lonIdx80 / 5 * 62500 + 31250;
        this.latIdxBase = latIdx80 / 5 * 62500 + 31250;
    }

    public MicroCache1(byte[] databuffer, int lonIdx80, int latIdx80) throws Exception {
        super(databuffer);
        this.lonIdxBase = lonIdx80 / 5 * 62500 + 31250;
        this.latIdxBase = latIdx80 / 5 * 62500 + 31250;
        this.size = this.readInt();
        int nbytes = 0;
        for (int i = 0; i < this.size; ++i) {
            this.aboffset += 4;
            int bodySize = this.readVarLengthUnsigned();
            this.aboffset += bodySize;
            nbytes += bodySize;
        }
        byte[] nab = new byte[nbytes];
        this.aboffset = 4;
        int noffset = 0;
        this.faid = new int[this.size];
        this.fapos = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.faid[i] = this.readInt() ^ 0x8000;
            int bodySize = this.readVarLengthUnsigned();
            System.arraycopy(this.ab, this.aboffset, nab, noffset, bodySize);
            this.aboffset += bodySize;
            this.fapos[i] = noffset += bodySize;
        }
        this.ab = nab;
        this.aboffset = noffset;
        this.init(this.size);
    }

    @Override
    public long expandId(int id32) {
        int lon32 = this.lonIdxBase + (short)(id32 >> 16);
        int lat32 = this.latIdxBase + (short)(id32 & 0xFFFF ^ 0x8000);
        return (long)lon32 << 32 | (long)lat32;
    }

    @Override
    public int shrinkId(long id64) {
        int lon32 = (int)(id64 >> 32);
        int lat32 = (int)(id64 & 0xFFFFFFFFFFFFFFFFL);
        return lon32 - this.lonIdxBase << 16 | lat32 - this.latIdxBase & 0xFFFF ^ 0x8000;
    }

    @Override
    public int encodeMicroCache(byte[] buffer) {
        ByteDataWriter dos = new ByteDataWriter(buffer);
        dos.writeInt(this.size);
        for (int n = 0; n < this.size; ++n) {
            dos.writeInt(this.faid[n] ^ 0x8000);
            int start = n > 0 ? this.fapos[n - 1] : 0;
            int end = this.fapos[n];
            int len = end - start;
            dos.writeVarLengthUnsigned(len);
            dos.write(this.ab, start, len);
        }
        return dos.size();
    }
}

