/*
 * Decompiled with CFR 0.152.
 */
package btools.codec;

public class LinkedListContainer {
    private int[] ia;
    private int size;
    private int[] startpointer;
    private int listpointer;

    public LinkedListContainer(int nlists, int[] defaultbuffer) {
        this.ia = defaultbuffer == null ? new int[nlists * 4] : defaultbuffer;
        this.startpointer = new int[nlists];
    }

    public void addDataElement(int listNr, int data) {
        if (this.size + 2 > this.ia.length) {
            this.resize();
        }
        this.ia[this.size++] = this.startpointer[listNr];
        this.startpointer[listNr] = this.size;
        this.ia[this.size++] = data;
    }

    public int initList(int listNr) {
        int cnt = 0;
        int lp = this.listpointer = this.startpointer[listNr];
        while (lp != 0) {
            lp = this.ia[lp - 1];
            ++cnt;
        }
        return cnt;
    }

    public int getDataElement() {
        if (this.listpointer == 0) {
            throw new IllegalArgumentException("no more element!");
        }
        int data = this.ia[this.listpointer];
        this.listpointer = this.ia[this.listpointer - 1];
        return data;
    }

    private void resize() {
        int[] ia2 = new int[2 * this.ia.length];
        System.arraycopy(this.ia, 0, ia2, 0, this.ia.length);
        this.ia = ia2;
    }
}

