/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.ByteDataReader;

public class ByteDataWriter
extends ByteDataReader {
    public ByteDataWriter(byte[] byteArray) {
        super(byteArray);
    }

    public void writeInt(int v) {
        this.ab[this.aboffset++] = (byte)(v >> 24 & 0xFF);
        this.ab[this.aboffset++] = (byte)(v >> 16 & 0xFF);
        this.ab[this.aboffset++] = (byte)(v >> 8 & 0xFF);
        this.ab[this.aboffset++] = (byte)(v & 0xFF);
    }

    public void writeLong(long v) {
        this.ab[this.aboffset++] = (byte)(v >> 56 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 48 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 40 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 32 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 24 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 16 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 8 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v & 0xFFL);
    }

    public void writeBoolean(boolean v) {
        this.ab[this.aboffset++] = (byte)(v ? 1 : 0);
    }

    public void writeByte(int v) {
        this.ab[this.aboffset++] = (byte)(v & 0xFF);
    }

    public void writeShort(int v) {
        this.ab[this.aboffset++] = (byte)(v >> 8 & 0xFF);
        this.ab[this.aboffset++] = (byte)(v & 0xFF);
    }

    public void write(byte[] sa) {
        System.arraycopy(sa, 0, this.ab, this.aboffset, sa.length);
        this.aboffset += sa.length;
    }

    public void write(byte[] sa, int offset, int len) {
        System.arraycopy(sa, offset, this.ab, this.aboffset, len);
        this.aboffset += len;
    }

    public void writeVarBytes(byte[] sa) {
        if (sa == null) {
            this.writeVarLengthUnsigned(0);
        } else {
            int len = sa.length;
            this.writeVarLengthUnsigned(len);
            this.write(sa, 0, len);
        }
    }

    public void writeModeAndDesc(boolean isReverse, byte[] sa) {
        int len = sa == null ? 0 : sa.length;
        int sizecode = len << 1 | (isReverse ? 1 : 0);
        this.writeVarLengthUnsigned(sizecode);
        if (len > 0) {
            this.write(sa, 0, len);
        }
    }

    public byte[] toByteArray() {
        byte[] c = new byte[this.aboffset];
        System.arraycopy(this.ab, 0, c, 0, this.aboffset);
        return c;
    }

    public int writeSizePlaceHolder() {
        return this.aboffset++;
    }

    public void injectSize(int sizeoffset) {
        int datasize;
        int size = 0;
        int v = datasize = this.aboffset - sizeoffset - 1;
        do {
            ++size;
        } while ((v >>= 7) != 0);
        if (size > 1) {
            System.arraycopy(this.ab, sizeoffset + 1, this.ab, sizeoffset + size, datasize);
        }
        this.aboffset = sizeoffset;
        this.writeVarLengthUnsigned(datasize);
        this.aboffset = sizeoffset + size + datasize;
    }

    public int writeVarLengthSigned(int v) {
        return this.writeVarLengthUnsigned(v < 0 ? -v << 1 | 1 : v << 1);
    }

    public int writeVarLengthUnsigned(int v) {
        int start = this.aboffset;
        do {
            int i7 = v & 0x7F;
            if ((v >>= 7) != 0) {
                i7 |= 0x80;
            }
            this.ab[this.aboffset++] = (byte)(i7 & 0xFF);
        } while (v != 0);
        return this.aboffset - start;
    }

    public int size() {
        return this.aboffset;
    }
}

