/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContextGlobal;
import btools.expressions.BExpressionContextNode;
import btools.expressions.BExpressionContextWay;
import btools.expressions.BExpressionMetaData;
import btools.mapaccess.NodesCache;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmLinkHolder;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodesMap;
import btools.router.MatchedWaypoint;
import btools.router.OsmNodeNamed;
import btools.router.OsmPath;
import btools.router.OsmPathElement;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import btools.router.SearchBoundary;
import btools.router.WaypointMatcherImpl;
import btools.util.SortedHeap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RoutingEngine
extends Thread {
    private OsmNodesMap nodesMap;
    private NodesCache nodesCache;
    private SortedHeap<OsmPath> openSet = new SortedHeap();
    private boolean finished = false;
    protected List<OsmNodeNamed> waypoints = null;
    protected List<MatchedWaypoint> matchedWaypoints;
    private int linksProcessed = 0;
    protected OsmTrack foundTrack = new OsmTrack();
    private OsmTrack foundRawTrack = null;
    private int alternativeIndex = 0;
    protected String errorMessage = null;
    private volatile boolean terminated;
    protected File profileDir;
    protected String segmentDir;
    private String outfileBase;
    private String logfileBase;
    private boolean infoLogEnabled;
    private Writer infoLogWriter;
    protected RoutingContext routingContext;
    public double airDistanceCostFactor;
    private OsmTrack guideTrack;
    private OsmPathElement matchPath;
    private long startTime;
    private long maxRunningTime;
    public SearchBoundary boundary;
    public boolean quite = false;

    public RoutingEngine(String outfileBase, String logfileBase, String segmentDir, List<OsmNodeNamed> waypoints, RoutingContext rc) {
        this.segmentDir = segmentDir;
        this.outfileBase = outfileBase;
        this.logfileBase = logfileBase;
        this.waypoints = waypoints;
        this.infoLogEnabled = outfileBase != null;
        this.routingContext = rc;
        if (rc.localFunction != null) {
            File profileFile;
            String profileBaseDir = System.getProperty("profileBaseDir");
            if (profileBaseDir == null) {
                this.profileDir = new File(rc.localFunction).getParentFile();
                profileFile = new File(rc.localFunction);
            } else {
                this.profileDir = new File(profileBaseDir);
                profileFile = new File(this.profileDir, rc.localFunction + ".brf");
            }
            BExpressionMetaData meta = new BExpressionMetaData();
            BExpressionContextGlobal expctxGlobal = new BExpressionContextGlobal(meta);
            rc.expctxWay = new BExpressionContextWay(rc.serversizing ? 262144 : 8192, meta);
            rc.expctxNode = new BExpressionContextNode(rc.serversizing ? 16384 : 2048, meta);
            meta.readMetaData(new File(this.profileDir, "lookups.dat"));
            expctxGlobal.parseFile(profileFile, null);
            expctxGlobal.evaluate(new int[0]);
            rc.readGlobalConfig(expctxGlobal);
            rc.expctxWay.parseFile(profileFile, "global");
            rc.expctxNode.parseFile(profileFile, "global");
        }
    }

    private void logInfo(String s) {
        if (this.infoLogEnabled) {
            System.out.println(s);
        }
        if (this.infoLogWriter != null) {
            try {
                this.infoLogWriter.write(s);
                this.infoLogWriter.write(10);
                this.infoLogWriter.flush();
            }
            catch (IOException io) {
                this.infoLogWriter = null;
            }
        }
    }

    private void logThrowable(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        this.logInfo(sw.toString());
    }

    @Override
    public void run() {
        this.doRun(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun(long maxRunningTime) {
        try {
            File debugLog = new File(this.profileDir, "../debug.txt");
            if (debugLog.exists()) {
                this.infoLogWriter = new FileWriter(debugLog, true);
                this.logInfo("start request at " + new Date());
            }
            this.routingContext.cleanNogolist(this.waypoints);
            this.startTime = System.currentTimeMillis();
            this.maxRunningTime = maxRunningTime;
            int nsections = this.waypoints.size() - 1;
            OsmTrack[] refTracks = new OsmTrack[nsections];
            OsmTrack[] lastTracks = new OsmTrack[nsections];
            OsmTrack track = null;
            ArrayList<String> messageList = new ArrayList<String>();
            int i = 0;
            while (!this.terminated) {
                block32: {
                    block33: {
                        block31: {
                            track = this.findTrack(refTracks, lastTracks);
                            track.message = "track-length = " + track.distance + " filtered ascend = " + track.ascend + " plain-ascend = " + track.plainAscend + " cost=" + track.cost;
                            track.name = "brouter_" + this.routingContext.getProfileName() + "_" + i;
                            messageList.add(track.message);
                            track.messageList = messageList;
                            if (this.outfileBase == null) break block31;
                            String filename = this.outfileBase + i + ".gpx";
                            OsmTrack oldTrack = new OsmTrack();
                            oldTrack.readGpx(filename);
                            if (track.equalsTrack(oldTrack)) break block32;
                            track.writeGpx(filename);
                            this.foundTrack = track;
                            this.alternativeIndex = i;
                            break block33;
                        }
                        if (i != this.routingContext.getAlternativeIdx()) break block32;
                        if ("CSV".equals(System.getProperty("reportFormat"))) {
                            track.dumpMessages(null, this.routingContext);
                        } else if (!this.quite) {
                            System.out.println(track.formatAsGpx());
                        }
                        this.foundTrack = track;
                    }
                    if (this.logfileBase == null) break;
                    String logfilename = this.logfileBase + i + ".csv";
                    track.dumpMessages(logfilename, this.routingContext);
                    break;
                }
                ++i;
            }
            long endTime = System.currentTimeMillis();
            this.logInfo("execution time = " + (double)(endTime - this.startTime) / 1000.0 + " seconds");
        }
        catch (IllegalArgumentException e) {
            this.errorMessage = e.getMessage();
            this.logInfo("Exception (linksProcessed=" + this.linksProcessed + ": " + this.errorMessage);
        }
        catch (Exception e) {
            this.errorMessage = e instanceof IllegalArgumentException ? e.getMessage() : e.toString();
            this.logInfo("Exception (linksProcessed=" + this.linksProcessed + ": " + this.errorMessage);
            this.logThrowable(e);
        }
        catch (Error e) {
            this.cleanOnOOM();
            this.errorMessage = e.toString();
            this.logInfo("Error (linksProcessed=" + this.linksProcessed + ": " + this.errorMessage);
            this.logThrowable(e);
        }
        finally {
            if (this.nodesCache != null) {
                this.nodesCache.close();
                this.nodesCache = null;
            }
            this.openSet.clear();
            this.finished = true;
            if (this.infoLogWriter != null) {
                try {
                    this.infoLogWriter.close();
                }
                catch (Exception e) {}
                this.infoLogWriter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSearch() {
        try {
            MatchedWaypoint seedPoint = this.matchNodeForPosition(this.waypoints.get(0));
            this.routingContext.countTraffic = true;
            this.findTrack("seededSearch", seedPoint, null, null, null, false);
        }
        catch (IllegalArgumentException e) {
            this.errorMessage = e.getMessage();
            this.logInfo("Exception (linksProcessed=" + this.linksProcessed + ": " + this.errorMessage);
        }
        catch (Exception e) {
            this.errorMessage = e instanceof IllegalArgumentException ? e.getMessage() : e.toString();
            this.logInfo("Exception (linksProcessed=" + this.linksProcessed + ": " + this.errorMessage);
            this.logThrowable(e);
        }
        catch (Error e) {
            this.cleanOnOOM();
            this.errorMessage = e.toString();
            this.logInfo("Error (linksProcessed=" + this.linksProcessed + ": " + this.errorMessage);
            this.logThrowable(e);
        }
        finally {
            if (this.nodesCache != null) {
                this.nodesCache.close();
                this.nodesCache = null;
            }
            this.openSet.clear();
            this.finished = true;
            if (this.infoLogWriter != null) {
                try {
                    this.infoLogWriter.close();
                }
                catch (Exception e) {}
                this.infoLogWriter = null;
            }
        }
    }

    public void cleanOnOOM() {
        this.nodesMap = null;
        this.terminate();
    }

    private OsmTrack findTrack(OsmTrack[] refTracks, OsmTrack[] lastTracks) {
        int i;
        OsmTrack totaltrack = new OsmTrack();
        int nUnmatched = this.waypoints.size();
        OsmTrack nearbyTrack = null;
        if (refTracks[this.waypoints.size() - 2] == null && (nearbyTrack = OsmTrack.readBinary(this.routingContext.rawTrackPath, this.waypoints.get(this.waypoints.size() - 1), this.routingContext.getNogoChecksums())) != null) {
            --nUnmatched;
        }
        if (this.matchedWaypoints == null) {
            this.matchedWaypoints = new ArrayList<MatchedWaypoint>();
            for (i = 0; i < nUnmatched; ++i) {
                MatchedWaypoint mwp = new MatchedWaypoint();
                mwp.waypoint = this.waypoints.get(i);
                this.matchedWaypoints.add(mwp);
            }
            this.matchWaypointsToNodes(this.matchedWaypoints);
            if (nearbyTrack != null) {
                this.matchedWaypoints.add(nearbyTrack.endPoint);
            }
        }
        for (i = 0; i < this.matchedWaypoints.size() - 1; ++i) {
            OsmTrack seg;
            if (lastTracks[i] != null) {
                if (refTracks[i] == null) {
                    refTracks[i] = new OsmTrack();
                }
                refTracks[i].addNodes(lastTracks[i]);
            }
            if ((seg = this.searchTrack(this.matchedWaypoints.get(i), this.matchedWaypoints.get(i + 1), i == this.matchedWaypoints.size() - 2 ? nearbyTrack : null, refTracks[i])) == null) {
                return null;
            }
            totaltrack.appendTrack(seg);
            lastTracks[i] = seg;
        }
        return totaltrack;
    }

    private void matchWaypointsToNodes(List<MatchedWaypoint> unmatchedWaypoints) {
        this.resetCache();
        this.nodesCache.waypointMatcher = new WaypointMatcherImpl(unmatchedWaypoints, 250.0);
        for (MatchedWaypoint mwp : unmatchedWaypoints) {
            this.preloadPosition(mwp.waypoint);
        }
        for (int i = 0; i < unmatchedWaypoints.size(); ++i) {
            MatchedWaypoint mwp;
            mwp = unmatchedWaypoints.get(i);
            if (mwp.crosspoint == null) {
                System.out.println("name=" + mwp.waypoint.name + " NOT matched r=" + mwp.radius * 111894.0);
                unmatchedWaypoints.set(i, this.matchNodeForPosition(mwp.waypoint));
                continue;
            }
            System.out.println("name=" + mwp.waypoint.name + " matched r=" + mwp.radius * 111894.0);
        }
    }

    private void preloadPosition(OsmNode n) {
        int d = 12500;
        this.nodesCache.first_file_access_failed = false;
        this.nodesCache.first_file_access_name = null;
        this.nodesCache.loadSegmentFor(n.ilon, n.ilat);
        if (this.nodesCache.first_file_access_failed) {
            throw new IllegalArgumentException("datafile " + this.nodesCache.first_file_access_name + " not found");
        }
        for (int idxLat = -1; idxLat <= 1; ++idxLat) {
            for (int idxLon = -1; idxLon <= 1; ++idxLon) {
                this.nodesCache.loadSegmentFor(n.ilon + d * idxLon, n.ilat + d * idxLat);
            }
        }
    }

    private MatchedWaypoint matchNodeForPosition(OsmNodeNamed wp) {
        try {
            this.routingContext.setWaypoint(wp, false);
            int minRingWith = 1;
            do {
                int mismatch;
                MatchedWaypoint mwp = this._matchNodeForPosition(wp, minRingWith);
                if (mwp.node1 != null && (mismatch = wp.calcDistance(mwp.crosspoint)) < 50 * minRingWith) {
                    MatchedWaypoint matchedWaypoint = mwp;
                    return matchedWaypoint;
                }
                if (minRingWith != 1 || !this.nodesCache.first_file_access_failed) continue;
                throw new IllegalArgumentException("datafile " + this.nodesCache.first_file_access_name + " not found");
            } while (minRingWith++ != 5);
            throw new IllegalArgumentException(wp.name + "-position not mapped in existing datafile");
        }
        finally {
            this.routingContext.unsetWaypoint();
        }
    }

    private MatchedWaypoint _matchNodeForPosition(OsmNodeNamed wp, int minRingWidth) {
        wp.radius = 1.0E9;
        this.resetCache();
        this.preloadPosition(wp, minRingWidth, 2000);
        this.nodesCache.distanceChecker = this.routingContext;
        List<OsmNode> nodeList = this.nodesCache.getAllNodes();
        MatchedWaypoint mwp = new MatchedWaypoint();
        mwp.waypoint = wp;
        for (OsmNode n : nodeList) {
            if (!this.nodesCache.obtainNonHollowNode(n)) continue;
            this.expandHollowLinkTargets(n);
            OsmLink startLink = new OsmLink();
            startLink.targetNode = n;
            OsmPath startPath = new OsmPath(startLink);
            startLink.addLinkHolder(startPath);
            OsmLink link = n.firstlink;
            while (link != null) {
                OsmNode nextNode;
                if (link.descriptionBitmap != null && !(nextNode = link.targetNode).isHollow() && nextNode.firstlink != null && nextNode != n) {
                    double oldRadius = wp.radius;
                    OsmPath testPath = new OsmPath(n, startPath, link, null, false, this.routingContext);
                    if (wp.radius < oldRadius) {
                        if (testPath.cost < 0) {
                            wp.radius = oldRadius;
                        } else {
                            mwp.node1 = n;
                            mwp.node2 = nextNode;
                            mwp.radius = wp.radius;
                            mwp.crosspoint = new OsmNodeNamed();
                            mwp.crosspoint.ilon = this.routingContext.ilonshortest;
                            mwp.crosspoint.ilat = this.routingContext.ilatshortest;
                        }
                    }
                }
                link = link.next;
            }
        }
        return mwp;
    }

    private void expandHollowLinkTargets(OsmNode n) {
        OsmLink link = n.firstlink;
        while (link != null) {
            this.nodesCache.obtainNonHollowNode(link.targetNode);
            link = link.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmTrack searchTrack(MatchedWaypoint startWp, MatchedWaypoint endWp, OsmTrack nearbyTrack, OsmTrack refTrack) {
        OsmTrack track = null;
        double[] airDistanceCostFactors = new double[]{this.routingContext.pass1coefficient, this.routingContext.pass2coefficient};
        boolean isDirty = false;
        if (nearbyTrack != null) {
            this.airDistanceCostFactor = 0.0;
            try {
                track = this.findTrack("re-routing", startWp, endWp, nearbyTrack, refTrack, true);
            }
            catch (IllegalArgumentException iae) {
                if (this.matchPath != null) {
                    track = this.mergeTrack(this.matchPath, nearbyTrack);
                    isDirty = true;
                    this.logInfo("using fast partial recalc");
                }
                this.maxRunningTime += System.currentTimeMillis() - this.startTime;
            }
        }
        if (track == null) {
            for (int cfi = 0; cfi < airDistanceCostFactors.length && !this.terminated; ++cfi) {
                this.airDistanceCostFactor = airDistanceCostFactors[cfi];
                if (this.airDistanceCostFactor < 0.0) continue;
                OsmTrack t = this.findTrack(cfi == 0 ? "pass0" : "pass1", startWp, endWp, track, refTrack, false);
                if (t == null && track != null && this.matchPath != null) {
                    t = this.mergeTrack(this.matchPath, track);
                    this.logInfo("using sloppy merge cause pass1 didn't reach destination");
                }
                if (t != null) {
                    track = t;
                    continue;
                }
                throw new IllegalArgumentException("no track found at pass=" + cfi);
            }
        }
        if (track == null) {
            throw new IllegalArgumentException("no track found");
        }
        if (refTrack == null && !isDirty) {
            this.logInfo("supplying new reference track");
            track.endPoint = endWp;
            track.nogoChecksums = this.routingContext.getNogoChecksums();
            this.foundRawTrack = track;
        }
        this.airDistanceCostFactor = 0.0;
        this.guideTrack = track;
        try {
            OsmTrack tt = this.findTrack("re-tracking", startWp, endWp, null, refTrack, false);
            if (tt == null) {
                throw new IllegalArgumentException("error re-tracking track");
            }
            OsmTrack osmTrack = tt;
            return osmTrack;
        }
        finally {
            this.guideTrack = null;
        }
    }

    private void resetCache() {
        this.nodesMap = new OsmNodesMap();
        this.nodesCache = new NodesCache(this.segmentDir, this.nodesMap, this.routingContext.expctxWay, this.routingContext.carMode, this.routingContext.forceSecondaryData, this.nodesCache);
    }

    private OsmNode getStartNode(long startId) {
        OsmNode start = new OsmNode(startId);
        start.setHollow();
        if (!this.nodesCache.obtainNonHollowNode(start)) {
            return null;
        }
        this.expandHollowLinkTargets(start);
        return start;
    }

    private OsmPath getStartPath(OsmNode n1, OsmNode n2, MatchedWaypoint mwp, OsmNodeNamed endPos, boolean sameSegmentSearch) {
        OsmPath p = this.getStartPath(n1, n2, mwp.waypoint, endPos);
        if (sameSegmentSearch) {
            OsmPath pe = this.getEndPath(n1, p.getLink(), endPos);
            OsmPath pt = this.getEndPath(n1, p.getLink(), null);
            int costdelta = pt.cost - p.cost;
            if (pe.cost >= costdelta) {
                pe.cost -= costdelta;
                if (this.guideTrack != null) {
                    OsmPathElement startElement = p.originElement;
                    while (startElement.origin != null) {
                        startElement = startElement.origin;
                    }
                    if (pe.originElement.cost > costdelta) {
                        OsmPathElement e = pe.originElement;
                        while (e.origin != null && e.origin.cost > costdelta) {
                            e = e.origin;
                            e.cost -= costdelta;
                        }
                        e.origin = startElement;
                    } else {
                        pe.originElement = startElement;
                    }
                }
                return pe;
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmPath getStartPath(OsmNode n1, OsmNode n2, OsmNodeNamed wp, OsmNode endPos) {
        try {
            this.routingContext.setWaypoint(wp, false);
            OsmPath bestPath = null;
            OsmLink bestLink = null;
            OsmLink startLink = new OsmLink();
            startLink.targetNode = n1;
            OsmPath startPath = new OsmPath(startLink);
            startLink.addLinkHolder(startPath);
            double minradius = 1.0E10;
            OsmLink link = n1.firstlink;
            while (link != null) {
                OsmNode nextNode = link.targetNode;
                if (!nextNode.isHollow() && nextNode.firstlink != null && nextNode != n1 && nextNode == n2) {
                    wp.radius = 1.0E9;
                    OsmPath testPath = new OsmPath(null, startPath, link, null, this.guideTrack != null, this.routingContext);
                    int n = testPath.airdistance = endPos == null ? 0 : nextNode.calcDistance(endPos);
                    if (wp.radius < minradius) {
                        bestPath = testPath;
                        minradius = wp.radius;
                        bestLink = link;
                    }
                }
                link = link.next;
            }
            if (bestLink != null) {
                bestLink.addLinkHolder(bestPath);
            }
            bestPath.treedepth = 1;
            OsmPath osmPath = bestPath;
            return osmPath;
        }
        finally {
            this.routingContext.unsetWaypoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmPath getEndPath(OsmNode n1, OsmLink link, OsmNodeNamed wp) {
        try {
            if (wp != null) {
                this.routingContext.setWaypoint(wp, true);
            }
            OsmLink startLink = new OsmLink();
            startLink.targetNode = n1;
            OsmPath startPath = new OsmPath(startLink);
            startLink.addLinkHolder(startPath);
            if (wp != null) {
                wp.radius = 1.0E-5;
            }
            OsmPath osmPath = new OsmPath(n1, startPath, link, null, this.guideTrack != null, this.routingContext);
            return osmPath;
        }
        finally {
            if (wp != null) {
                this.routingContext.unsetWaypoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmTrack findTrack(String operationName, MatchedWaypoint startWp, MatchedWaypoint endWp, OsmTrack costCuttingTrack, OsmTrack refTrack, boolean fastPartialRecalc) {
        Object pe2;
        Object pe1;
        boolean verbose = this.guideTrack != null;
        int maxTotalCost = 1000000000;
        int firstMatchCost = 1000000000;
        this.logInfo("findtrack with airDistanceCostFactor=" + this.airDistanceCostFactor);
        if (costCuttingTrack != null) {
            this.logInfo("costCuttingTrack.cost=" + costCuttingTrack.cost);
        }
        this.matchPath = null;
        int nodesVisited = 0;
        this.resetCache();
        long endNodeId1 = endWp == null ? -1L : endWp.node1.getIdFromPos();
        long endNodeId2 = endWp == null ? -1L : endWp.node2.getIdFromPos();
        long startNodeId1 = startWp.node1.getIdFromPos();
        long startNodeId2 = startWp.node2.getIdFromPos();
        OsmNodeNamed endPos = endWp == null ? null : endWp.crosspoint;
        boolean sameSegmentSearch = startNodeId1 == endNodeId1 && startNodeId2 == endNodeId2 || startNodeId1 == endNodeId2 && startNodeId2 == endNodeId1;
        OsmNode start1 = this.getStartNode(startNodeId1);
        if (start1 == null) {
            return null;
        }
        OsmNode start2 = null;
        OsmLink link = start1.firstlink;
        while (link != null) {
            if (link.targetNode.getIdFromPos() == startNodeId2) {
                start2 = link.targetNode;
                break;
            }
            link = link.next;
        }
        if (start2 == null) {
            return null;
        }
        if (start1 == null || start2 == null) {
            return null;
        }
        OsmPath startPath1 = this.getStartPath(start1, start2, startWp, endPos, sameSegmentSearch);
        OsmPath startPath2 = this.getStartPath(start2, start1, startWp, endPos, sameSegmentSearch);
        if (costCuttingTrack != null) {
            pe1 = costCuttingTrack.getLink(startNodeId1, startNodeId2);
            if (pe1 != null) {
                this.logInfo("initialMatch pe1.cost=" + ((OsmPathElement)pe1).cost);
                int c = startPath1.cost - ((OsmPathElement)pe1).cost;
                if (c < 0) {
                    c = 0;
                }
                if (c < firstMatchCost) {
                    firstMatchCost = c;
                }
            }
            if ((pe2 = costCuttingTrack.getLink(startNodeId2, startNodeId1)) != null) {
                this.logInfo("initialMatch pe2.cost=" + ((OsmPathElement)pe2).cost);
                int c = startPath2.cost - ((OsmPathElement)pe2).cost;
                if (c < 0) {
                    c = 0;
                }
                if (c < firstMatchCost) {
                    firstMatchCost = c;
                }
            }
            if (firstMatchCost < 1000000000) {
                this.logInfo("firstMatchCost from initial match=" + firstMatchCost);
            }
        }
        pe1 = this.openSet;
        synchronized (pe1) {
            this.openSet.clear();
            this.addToOpenset(startPath1);
            this.addToOpenset(startPath2);
        }
        while (!this.terminated) {
            if (this.maxRunningTime > 0L) {
                long timeout;
                long l = timeout = this.matchPath == null && fastPartialRecalc ? this.maxRunningTime / 3L : this.maxRunningTime;
                if (System.currentTimeMillis() - this.startTime > timeout) {
                    throw new IllegalArgumentException(operationName + " timeout after " + timeout / 1000L + " seconds");
                }
            }
            OsmPath path = null;
            pe2 = this.openSet;
            synchronized (pe2) {
                path = this.openSet.popLowestKeyValue();
            }
            if (path == null) break;
            if (path.airdistance == -1) {
                path.unregisterUpTree(this.routingContext);
                continue;
            }
            if (this.matchPath != null && fastPartialRecalc && firstMatchCost < 500 && (long)path.cost > 30L * (long)firstMatchCost) {
                this.logInfo("early exit: firstMatchCost=" + firstMatchCost + " path.cost=" + path.cost);
                throw new IllegalArgumentException("early exit for a close recalc");
            }
            ++nodesVisited;
            ++this.linksProcessed;
            OsmLink currentLink = path.getLink();
            OsmNode currentNode = currentLink.targetNode;
            OsmNode sourceNode = path.getSourceNode();
            long currentNodeId = currentNode.getIdFromPos();
            if (sourceNode != null) {
                OsmPathElement pe;
                long sourceNodeId = sourceNode.getIdFromPos();
                if (sourceNodeId == endNodeId1 && currentNodeId == endNodeId2 || sourceNodeId == endNodeId2 && currentNodeId == endNodeId1) {
                    this.logInfo("found track at cost " + path.cost + " nodesVisited = " + nodesVisited);
                    return this.compileTrack(path, verbose);
                }
                if (costCuttingTrack != null && (pe = costCuttingTrack.getLink(sourceNodeId, currentNodeId)) != null) {
                    int costEstimate;
                    int parentcost = path.originElement == null ? 0 : path.originElement.cost;
                    int c = path.cost - parentcost - pe.cost;
                    if (c > 0) {
                        parentcost += c;
                    }
                    if (parentcost < firstMatchCost) {
                        firstMatchCost = parentcost;
                    }
                    if ((costEstimate = path.cost + path.elevationCorrection(this.routingContext) + (costCuttingTrack.cost - pe.cost)) <= maxTotalCost) {
                        this.matchPath = OsmPathElement.create(path, this.routingContext.countTraffic);
                    }
                    if (costEstimate < maxTotalCost) {
                        this.logInfo("maxcost " + maxTotalCost + " -> " + costEstimate);
                        maxTotalCost = costEstimate;
                    }
                }
            }
            if (path.cost + path.airdistance > maxTotalCost + 10) {
                path.unregisterUpTree(this.routingContext);
                continue;
            }
            this.expandHollowLinkTargets(currentNode);
            if (sourceNode != null) {
                sourceNode.unlinkLink(currentLink);
            }
            OsmLink counterLink = null;
            OsmLink link2 = currentNode.firstlink;
            while (link2 != null) {
                block53: {
                    OsmNode nextNode;
                    block55: {
                        block54: {
                            nextNode = link2.targetNode;
                            if (nextNode.isHollow() || nextNode.firstlink == null) break block53;
                            if (nextNode != sourceNode) break block54;
                            counterLink = link2;
                            break block53;
                        }
                        if (this.guideTrack == null) break block55;
                        int gidx = path.treedepth + 1;
                        if (gidx >= this.guideTrack.nodes.size()) break block53;
                        OsmPathElement guideNode = this.guideTrack.nodes.get(gidx);
                        if (nextNode.getILat() != guideNode.getILat() || nextNode.getILon() != guideNode.getILon()) break block53;
                    }
                    OsmPath bestPath = null;
                    boolean isFinalLink = false;
                    long targetNodeId = link2.targetNode.getIdFromPos();
                    if (!(currentNodeId != endNodeId1 && currentNodeId != endNodeId2 || targetNodeId != endNodeId1 && targetNodeId != endNodeId2)) {
                        isFinalLink = true;
                    }
                    for (OsmLinkHolder linkHolder = currentLink.firstlinkholder; linkHolder != null; linkHolder = linkHolder.getNextForLink()) {
                        OsmPath otherPath = (OsmPath)linkHolder;
                        try {
                            if (isFinalLink) {
                                endPos.radius = 1.0E-5;
                                this.routingContext.setWaypoint(endPos, true);
                            }
                            OsmPath testPath = new OsmPath(currentNode, otherPath, link2, refTrack, this.guideTrack != null, this.routingContext);
                            if (testPath.cost >= 0 && (bestPath == null || testPath.cost < bestPath.cost)) {
                                bestPath = testPath;
                            }
                        }
                        finally {
                            this.routingContext.unsetWaypoint();
                        }
                        if (otherPath == path) continue;
                        otherPath.airdistance = -1;
                    }
                    if (bestPath != null) {
                        boolean inRadius;
                        boolean trafficSim;
                        boolean bl = trafficSim = endPos == null;
                        bestPath.airdistance = trafficSim ? path.airdistance : (isFinalLink ? 0 : nextNode.calcDistance(endPos));
                        boolean bl2 = inRadius = this.boundary == null || this.boundary.isInBoundary(nextNode, bestPath.cost);
                        if (inRadius && (isFinalLink || bestPath.cost + bestPath.airdistance <= maxTotalCost + 10)) {
                            OsmLinkHolder dominator;
                            for (dominator = link2.firstlinkholder; !trafficSim && dominator != null && !bestPath.definitlyWorseThan((OsmPath)dominator, this.routingContext); dominator = dominator.getNextForLink()) {
                            }
                            if (dominator == null) {
                                if (trafficSim && this.boundary != null && path.cost == 0 && bestPath.cost > 0) {
                                    bestPath.airdistance += this.boundary.getBoundaryDistance(nextNode);
                                }
                                bestPath.treedepth = path.treedepth + 1;
                                link2.addLinkHolder(bestPath);
                                SortedHeap<OsmPath> sortedHeap = this.openSet;
                                synchronized (sortedHeap) {
                                    this.addToOpenset(bestPath);
                                }
                            }
                        }
                    }
                }
                link2 = link2.next;
            }
            if (counterLink != null && counterLink.firstlinkholder == null) {
                currentNode.unlinkLink(counterLink);
            }
            path.unregisterUpTree(this.routingContext);
        }
        return null;
    }

    private void addToOpenset(OsmPath path) {
        if (path.cost >= 0) {
            this.openSet.add(path.cost + (int)((double)path.airdistance * this.airDistanceCostFactor), path);
            path.registerUpTree();
        }
    }

    private void preloadPosition(OsmNode n, int minRingWidth, int minCount) {
        int ring = 0;
        for (int c = 0; ring <= minRingWidth || c < minCount && ring <= 5; c += this.preloadRing(n, ring++)) {
        }
    }

    private int preloadRing(OsmNode n, int ring) {
        int d = 12500;
        int c = 0;
        for (int idxLat = -ring; idxLat <= ring; ++idxLat) {
            for (int idxLon = -ring; idxLon <= ring; ++idxLon) {
                int max;
                int absLat = idxLat < 0 ? -idxLat : idxLat;
                int absLon = idxLon < 0 ? -idxLon : idxLon;
                int n2 = max = absLat > absLon ? absLat : absLon;
                if (max < ring) continue;
                c += this.nodesCache.loadSegmentFor(n.ilon + d * idxLon, n.ilat + d * idxLat);
            }
        }
        return c;
    }

    private OsmTrack compileTrack(OsmPath path, boolean verbose) {
        OsmPathElement element = OsmPathElement.create(path, false);
        if (this.guideTrack != null) {
            element = element.origin;
        }
        OsmTrack track = new OsmTrack();
        track.cost = path.cost;
        int distance = 0;
        double ascend = 0.0;
        double ehb = 0.0;
        int ele_start = Short.MIN_VALUE;
        int ele_end = Short.MIN_VALUE;
        while (element != null) {
            track.addNode(element);
            OsmPathElement nextElement = element.origin;
            short ele = element.getSElev();
            if (ele != Short.MIN_VALUE) {
                ele_start = ele;
            }
            if (ele_end == Short.MIN_VALUE) {
                ele_end = ele;
            }
            if (nextElement != null) {
                distance += element.calcDistance(nextElement);
                short ele_next = nextElement.getSElev();
                if (ele_next != Short.MIN_VALUE) {
                    ehb += (double)(ele - ele_next) / 4.0;
                }
                if (ehb > 10.0) {
                    ascend += ehb - 10.0;
                    ehb = 10.0;
                } else if (ehb < 0.0) {
                    ehb = 0.0;
                }
            }
            element = nextElement;
        }
        track.distance = distance;
        track.ascend = (int)(ascend += ehb);
        track.plainAscend = (ele_end - ele_start) / 4;
        this.logInfo("track-length = " + track.distance);
        this.logInfo("filtered ascend = " + track.ascend);
        track.buildMap();
        return track;
    }

    private OsmTrack mergeTrack(OsmPathElement match, OsmTrack oldTrack) {
        OsmPathElement element = match;
        OsmTrack track = new OsmTrack();
        while (element != null) {
            track.addNode(element);
            element = element.origin;
        }
        long lastId = 0L;
        long id1 = match.getIdFromPos();
        long id0 = match.origin == null ? 0L : match.origin.getIdFromPos();
        boolean appending = false;
        for (OsmPathElement n : oldTrack.nodes) {
            long id;
            if (appending) {
                track.nodes.add(n);
            }
            if ((id = n.getIdFromPos()) == id1 && lastId == id0) {
                appending = true;
            }
            lastId = id;
        }
        track.buildMap();
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getOpenSet() {
        SortedHeap<OsmPath> sortedHeap = this.openSet;
        synchronized (sortedHeap) {
            List<OsmPath> extract = this.openSet.getExtract();
            int[] res = new int[extract.size() * 2];
            int i = 0;
            for (OsmPath p : extract) {
                OsmNode n = p.getLink().targetNode;
                res[i++] = n.ilon;
                res[i++] = n.ilat;
            }
            return res;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getLinksProcessed() {
        return this.linksProcessed;
    }

    public int getDistance() {
        return this.foundTrack.distance;
    }

    public int getAscend() {
        return this.foundTrack.ascend;
    }

    public int getPlainAscend() {
        return this.foundTrack.plainAscend;
    }

    public OsmTrack getFoundTrack() {
        return this.foundTrack;
    }

    public int getAlternativeIndex() {
        return this.alternativeIndex;
    }

    public OsmTrack getFoundRawTrack() {
        return this.foundRawTrack;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void terminate() {
        this.terminated = true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

