/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.codec.MicroCache;
import btools.codec.MicroCache1;
import btools.codec.MicroCache2;
import btools.mapcreator.OsmLinkP;
import java.io.IOException;
import java.util.ArrayList;

public class OsmNodeP
extends OsmLinkP {
    public static final int SIGNLON_BITMASK = 128;
    public static final int SIGNLAT_BITMASK = 64;
    public static final int TRANSFERNODE_BITMASK = 32;
    public static final int WRITEDESC_BITMASK = 16;
    public static final int SKIPDETAILS_BITMASK = 8;
    public static final int NODEDESC_BITMASK = 4;
    public int ilat;
    public int ilon;
    public short selev;
    public static final int NO_BRIDGE_BIT = 1;
    public static final int NO_TUNNEL_BIT = 2;
    public static final int BORDER_BIT = 4;
    public static final int TRAFFIC_BIT = 8;
    public static final int ANY_WAY_BIT = 16;
    public static final int MULTI_WAY_BIT = 32;
    public byte bits = 0;

    public int getILat() {
        return this.ilat;
    }

    public int getILon() {
        return this.ilon;
    }

    public short getSElev() {
        return (this.bits & 1) == 0 || (this.bits & 2) == 0 ? (short)Short.MIN_VALUE : this.selev;
    }

    public double getElev() {
        return (double)this.selev / 4.0;
    }

    public OsmLinkP createLink(OsmNodeP source) {
        if (this.sourceNode == null && this.targetNode == null) {
            this.sourceNode = source;
            this.targetNode = this;
            source.addLink(this);
            return this;
        }
        OsmLinkP link = new OsmLinkP(source, this);
        this.addLink(link);
        source.addLink(link);
        return link;
    }

    public void addLink(OsmLinkP link) {
        link.setNext(this.previous, this);
        this.previous = link;
    }

    public OsmLinkP getFirstLink() {
        return this.sourceNode == null && this.targetNode == null ? this.previous : this;
    }

    public byte[] getNodeDecsription() {
        return null;
    }

    public void writeNodeData1(MicroCache1 mc) throws IOException {
        mc.writeShort(this.getSElev());
        byte[] nodeDescription = this.getNodeDecsription();
        block0: for (OsmLinkP link0 = this.getFirstLink(); link0 != null; link0 = link0.getNext(this)) {
            OsmNodeP target;
            int skipDetailBit;
            int ilonref = this.ilon;
            int ilatref = this.ilat;
            OsmLinkP link = link0;
            OsmNodeP origin = this;
            int n = skipDetailBit = link0.descriptionBitmap == null ? 8 : 0;
            while (link != null && (target = link.getTarget(origin)).isTransferNode()) {
                for (link = target.getFirstLink(); link != null && link.getTarget(target) == origin; link = link.getNext(target)) {
                }
                origin = target;
            }
            if (link == null) continue;
            if (skipDetailBit == 0) {
                link = link0;
                origin = this;
            }
            byte[] lastDescription = null;
            while (link != null) {
                if (link.descriptionBitmap == null && skipDetailBit == 0) {
                    throw new IllegalArgumentException("missing way description...");
                }
                OsmNodeP target2 = link.getTarget(origin);
                int tranferbit = target2.isTransferNode() ? 32 : 0;
                int nodedescbit = nodeDescription != null ? 4 : 0;
                int writedescbit = 0;
                if (skipDetailBit == 0) {
                    boolean equalsCurrent;
                    int inverseBitByteIndex = 0;
                    boolean inverseDirection = link.isReverse(origin);
                    byte[] ab = link.descriptionBitmap;
                    int abLen = ab.length;
                    int lastLen = lastDescription == null ? 0 : lastDescription.length;
                    boolean bl = equalsCurrent = abLen == lastLen;
                    if (equalsCurrent) {
                        for (int i = 0; i < abLen; ++i) {
                            byte b = ab[i];
                            if (i == inverseBitByteIndex && inverseDirection) {
                                b = (byte)(b ^ 1);
                            }
                            if (b == lastDescription[i]) continue;
                            equalsCurrent = false;
                            break;
                        }
                    }
                    if (!equalsCurrent) {
                        writedescbit = 16;
                        lastDescription = new byte[abLen];
                        System.arraycopy(ab, 0, lastDescription, 0, abLen);
                        if (inverseDirection) {
                            int n2 = inverseBitByteIndex;
                            lastDescription[n2] = (byte)(lastDescription[n2] ^ 1);
                        }
                    }
                }
                int bm = tranferbit | writedescbit | nodedescbit | skipDetailBit;
                int dlon = target2.ilon - ilonref;
                int dlat = target2.ilat - ilatref;
                ilonref = target2.ilon;
                ilatref = target2.ilat;
                if (dlon < 0) {
                    bm |= 0x80;
                    dlon = -dlon;
                }
                if (dlat < 0) {
                    bm |= 0x40;
                    dlat = -dlat;
                }
                mc.writeByte(bm);
                mc.writeVarLengthUnsigned(dlon);
                mc.writeVarLengthUnsigned(dlat);
                if (writedescbit != 0) {
                    mc.writeByte(lastDescription.length);
                    mc.write(lastDescription);
                }
                if (nodedescbit != 0) {
                    mc.writeByte(nodeDescription.length);
                    mc.write(nodeDescription);
                    nodeDescription = null;
                }
                link.descriptionBitmap = null;
                if (tranferbit == 0) continue block0;
                mc.writeVarLengthSigned(target2.getSElev() - this.getSElev());
                for (link = target2.getFirstLink(); link != null && link.getTarget(target2) == origin; link = link.getNext(target2)) {
                }
                if (link == null) {
                    throw new RuntimeException("follow-up link not found for transfer-node!");
                }
                origin = target2;
            }
        }
    }

    public void writeNodeData(MicroCache mc) throws IOException {
        boolean valid = true;
        if (mc instanceof MicroCache1) {
            this.writeNodeData1((MicroCache1)mc);
        } else if (mc instanceof MicroCache2) {
            valid = this.writeNodeData2((MicroCache2)mc);
        } else {
            throw new IllegalArgumentException("unknown cache version: " + mc.getClass());
        }
        if (valid) {
            mc.finishNode(this.getIdFromPos());
        } else {
            mc.discardNode();
        }
    }

    public boolean writeNodeData2(MicroCache2 mc) throws IOException {
        boolean hasLinks = false;
        mc.writeShort(this.getSElev());
        mc.writeVarBytes(this.getNodeDecsription());
        ArrayList<OsmNodeP> internalReverse = new ArrayList<OsmNodeP>();
        for (OsmLinkP link0 = this.getFirstLink(); link0 != null; link0 = link0.getNext(this)) {
            OsmLinkP link = link0;
            OsmNodeP origin = this;
            OsmNodeP target = null;
            while (link != null && (target = link.getTarget(origin)).isTransferNode()) {
                for (link = target.getFirstLink(); link != null && link.getTarget(target) == origin; link = link.getNext(target)) {
                }
                if (link != null && link.descriptionBitmap != link0.descriptionBitmap) {
                    throw new IllegalArgumentException("assertion failed: description change along transfer nodes");
                }
                origin = target;
            }
            if (link == null || target == this) continue;
            hasLinks = true;
            boolean isReverse = link0.isReverse(this);
            if (isReverse && mc.isInternal(target.ilon, target.ilat)) {
                internalReverse.add(target);
                continue;
            }
            int sizeoffset = mc.writeSizePlaceHolder();
            mc.writeVarLengthSigned(target.ilon - this.ilon);
            mc.writeVarLengthSigned(target.ilat - this.ilat);
            mc.writeModeAndDesc(isReverse, link0.descriptionBitmap);
            if (!isReverse) {
                OsmNodeP tranferNode;
                link = link0;
                origin = this;
                while (link != null && (tranferNode = link.getTarget(origin)).isTransferNode()) {
                    mc.writeVarLengthSigned(tranferNode.ilon - origin.ilon);
                    mc.writeVarLengthSigned(tranferNode.ilat - origin.ilat);
                    mc.writeVarLengthSigned(tranferNode.getSElev() - origin.getSElev());
                    for (link = tranferNode.getFirstLink(); link != null && link.getTarget(tranferNode) == origin; link = link.getNext(tranferNode)) {
                    }
                    if (link == null) {
                        throw new RuntimeException("follow-up link not found for transfer-node!");
                    }
                    origin = tranferNode;
                }
            }
            mc.injectSize(sizeoffset);
        }
        while (internalReverse.size() > 0) {
            int nextIdx = 0;
            if (internalReverse.size() > 1) {
                int max32 = Integer.MIN_VALUE;
                for (int i = 0; i < internalReverse.size(); ++i) {
                    int id32 = mc.shrinkId(((OsmNodeP)internalReverse.get(i)).getIdFromPos());
                    if (id32 <= max32) continue;
                    max32 = id32;
                    nextIdx = i;
                }
            }
            OsmNodeP target = (OsmNodeP)internalReverse.remove(nextIdx);
            int sizeoffset = mc.writeSizePlaceHolder();
            mc.writeVarLengthSigned(target.ilon - this.ilon);
            mc.writeVarLengthSigned(target.ilat - this.ilat);
            mc.writeModeAndDesc(true, null);
            mc.injectSize(sizeoffset);
        }
        return hasLinks;
    }

    public String toString2() {
        return this.ilon - 180000000 + "_" + (this.ilat - 90000000) + "_" + this.selev / 4;
    }

    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public boolean isBorderNode() {
        return (this.bits & 4) != 0;
    }

    public boolean hasTraffic() {
        return (this.bits & 8) != 0;
    }

    public void incWayCount() {
        if ((this.bits & 0x10) != 0) {
            this.bits = (byte)(this.bits | 0x20);
        }
        this.bits = (byte)(this.bits | 0x10);
    }

    public boolean isTransferNode() {
        return (this.bits & 4) == 0 && (this.bits & 0x20) == 0 && this._linkCnt() == 2;
    }

    private int _linkCnt() {
        int cnt = 0;
        for (OsmLinkP link = this.getFirstLink(); link != null; link = link.getNext(this)) {
            ++cnt;
        }
        return cnt;
    }
}

