/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.MicroCache;
import btools.codec.MicroCache1;
import btools.codec.MicroCache2;
import btools.mapaccess.DistanceChecker;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.OsmPos;
import btools.mapaccess.OsmTransferNode;
import btools.util.ByteArrayUnifier;

public class OsmNode
implements OsmPos {
    public static final int EXTERNAL_BITMASK = 128;
    public static final int SIGNLON_BITMASK = 128;
    public static final int SIGNLAT_BITMASK = 64;
    public static final int TRANSFERNODE_BITMASK = 32;
    public static final int WRITEDESC_BITMASK = 16;
    public static final int SKIPDETAILS_BITMASK = 8;
    public static final int NODEDESC_BITMASK = 4;
    public static final int RESERVED1_BITMASK = 2;
    public static final int RESERVED2_BITMASK = 1;
    public int ilat;
    public int ilon;
    public short selev;
    public byte[] nodeDescription;
    public OsmLink firstlink = null;

    public OsmNode() {
    }

    public OsmNode(int ilon, int ilat) {
        this.ilon = ilon;
        this.ilat = ilat;
    }

    public OsmNode(long id) {
        this.ilon = (int)(id >> 32);
        this.ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int getILat() {
        return this.ilat;
    }

    @Override
    public int getILon() {
        return this.ilon;
    }

    @Override
    public short getSElev() {
        return this.selev;
    }

    @Override
    public double getElev() {
        return (double)this.selev / 4.0;
    }

    public void addLink(OsmLink link) {
        if (this.firstlink == null) {
            this.firstlink = link;
        } else {
            OsmLink l = this.firstlink;
            while (l.next != null) {
                l = l.next;
            }
            l.next = link;
        }
    }

    private OsmLink getCompatibleLink(int ilon, int ilat, boolean counterLinkWritten, int state) {
        OsmNode t;
        OsmLink l = this.firstlink;
        while (l != null) {
            if (counterLinkWritten == l.counterLinkWritten && l.state == state) {
                t = l.targetNode;
                if (t.ilon == ilon && t.ilat == ilat) {
                    l.state = 0;
                    return l;
                }
            }
            l = l.next;
        }
        l = this.firstlink;
        while (l != null) {
            if (l.state == state) {
                t = l.targetNode;
                if (t.ilon == ilon && t.ilat == ilat) {
                    l.state = 0;
                    return l;
                }
            }
            l = l.next;
        }
        return null;
    }

    @Override
    public int calcDistance(OsmPos p) {
        double l = (double)(this.ilat - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        double coslat = 1.0 - l2 + l4 / 6.0;
        double dlat = (double)(this.ilat - p.getILat()) / 1000000.0;
        double dlon = (double)(this.ilon - p.getILon()) / 1000000.0 * coslat;
        double d = Math.sqrt(dlat * dlat + dlon * dlon) * 111308.90052356021;
        return (int)(d + 1.0);
    }

    public String toString() {
        return "" + this.getIdFromPos();
    }

    public void parseNodeBody(MicroCache mc, OsmNodesMap hollowNodes, DistanceChecker dc) {
        if (mc instanceof MicroCache1) {
            this.parseNodeBody1((MicroCache1)mc, hollowNodes, dc);
        } else if (mc instanceof MicroCache2) {
            this.parseNodeBody2((MicroCache2)mc, hollowNodes, dc);
        } else {
            throw new IllegalArgumentException("unknown cache version: " + mc.getClass());
        }
    }

    public void parseNodeBody2(MicroCache2 mc, OsmNodesMap hollowNodes, DistanceChecker dc) {
        ByteArrayUnifier abUnifier = hollowNodes.getByteArrayUnifier();
        this.selev = mc.readShort();
        int nodeDescSize = mc.readVarLengthUnsigned();
        byte[] byArray = this.nodeDescription = nodeDescSize == 0 ? null : mc.readUnified(nodeDescSize, abUnifier);
        while (mc.hasMoreData()) {
            OsmLink rlink;
            int endPointer = mc.getEndPointer();
            int linklon = this.ilon + mc.readVarLengthSigned();
            int linklat = this.ilat + mc.readVarLengthSigned();
            int sizecode = mc.readVarLengthUnsigned();
            boolean isReverse = (sizecode & 1) != 0;
            byte[] description = null;
            int descSize = sizecode >> 1;
            if (descSize > 0) {
                description = mc.readUnified(descSize, abUnifier);
            }
            byte[] geometry = mc.readDataUntil(endPointer);
            if (dc != null || linklon == this.ilon && linklat == this.ilat) continue;
            OsmLink link = this.getCompatibleLink(linklon, linklat, isReverse, 2);
            if (link == null) {
                long targetNodeId = (long)linklon << 32 | (long)linklat;
                OsmNode tn = hollowNodes.get(targetNodeId);
                if (tn == null) {
                    tn = new OsmNode(linklon, linklat);
                    tn.setHollow();
                    hollowNodes.put(tn);
                }
                link = new OsmLink();
                link.targetNode = tn;
                link.counterLinkWritten = isReverse;
                link.state = 1;
                this.addLink(link);
            }
            if ((rlink = link.targetNode.getCompatibleLink(this.ilon, this.ilat, !isReverse, 1)) == null) {
                rlink = new OsmLink();
                rlink.targetNode = this;
                rlink.counterLinkWritten = !isReverse;
                rlink.state = (byte)2;
                link.targetNode.addLink(rlink);
            }
            if (isReverse) continue;
            link.descriptionBitmap = description;
            link.setGeometry(geometry);
            if (!rlink.counterLinkWritten) continue;
            rlink.descriptionBitmap = description;
            rlink.setGeometry(geometry);
        }
        if (dc == null) {
            hollowNodes.remove(this);
        }
    }

    public void parseNodeBody1(MicroCache1 is, OsmNodesMap hollowNodes, DistanceChecker dc) {
        ByteArrayUnifier abUnifier = hollowNodes.getByteArrayUnifier();
        this.selev = is.readShort();
        while (is.hasMoreData()) {
            OsmLink rlink;
            OsmTransferNode trans;
            int linklat;
            int linklon;
            int ilonref = this.ilon;
            int ilatref = this.ilat;
            boolean counterLinkWritten = false;
            OsmTransferNode firstTransferNode = null;
            OsmTransferNode lastTransferNode = null;
            byte[] description = null;
            while (true) {
                boolean isTransfer;
                byte[] ab;
                byte bitField = is.readByte();
                int dlon = is.readVarLengthUnsigned();
                int dlat = is.readVarLengthUnsigned();
                if ((bitField & 0x80) != 0) {
                    dlon = -dlon;
                }
                if ((bitField & 0x40) != 0) {
                    dlat = -dlat;
                }
                linklon = ilonref + dlon;
                linklat = ilatref + dlat;
                ilonref = linklon;
                ilatref = linklat;
                if ((bitField & 0x10) != 0) {
                    ab = new byte[is.readByte()];
                    is.readFully(ab);
                    description = abUnifier.unify(ab);
                }
                if ((bitField & 4) != 0) {
                    ab = new byte[is.readByte()];
                    is.readFully(ab);
                    this.nodeDescription = abUnifier.unify(ab);
                }
                if ((bitField & 2) != 0) {
                    ab = new byte[is.readByte()];
                    is.readFully(ab);
                }
                if ((bitField & 1) != 0) {
                    ab = new byte[is.readByte()];
                    is.readFully(ab);
                }
                if ((bitField & 8) != 0) {
                    counterLinkWritten = true;
                }
                if (description == null && !counterLinkWritten) {
                    throw new IllegalArgumentException("internal error: missing way description!");
                }
                boolean bl = isTransfer = (bitField & 0x20) != 0;
                if (!isTransfer) break;
                trans = new OsmTransferNode();
                trans.ilon = linklon;
                trans.ilat = linklat;
                trans.descriptionBitmap = description;
                trans.selev = (short)(this.selev + is.readVarLengthSigned());
                if (lastTransferNode == null) {
                    firstTransferNode = trans;
                } else {
                    lastTransferNode.next = trans;
                }
                lastTransferNode = trans;
            }
            if (dc != null && !counterLinkWritten && !dc.isWithinRadius(this.ilon, this.ilat, firstTransferNode, linklon, linklat) || linklon == this.ilon && linklat == this.ilat) continue;
            OsmLink link = this.getCompatibleLink(linklon, linklat, counterLinkWritten, 2);
            if (link == null) {
                long targetNodeId = (long)linklon << 32 | (long)linklat;
                OsmNode tn = hollowNodes.get(targetNodeId);
                if (tn == null) {
                    tn = new OsmNode(linklon, linklat);
                    tn.setHollow();
                    hollowNodes.put(tn);
                }
                link = new OsmLink();
                link.targetNode = tn;
                link.counterLinkWritten = counterLinkWritten;
                link.state = 1;
                this.addLink(link);
            }
            if ((rlink = link.targetNode.getCompatibleLink(this.ilon, this.ilat, !counterLinkWritten, 1)) == null) {
                rlink = new OsmLink();
                rlink.targetNode = this;
                rlink.counterLinkWritten = !counterLinkWritten;
                rlink.state = (byte)2;
                link.targetNode.addLink(rlink);
            }
            if (counterLinkWritten) continue;
            link.descriptionBitmap = description;
            link.encodeFirsttransfer(firstTransferNode);
            if (!rlink.counterLinkWritten) continue;
            rlink.descriptionBitmap = description;
            OsmTransferNode previous = null;
            OsmTransferNode rtrans = null;
            trans = firstTransferNode;
            while (trans != null) {
                if (previous == null) {
                    rlink.descriptionBitmap = trans.descriptionBitmap;
                } else {
                    previous.descriptionBitmap = trans.descriptionBitmap;
                }
                rtrans = new OsmTransferNode();
                rtrans.ilon = trans.ilon;
                rtrans.ilat = trans.ilat;
                rtrans.selev = trans.selev;
                rtrans.next = previous;
                rtrans.descriptionBitmap = description;
                previous = rtrans;
                trans = trans.next;
            }
            rlink.encodeFirsttransfer(rtrans);
        }
        if (dc == null) {
            hollowNodes.remove(this);
        }
    }

    public boolean isHollow() {
        return this.selev == -12345;
    }

    public void setHollow() {
        this.selev = (short)-12345;
    }

    @Override
    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public void unlinkLink(OsmLink link) {
        if (link == this.firstlink) {
            this.firstlink = link.next;
            return;
        }
        OsmLink l = this.firstlink;
        while (l != null) {
            if (l.next == link) {
                l.next = link.next;
                return;
            }
            l = l.next;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof OsmNode) {
            OsmNode n = (OsmNode)o;
            return n.ilon == this.ilon && n.ilat == this.ilat;
        }
        return false;
    }

    public int hashCode() {
        return this.ilon + this.ilat;
    }
}

