/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.OsmLinkHolder;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmTransferNode;
import btools.util.ByteDataReader;

public class OsmLink {
    public byte[] descriptionBitmap;
    public OsmNode targetNode;
    public OsmLink next;
    public OsmLinkHolder firstlinkholder = null;
    public byte[] geometry;
    public boolean counterLinkWritten;
    public boolean hasNewGeometry;
    public byte state;

    public void setGeometry(byte[] geometry) {
        this.geometry = geometry;
        this.hasNewGeometry = true;
    }

    public final OsmTransferNode decodeFirsttransfer(OsmNode sourceNode) {
        if (this.geometry == null) {
            return null;
        }
        if (this.hasNewGeometry) {
            OsmTransferNode firstTransferNode = null;
            OsmTransferNode lastTransferNode = null;
            OsmNode startnode = this.counterLinkWritten ? this.targetNode : sourceNode;
            ByteDataReader r = new ByteDataReader(this.geometry);
            int olon = startnode.ilon;
            int olat = startnode.ilat;
            short oselev = startnode.selev;
            while (r.hasMoreData()) {
                OsmTransferNode trans = new OsmTransferNode();
                trans.ilon = olon + r.readVarLengthSigned();
                trans.ilat = olat + r.readVarLengthSigned();
                trans.descriptionBitmap = this.descriptionBitmap;
                trans.selev = (short)(oselev + r.readVarLengthSigned());
                olon = trans.ilon;
                olat = trans.ilat;
                oselev = trans.selev;
                if (this.counterLinkWritten) {
                    trans.next = firstTransferNode;
                    firstTransferNode = trans;
                    continue;
                }
                if (lastTransferNode == null) {
                    firstTransferNode = trans;
                } else {
                    lastTransferNode.next = trans;
                }
                lastTransferNode = trans;
            }
            return firstTransferNode;
        }
        return OsmTransferNode.decode(this.geometry);
    }

    public final void encodeFirsttransfer(OsmTransferNode firsttransfer) {
        this.geometry = (byte[])(firsttransfer == null ? null : OsmTransferNode.encode(firsttransfer));
    }

    public final void addLinkHolder(OsmLinkHolder holder) {
        if (this.firstlinkholder != null) {
            holder.setNextForLink(this.firstlinkholder);
        }
        this.firstlinkholder = holder;
    }

    public String toString() {
        return "Link(target=" + this.targetNode.getIdFromPos() + " counterLinkWritten=" + this.counterLinkWritten + " state=" + this.state + ")";
    }
}

