/*
 * Decompiled with CFR 0.152.
 */
package btools.codec;

import btools.codec.TagValueValidator;
import btools.util.BitCoderContext;
import java.util.HashMap;
import java.util.PriorityQueue;

public final class TagValueCoder {
    private HashMap<TagValueSet, TagValueSet> identityMap;
    private Object tree;
    private BitCoderContext bc;
    private int pass;

    public void encodeTagValueSet(byte[] data) {
        if (this.pass == 1) {
            return;
        }
        TagValueSet tvsProbe = new TagValueSet();
        tvsProbe.data = data;
        TagValueSet tvs = this.identityMap.get(tvsProbe);
        if (this.pass == 3) {
            this.bc.encodeBounded(tvs.range - 1, tvs.code);
        } else if (this.pass == 2) {
            if (tvs == null) {
                tvs = tvsProbe;
                this.identityMap.put(tvs, tvs);
            }
            ++tvs.frequency;
        }
    }

    public byte[] decodeTagValueSet() {
        Object node = this.tree;
        while (node instanceof TreeNode) {
            TreeNode tn = (TreeNode)node;
            boolean nextBit = this.bc.decodeBit();
            node = nextBit ? tn.child2 : tn.child1;
        }
        return (byte[])node;
    }

    public void encodeDictionary(BitCoderContext bc) {
        if (++this.pass == 3) {
            PriorityQueue<TagValueSet> queue = new PriorityQueue<TagValueSet>(this.identityMap.values());
            while (queue.size() > 1) {
                TagValueSet node = new TagValueSet();
                node.child1 = queue.poll();
                node.child2 = queue.poll();
                node.frequency = node.child1.frequency + node.child2.frequency;
                queue.add(node);
            }
            TagValueSet root = queue.poll();
            root.encode(bc, 1, 0);
        }
        this.bc = bc;
    }

    public TagValueCoder(BitCoderContext bc, byte[] buffer, TagValueValidator validator) {
        this.tree = this.decodeTree(bc, buffer, validator);
        this.bc = bc;
    }

    public TagValueCoder() {
        this.identityMap = new HashMap();
    }

    private Object decodeTree(BitCoderContext bc, byte[] buffer, TagValueValidator validator) {
        boolean isNode = bc.decodeBit();
        if (isNode) {
            TreeNode node = new TreeNode();
            node.child1 = this.decodeTree(bc, buffer, validator);
            node.child2 = this.decodeTree(bc, buffer, validator);
            return node;
        }
        BitCoderContext target = null;
        while (true) {
            int delta = bc.decodeVarBits();
            if (target == null) {
                if (delta == 0) {
                    return null;
                }
                target = new BitCoderContext(buffer);
                target.encodeBit(false);
            }
            target.encodeVarBits(delta);
            if (delta == 0) break;
            int data = bc.decodeVarBits();
            target.encodeVarBits(data);
        }
        int len = target.getEncodedLength();
        byte[] res = new byte[len];
        System.arraycopy(buffer, 0, res, 0, len);
        if (validator == null || validator.accessAllowed(res)) {
            return res;
        }
        return null;
    }

    public static final class TagValueSet
    implements Comparable<TagValueSet> {
        public byte[] data;
        public int frequency;
        public int code;
        public int range;
        public TagValueSet child1;
        public TagValueSet child2;

        public void encode(BitCoderContext bc, int range, int code) {
            this.range = range;
            this.code = code;
            boolean isNode = this.child1 != null;
            bc.encodeBit(isNode);
            if (isNode) {
                this.child1.encode(bc, range << 1, code);
                this.child2.encode(bc, range << 1, code + range);
            } else {
                if (this.data == null) {
                    bc.encodeVarBits(0);
                    return;
                }
                BitCoderContext src = new BitCoderContext(this.data);
                if (src.decodeBit()) {
                    throw new IllegalArgumentException("cannot encode reverse bit!");
                }
                while (true) {
                    int delta = src.decodeVarBits();
                    bc.encodeVarBits(delta);
                    if (delta == 0) break;
                    int data = src.decodeVarBits();
                    bc.encodeVarBits(data);
                }
            }
        }

        public boolean equals(Object o) {
            if (o instanceof TagValueSet) {
                TagValueSet tvs = (TagValueSet)o;
                if (this.data == null) {
                    return tvs.data == null;
                }
                if (tvs.data == null) {
                    return this.data == null;
                }
                if (this.data.length != tvs.data.length) {
                    return false;
                }
                for (int i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == tvs.data[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.data == null) {
                return 0;
            }
            int h = 17;
            for (int i = 0; i < this.data.length; ++i) {
                h = (h << 8) + this.data[i];
            }
            return h;
        }

        @Override
        public int compareTo(TagValueSet tvs) {
            if (this.frequency < tvs.frequency) {
                return -1;
            }
            if (this.frequency > tvs.frequency) {
                return 1;
            }
            return 0;
        }
    }

    public static final class TreeNode {
        public Object child1;
        public Object child2;
    }
}

