/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmPos;
import btools.router.MessageData;
import btools.router.OsmPath;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class OsmPathElement
implements OsmPos {
    private int ilat;
    private int ilon;
    private short selev;
    public MessageData message = null;
    public int cost;
    public OsmPathElement origin;

    @Override
    public int getILat() {
        return this.ilat;
    }

    @Override
    public int getILon() {
        return this.ilon;
    }

    @Override
    public short getSElev() {
        return this.selev;
    }

    @Override
    public double getElev() {
        return (double)this.selev / 4.0;
    }

    @Override
    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    @Override
    public int calcDistance(OsmPos p) {
        double l = (double)(this.ilat - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        double coslat = 1.0 - l2 + l4 / 6.0;
        double dlat = (double)(this.ilat - p.getILat()) / 1000000.0;
        double dlon = (double)(this.ilon - p.getILon()) / 1000000.0 * coslat;
        double d = Math.sqrt(dlat * dlat + dlon * dlon) * 111894.73684210527;
        return (int)(d + 1.0);
    }

    public OsmPathElement(OsmPath path) {
        OsmNode n = path.getLink().targetNode;
        this.ilat = n.getILat();
        this.ilon = n.getILon();
        this.selev = path.selev;
        this.cost = path.cost;
        this.origin = path.originElement;
        this.message = path.message;
    }

    public OsmPathElement(int ilon, int ilat, short selev, OsmPathElement origin) {
        this.ilon = ilon;
        this.ilat = ilat;
        this.selev = selev;
        this.origin = origin;
    }

    private OsmPathElement() {
    }

    public String toString() {
        return this.ilon + "_" + this.ilat;
    }

    public void writeToStream(DataOutput dos) throws IOException {
        dos.writeInt(this.ilat);
        dos.writeInt(this.ilon);
        dos.writeShort(this.selev);
        dos.writeInt(this.cost);
    }

    public static OsmPathElement readFromStream(DataInput dis) throws IOException {
        OsmPathElement pe = new OsmPathElement();
        pe.ilat = dis.readInt();
        pe.ilon = dis.readInt();
        pe.selev = dis.readShort();
        pe.cost = dis.readInt();
        return pe;
    }
}

