/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

final class MessageData
implements Cloneable {
    int linkdist = 0;
    int linkelevationcost = 0;
    int linkturncost = 0;
    int linknodecost = 0;
    int linkinitcost = 0;
    float costfactor;
    String wayKeyValues;
    String nodeKeyValues;
    int lon;
    int lat;
    short ele;

    MessageData() {
    }

    String toMessage() {
        if (this.wayKeyValues == null) {
            return null;
        }
        int iCost = (int)(this.costfactor * 1000.0f + 0.5f);
        return this.lon - 180000000 + "\t" + (this.lat - 90000000) + "\t" + this.ele / 4 + "\t" + this.linkdist + "\t" + iCost + "\t" + this.linkelevationcost + "\t" + this.linkturncost + "\t" + this.linknodecost + "\t" + this.linkinitcost + "\t" + this.wayKeyValues + "\t" + (this.nodeKeyValues == null ? "" : this.nodeKeyValues);
    }

    void add(MessageData d) {
        this.linkdist += d.linkdist;
        this.linkelevationcost += d.linkelevationcost;
        this.linkturncost += d.linkturncost;
        this.linknodecost += d.linknodecost;
        this.linkinitcost += d.linkinitcost;
    }

    MessageData copy() {
        try {
            return (MessageData)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

