/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.expressions.BExpressionContextNode;
import btools.expressions.BExpressionContextWay;
import btools.expressions.BExpressionMetaData;
import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.OsmLinkP;
import btools.mapcreator.OsmNodeP;
import btools.mapcreator.OsmNodePT;
import btools.mapcreator.WayData;
import btools.mapcreator.WayIterator;
import btools.util.ByteArrayUnifier;
import btools.util.ByteDataWriter;
import btools.util.CompactLongMap;
import btools.util.CompactLongSet;
import btools.util.Crc32;
import btools.util.DiffCoderDataOutputStream;
import btools.util.FrozenLongMap;
import btools.util.FrozenLongSet;
import btools.util.LazyArrayOfLists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.List;

public class WayLinker
extends MapCreatorBase {
    private File nodeTilesIn;
    private File dataTilesOut;
    private File borderFileIn;
    private String dataTilesSuffix;
    private boolean readingBorder;
    private CompactLongMap<OsmNodeP> nodesMap;
    private List<OsmNodeP> nodesList;
    private CompactLongSet borderSet;
    private short lookupVersion;
    private short lookupMinorVersion;
    private boolean writeVarLength;
    private long creationTimeStamp;
    private BExpressionContextWay expctxWay;
    private BExpressionContextNode expctxNode;
    private ByteArrayUnifier abUnifier;
    private int minLon;
    private int minLat;

    private void reset() {
        this.minLon = -1;
        this.minLat = -1;
        this.nodesMap = new CompactLongMap();
        this.borderSet = new CompactLongSet();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("*** WayLinker: Format a region of an OSM map for routing");
        if (args.length != 7) {
            System.out.println("usage: java WayLinker <node-tiles-in> <way-tiles-in> <bordernodes> <lookup-file> <profile-file> <data-tiles-out> <data-tiles-suffix> ");
            return;
        }
        new WayLinker().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]), new File(args[4]), new File(args[5]), args[6]);
    }

    public void process(File nodeTilesIn, File wayTilesIn, File borderFileIn, File lookupFile, File profileFile, File dataTilesOut, String dataTilesSuffix) throws Exception {
        this.nodeTilesIn = nodeTilesIn;
        this.dataTilesOut = dataTilesOut;
        this.borderFileIn = borderFileIn;
        this.dataTilesSuffix = dataTilesSuffix;
        BExpressionMetaData meta = new BExpressionMetaData();
        this.expctxWay = new BExpressionContextWay(meta);
        this.expctxNode = new BExpressionContextNode(meta);
        meta.readMetaData(lookupFile);
        this.lookupVersion = meta.lookupVersion;
        this.lookupMinorVersion = meta.lookupMinorVersion;
        this.writeVarLength = meta.readVarLength;
        this.expctxWay.parseFile(profileFile, "global");
        this.expctxNode.parseFile(profileFile, "global");
        this.creationTimeStamp = System.currentTimeMillis();
        this.abUnifier = new ByteArrayUnifier(16384, false);
        new WayIterator(this, true).processDir(wayTilesIn, ".wt5");
    }

    @Override
    public void wayFileStart(File wayfile) throws Exception {
        File nodeFile = this.fileFromTemplate(wayfile, this.nodeTilesIn, "u5d");
        if (nodeFile.exists()) {
            this.reset();
            this.readingBorder = true;
            new NodeIterator(this, false).processFile(this.borderFileIn);
            this.borderSet = new FrozenLongSet(this.borderSet);
            this.readingBorder = false;
            new NodeIterator(this, true).processFile(nodeFile);
            FrozenLongMap<OsmNodeP> nodesMapFrozen = new FrozenLongMap<OsmNodeP>(this.nodesMap);
            this.nodesMap = nodesMapFrozen;
            this.nodesList = nodesMapFrozen.getValueList();
        }
    }

    @Override
    public void nextNode(NodeData data) throws Exception {
        OsmNodeP n = data.description == null ? new OsmNodeP() : new OsmNodePT(data.description);
        n.ilon = data.ilon;
        n.ilat = data.ilat;
        n.selev = data.selev;
        n.isBorder = this.readingBorder;
        if (this.readingBorder || !this.borderSet.contains(data.nid)) {
            this.nodesMap.fastPut(data.nid, n);
        }
        if (this.readingBorder) {
            this.borderSet.fastAdd(data.nid);
            return;
        }
        int min_lon = n.ilon / 5000000 * 5000000;
        int min_lat = n.ilat / 5000000 * 5000000;
        if (this.minLon == -1) {
            this.minLon = min_lon;
        }
        if (this.minLat == -1) {
            this.minLat = min_lat;
        }
        if (this.minLat != min_lat || this.minLon != min_lon) {
            throw new IllegalArgumentException("inconsistent node: " + n.ilon + " " + n.ilat);
        }
    }

    @Override
    public void nextWay(WayData way) throws Exception {
        byte[] description = this.abUnifier.unify(way.description);
        this.expctxWay.evaluate(false, description, null);
        boolean ok = (double)this.expctxWay.getCostfactor() < 10000.0;
        this.expctxWay.evaluate(true, description, null);
        if (!(ok |= (double)this.expctxWay.getCostfactor() < 10000.0)) {
            return;
        }
        byte wayBits = 0;
        this.expctxWay.decode(description);
        if (!this.expctxWay.getBooleanLookupValue("bridge")) {
            wayBits = (byte)(wayBits | 1);
        }
        if (!this.expctxWay.getBooleanLookupValue("tunnel")) {
            wayBits = (byte)(wayBits | 2);
        }
        OsmNodeP n1 = null;
        OsmNodeP n2 = null;
        for (int i = 0; i < way.nodes.size(); ++i) {
            long nid = way.nodes.get(i);
            n1 = n2;
            n2 = this.nodesMap.get(nid);
            if (n1 != null && n2 != null && n1 != n2) {
                OsmLinkP link = n2.createLink(n1);
                link.descriptionBitmap = description;
            }
            if (n2 == null) continue;
            n2.wayBits = (byte)(n2.wayBits | wayBits);
        }
    }

    @Override
    public void wayFileEnd(File wayfile) throws Exception {
        this.nodesMap = null;
        this.borderSet = null;
        byte[] abBuf = new byte[0x100000];
        byte[] abBuf2 = new byte[0xA00000];
        int maxLon = this.minLon + 5000000;
        int maxLat = this.minLat + 5000000;
        int nLonSegs = (maxLon - this.minLon) / 1000000;
        int nLatSegs = (maxLat - this.minLat) / 1000000;
        LazyArrayOfLists seglists = new LazyArrayOfLists(nLonSegs * nLatSegs);
        for (OsmNodeP n : this.nodesList) {
            if (n == null || n.getFirstLink() == null || n.isTransferNode() || n.ilon < this.minLon || n.ilon >= maxLon || n.ilat < this.minLat || n.ilat >= maxLat) continue;
            int lonIdx = (n.ilon - this.minLon) / 1000000;
            int latIdx = (n.ilat - this.minLat) / 1000000;
            int tileIndex = lonIdx * nLatSegs + latIdx;
            seglists.getList(tileIndex).add(n);
        }
        this.nodesList = null;
        seglists.trimAll();
        File outfile = this.fileFromTemplate(wayfile, this.dataTilesOut, this.dataTilesSuffix);
        DiffCoderDataOutputStream os = this.createOutStream(outfile);
        long[] fileIndex = new long[25];
        int[] fileHeaderCrcs = new int[25];
        for (int i55 = 0; i55 < 25; ++i55) {
            os.writeLong(0L);
        }
        long filepos = 200L;
        for (int lonIdx = 0; lonIdx < nLonSegs; ++lonIdx) {
            for (int latIdx = 0; latIdx < nLatSegs; ++latIdx) {
                int tileIndex = lonIdx * nLatSegs + latIdx;
                if (seglists.getSize(tileIndex) > 0) {
                    List nlist = seglists.getList(tileIndex);
                    LazyArrayOfLists subs = new LazyArrayOfLists(6400);
                    byte[][] subByteArrays = new byte[6400][];
                    for (int ni = 0; ni < nlist.size(); ++ni) {
                        OsmNodeP n = (OsmNodeP)nlist.get(ni);
                        int subLonIdx = (n.ilon - this.minLon) / 12500 - 80 * lonIdx;
                        int subLatIdx = (n.ilat - this.minLat) / 12500 - 80 * latIdx;
                        int si = subLatIdx * 80 + subLonIdx;
                        subs.getList(si).add(n);
                    }
                    subs.trimAll();
                    int[] posIdx = new int[6400];
                    int pos = 25600;
                    for (int si = 0; si < 6400; ++si) {
                        List subList = subs.getList(si);
                        if (subList.size() > 0) {
                            Collections.sort(subList);
                            ByteDataWriter dos = new ByteDataWriter(abBuf2);
                            dos.writeInt(subList.size());
                            for (int ni = 0; ni < subList.size(); ++ni) {
                                OsmNodeP n = (OsmNodeP)subList.get(ni);
                                n.writeNodeData(dos, this.writeVarLength, abBuf);
                            }
                            byte[] subBytes = dos.toByteArray();
                            pos += subBytes.length + 4;
                            subByteArrays[si] = subBytes;
                        }
                        posIdx[si] = pos;
                    }
                    byte[] abSubIndex = this.compileSubFileIndex(posIdx);
                    fileHeaderCrcs[tileIndex] = Crc32.crc(abSubIndex, 0, abSubIndex.length);
                    os.write(abSubIndex, 0, abSubIndex.length);
                    for (int si = 0; si < 6400; ++si) {
                        byte[] ab = subByteArrays[si];
                        if (ab == null) continue;
                        os.write(ab);
                        os.writeInt(Crc32.crc(ab, 0, ab.length));
                    }
                    filepos += (long)pos;
                }
                fileIndex[tileIndex] = filepos;
            }
        }
        byte[] abFileIndex = this.compileFileIndex(fileIndex, this.lookupVersion, this.lookupMinorVersion);
        os.writeLong(this.creationTimeStamp);
        os.writeInt(Crc32.crc(abFileIndex, 0, abFileIndex.length));
        for (int i55 = 0; i55 < 25; ++i55) {
            os.writeInt(fileHeaderCrcs[i55]);
        }
        os.close();
        RandomAccessFile ra = new RandomAccessFile(outfile, "rw");
        ra.write(abFileIndex, 0, abFileIndex.length);
        ra.close();
    }

    private byte[] compileFileIndex(long[] fileIndex, short lookupVersion, short lookupMinorVersion) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        for (int i55 = 0; i55 < 25; ++i55) {
            long versionPrefix = i55 == 1 ? (long)lookupMinorVersion : (long)lookupVersion;
            dos.writeLong(fileIndex[i55] | (versionPrefix <<= 48));
        }
        dos.close();
        return bos.toByteArray();
    }

    private byte[] compileSubFileIndex(int[] posIdx) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        for (int si = 0; si < 6400; ++si) {
            dos.writeInt(posIdx[si]);
        }
        dos.close();
        return bos.toByteArray();
    }
}

