/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.OsmLinkP;
import btools.util.ByteDataWriter;
import java.io.IOException;

public class OsmNodeP
extends OsmLinkP
implements Comparable<OsmNodeP> {
    public static final int SIGNLON_BITMASK = 128;
    public static final int SIGNLAT_BITMASK = 64;
    public static final int TRANSFERNODE_BITMASK = 32;
    public static final int WRITEDESC_BITMASK = 16;
    public static final int SKIPDETAILS_BITMASK = 8;
    public static final int NODEDESC_BITMASK = 4;
    public int ilat;
    public int ilon;
    public short selev;
    public boolean isBorder = false;
    public static final int NO_BRIDGE_BIT = 1;
    public static final int NO_TUNNEL_BIT = 2;
    public static final int LCN_BIT = 4;
    public static final int CR_BIT = 8;
    public byte wayBits = 0;

    public int getILat() {
        return this.ilat;
    }

    public int getILon() {
        return this.ilon;
    }

    public short getSElev() {
        return (this.wayBits & 1) == 0 || (this.wayBits & 2) == 0 ? (short)Short.MIN_VALUE : this.selev;
    }

    public double getElev() {
        return (double)this.selev / 4.0;
    }

    public OsmLinkP createLink(OsmNodeP source) {
        if (this.sourceNode == null && this.targetNode == null) {
            this.sourceNode = source;
            this.targetNode = this;
            source.addLink(this);
            return this;
        }
        OsmLinkP link = new OsmLinkP(source, this);
        this.addLink(link);
        source.addLink(link);
        return link;
    }

    public void addLink(OsmLinkP link) {
        link.setNext(this.previous, this);
        this.previous = link;
    }

    public OsmLinkP getFirstLink() {
        return this.sourceNode == null && this.targetNode == null ? this.previous : this;
    }

    public byte[] getNodeDecsription() {
        return null;
    }

    public void writeNodeData(ByteDataWriter os, boolean writeVarLength, byte[] abBuf) throws IOException {
        int lonIdx = this.ilon / 62500;
        int latIdx = this.ilat / 62500;
        ByteDataWriter os2 = new ByteDataWriter(abBuf);
        os2.writeShort(this.getSElev());
        byte[] nodeDescription = this.getNodeDecsription();
        block0: for (OsmLinkP link0 = this.getFirstLink(); link0 != null; link0 = link0.getNext(this)) {
            OsmNodeP target;
            int skipDetailBit;
            int ilonref = this.ilon;
            int ilatref = this.ilat;
            OsmLinkP link = link0;
            OsmNodeP origin = this;
            int n = skipDetailBit = link0.descriptionBitmap == null ? 8 : 0;
            while (link != null && (target = link.getTarget(origin)).isTransferNode()) {
                for (link = target.getFirstLink(); link != null && link.getTarget(target) == origin; link = link.getNext(target)) {
                }
                origin = target;
            }
            if (link == null) continue;
            if (skipDetailBit == 0) {
                link = link0;
                origin = this;
            }
            byte[] lastDescription = null;
            while (link != null) {
                if (link.descriptionBitmap == null && skipDetailBit == 0) {
                    throw new IllegalArgumentException("missing way description...");
                }
                OsmNodeP target2 = link.getTarget(origin);
                int tranferbit = target2.isTransferNode() ? 32 : 0;
                int nodedescbit = nodeDescription != null ? 4 : 0;
                int writedescbit = 0;
                if (skipDetailBit == 0) {
                    boolean equalsCurrent;
                    int inverseBitByteIndex = writeVarLength ? 0 : 7;
                    boolean inverseDirection = link.isReverse(origin);
                    byte[] ab = link.descriptionBitmap;
                    int abLen = ab.length;
                    int lastLen = lastDescription == null ? 0 : lastDescription.length;
                    boolean bl = equalsCurrent = abLen == lastLen;
                    if (equalsCurrent) {
                        for (int i = 0; i < abLen; ++i) {
                            byte b = ab[i];
                            if (i == inverseBitByteIndex && inverseDirection) {
                                b = (byte)(b ^ 1);
                            }
                            if (b == lastDescription[i]) continue;
                            equalsCurrent = false;
                            break;
                        }
                    }
                    if (!equalsCurrent) {
                        writedescbit = 16;
                        lastDescription = new byte[abLen];
                        System.arraycopy(ab, 0, lastDescription, 0, abLen);
                        if (inverseDirection) {
                            int n2 = inverseBitByteIndex;
                            lastDescription[n2] = (byte)(lastDescription[n2] ^ 1);
                        }
                    }
                }
                int bm = tranferbit | writedescbit | nodedescbit | skipDetailBit;
                int dlon = target2.ilon - ilonref;
                int dlat = target2.ilat - ilatref;
                ilonref = target2.ilon;
                ilatref = target2.ilat;
                if (dlon < 0) {
                    bm |= 0x80;
                    dlon = -dlon;
                }
                if (dlat < 0) {
                    bm |= 0x40;
                    dlat = -dlat;
                }
                os2.writeByte(bm);
                int blon = os2.writeVarLengthUnsigned(dlon);
                int blat = os2.writeVarLengthUnsigned(dlat);
                if (writedescbit != 0) {
                    if (writeVarLength) {
                        os2.writeByte(lastDescription.length);
                    }
                    os2.write(lastDescription);
                }
                if (nodedescbit != 0) {
                    if (writeVarLength) {
                        os2.writeByte(nodeDescription.length);
                    }
                    os2.write(nodeDescription);
                    nodeDescription = null;
                }
                link.descriptionBitmap = null;
                if (tranferbit == 0) continue block0;
                os2.writeVarLengthSigned(target2.getSElev() - this.getSElev());
                for (link = target2.getFirstLink(); link != null && link.getTarget(target2) == origin; link = link.getNext(target2)) {
                }
                if (link == null) {
                    throw new RuntimeException("follow-up link not found for transfer-node!");
                }
                origin = target2;
            }
        }
        int bodySize = os2.size();
        os.ensureCapacity(bodySize + 8);
        os.writeShort((short)(this.ilon - lonIdx * 62500 - 31250));
        os.writeShort((short)(this.ilat - latIdx * 62500 - 31250));
        os.writeVarLengthUnsigned(bodySize);
        os.write(abBuf, 0, bodySize);
    }

    public String toString2() {
        return this.ilon - 180000000 + "_" + (this.ilat - 90000000) + "_" + this.selev / 4;
    }

    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public boolean isTransferNode() {
        return !this.isBorder && this._linkCnt() == 2;
    }

    private int _linkCnt() {
        int cnt = 0;
        for (OsmLinkP link = this.getFirstLink(); link != null; link = link.getNext(this)) {
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int compareTo(OsmNodeP n) {
        long id2;
        long id1 = this.getIdFromPos();
        if (id1 < (id2 = n.getIdFromPos())) {
            return -1;
        }
        if (id1 > id2) {
            return 1;
        }
        return 0;
    }
}

