/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.DistanceChecker;
import btools.mapaccess.MicroCache;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.OsmPos;
import btools.mapaccess.OsmTransferNode;
import btools.util.ByteArrayUnifier;

public class OsmNode
implements OsmPos {
    public static final int EXTERNAL_BITMASK = 128;
    public static final int SIGNLON_BITMASK = 128;
    public static final int SIGNLAT_BITMASK = 64;
    public static final int TRANSFERNODE_BITMASK = 32;
    public static final int WRITEDESC_BITMASK = 16;
    public static final int SKIPDETAILS_BITMASK = 8;
    public static final int NODEDESC_BITMASK = 4;
    public static final int RESERVED1_BITMASK = 2;
    public static final int RESERVED2_BITMASK = 1;
    public int ilat;
    public int ilon;
    public short selev;
    public byte[] nodeDescription;
    public OsmLink firstlink = null;
    public OsmLink firstreverse = null;
    public boolean completed;
    public boolean wasProcessed;
    public int maxcost;

    public OsmNode() {
    }

    public OsmNode(int ilon, int ilat) {
        this.ilon = ilon;
        this.ilat = ilat;
    }

    public OsmNode(long id) {
        this.ilon = (int)(id >> 32);
        this.ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int getILat() {
        return this.ilat;
    }

    @Override
    public int getILon() {
        return this.ilon;
    }

    @Override
    public short getSElev() {
        return this.selev;
    }

    @Override
    public double getElev() {
        return (double)this.selev / 4.0;
    }

    public void addLink(OsmLink link) {
        if (this.firstlink != null) {
            link.next = this.firstlink;
        }
        this.firstlink = link;
    }

    @Override
    public int calcDistance(OsmPos p) {
        double l = (double)(this.ilat - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        double coslat = 1.0 - l2 + l4 / 6.0;
        double dlat = (double)(this.ilat - p.getILat()) / 1000000.0;
        double dlon = (double)(this.ilon - p.getILon()) / 1000000.0 * coslat;
        double d = Math.sqrt(dlat * dlat + dlon * dlon) * 111308.90052356021;
        return (int)(d + 1.0);
    }

    public void parseNodeBody(MicroCache is, OsmNodesMap hollowNodes, DistanceChecker dc, boolean readVarLength) {
        ByteArrayUnifier abUnifier = hollowNodes.getByteArrayUnifier();
        this.selev = is.readShort();
        OsmLink lastlink = null;
        int lonIdx = this.ilon / 62500;
        int latIdx = this.ilat / 62500;
        while (is.hasMoreData()) {
            int linklat;
            int linklon;
            int ilonref = this.ilon;
            int ilatref = this.ilat;
            OsmLink link = new OsmLink();
            OsmTransferNode firstTransferNode = null;
            OsmTransferNode lastTransferNode = null;
            byte[] description = null;
            while (true) {
                boolean isTransfer;
                byte bitField = is.readByte();
                if (readVarLength) {
                    int dlon = is.readVarLengthUnsigned();
                    int dlat = is.readVarLengthUnsigned();
                    if ((bitField & 0x80) != 0) {
                        dlon = -dlon;
                    }
                    if ((bitField & 0x40) != 0) {
                        dlat = -dlat;
                    }
                    linklon = ilonref + dlon;
                    linklat = ilatref + dlat;
                    ilonref = linklon;
                    ilatref = linklat;
                } else if ((bitField & 0x80) != 0) {
                    linklon = is.readInt();
                    linklat = is.readInt();
                } else {
                    linklon = is.readShort();
                    linklat = is.readShort();
                    linklon += lonIdx * 62500 + 31250;
                    linklat += latIdx * 62500 + 31250;
                }
                if ((bitField & 0x10) != 0) {
                    byte[] ab = new byte[readVarLength ? (int)is.readByte() : 8];
                    is.readFully(ab);
                    description = abUnifier.unify(ab);
                }
                if ((bitField & 4) != 0) {
                    byte[] ab = new byte[readVarLength ? (int)is.readByte() : 8];
                    is.readFully(ab);
                    this.nodeDescription = abUnifier.unify(ab);
                }
                if ((bitField & 2) != 0) {
                    byte[] ab = new byte[is.readByte()];
                    is.readFully(ab);
                }
                if ((bitField & 1) != 0) {
                    byte[] ab = new byte[is.readByte()];
                    is.readFully(ab);
                }
                if ((bitField & 8) != 0) {
                    link.counterLinkWritten = true;
                }
                if (description == null && !link.counterLinkWritten) {
                    throw new IllegalArgumentException("internal error: missing way description!");
                }
                boolean bl = isTransfer = (bitField & 0x20) != 0;
                if (!isTransfer) break;
                OsmTransferNode trans = new OsmTransferNode();
                trans.ilon = linklon;
                trans.ilat = linklat;
                trans.descriptionBitmap = description;
                short s = trans.selev = readVarLength ? (short)(this.selev + is.readVarLengthSigned()) : is.readShort();
                if (lastTransferNode == null) {
                    firstTransferNode = trans;
                } else {
                    lastTransferNode.next = trans;
                }
                lastTransferNode = trans;
            }
            link.descriptionBitmap = description;
            if (dc != null && !link.counterLinkWritten && !dc.isWithinRadius(this.ilon, this.ilat, firstTransferNode, linklon, linklat) || linklon == this.ilon && linklat == this.ilat) continue;
            if (lastlink == null) {
                this.firstlink = link;
            } else {
                lastlink.next = link;
            }
            lastlink = link;
            long targetNodeId = (long)linklon << 32 | (long)linklat;
            OsmNode tn = hollowNodes.get(targetNodeId);
            if (tn == null) {
                tn = new OsmNode(linklon, linklat);
                tn.setHollow();
                hollowNodes.put(targetNodeId, tn);
            } else if (!tn.isHollow() && !tn.hasHollowLinks()) {
                hollowNodes.registerCompletedNode(tn);
            }
            link.targetNode = tn;
            link.encodeFirsttransfer(firstTransferNode);
            if (link.counterLinkWritten) continue;
            OsmLink rlink = new OsmLink();
            byte[] linkDescriptionBitmap = link.descriptionBitmap;
            rlink.ilonOrigin = tn.ilon;
            rlink.ilatOrigin = tn.ilat;
            rlink.targetNode = this;
            rlink.descriptionBitmap = linkDescriptionBitmap;
            OsmTransferNode previous = null;
            OsmTransferNode rtrans = null;
            OsmTransferNode trans = firstTransferNode;
            while (trans != null) {
                if (previous == null) {
                    rlink.descriptionBitmap = trans.descriptionBitmap;
                } else {
                    previous.descriptionBitmap = trans.descriptionBitmap;
                }
                rtrans = new OsmTransferNode();
                rtrans.ilon = trans.ilon;
                rtrans.ilat = trans.ilat;
                rtrans.selev = trans.selev;
                rtrans.next = previous;
                rtrans.descriptionBitmap = linkDescriptionBitmap;
                previous = rtrans;
                trans = trans.next;
            }
            rlink.encodeFirsttransfer(rtrans);
            rlink.next = this.firstreverse;
            this.firstreverse = rlink;
        }
        if (!this.hasHollowLinks()) {
            hollowNodes.registerCompletedNode(this);
        }
    }

    public boolean isHollow() {
        return this.selev == -12345;
    }

    public void setHollow() {
        this.selev = (short)-12345;
    }

    @Override
    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public boolean hasHollowLinks() {
        OsmLink link = this.firstlink;
        while (link != null) {
            if (link.targetNode.isHollow()) {
                return true;
            }
            link = link.next;
        }
        return false;
    }

    public int linkCnt() {
        int cnt = 0;
        OsmLink link = this.firstlink;
        while (link != null) {
            ++cnt;
            link = link.next;
        }
        return cnt;
    }

    public void unlinkLink(OsmLink link) {
        if (link == this.firstlink) {
            this.firstlink = link.next;
            return;
        }
        OsmLink l = this.firstlink;
        while (l != null) {
            if (l.next == link) {
                l.next = link.next;
                return;
            }
            l = l.next;
        }
    }

    public OsmLink getReverseLink(int lon, int lat) {
        OsmLink rlink = this.firstreverse;
        while (rlink != null) {
            if (rlink.ilonOrigin == lon && rlink.ilatOrigin == lat) {
                this.unlinkRLink(rlink);
                return rlink;
            }
            rlink = rlink.next;
        }
        return null;
    }

    public void unlinkRLink(OsmLink rlink) {
        if (rlink == this.firstreverse) {
            this.firstreverse = rlink.next;
            return;
        }
        OsmLink l = this.firstreverse;
        while (l != null) {
            if (l.next == rlink) {
                l.next = rlink.next;
                return;
            }
            l = l.next;
        }
    }
}

