/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.DistanceChecker;
import btools.mapaccess.MicroCache;
import btools.mapaccess.OsmFile;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.PhysicalFile;
import btools.mapaccess.StorageConfigHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class NodesCache {
    private File segmentDir;
    private File secondarySegmentsDir = null;
    private OsmNodesMap nodesMap;
    private int lookupVersion;
    private int lookupMinorVersion;
    private boolean readVarLength;
    private boolean carMode;
    private boolean forceSecondaryData;
    private String currentFileName;
    private HashMap<String, PhysicalFile> fileCache;
    private byte[] iobuffer;
    private OsmFile[][] fileRows;
    private ArrayList<MicroCache> segmentList = new ArrayList();
    public DistanceChecker distanceChecker;
    public boolean oom_carsubset_hint = false;
    private long cacheSum = 0L;
    private boolean garbageCollectionEnabled = false;

    public NodesCache(String segmentDir, OsmNodesMap nodesMap, int lookupVersion, int minorVersion, boolean varLen, boolean carMode, boolean forceSecondaryData, NodesCache oldCache) {
        this.segmentDir = new File(segmentDir);
        this.nodesMap = nodesMap;
        this.lookupVersion = lookupVersion;
        this.lookupMinorVersion = minorVersion;
        this.readVarLength = varLen;
        this.carMode = carMode;
        this.forceSecondaryData = forceSecondaryData;
        if (!this.segmentDir.isDirectory()) {
            throw new RuntimeException("segment directory " + segmentDir + " does not exist");
        }
        if (oldCache != null) {
            this.fileCache = oldCache.fileCache;
            this.iobuffer = oldCache.iobuffer;
            this.oom_carsubset_hint = oldCache.oom_carsubset_hint;
            this.secondarySegmentsDir = oldCache.secondarySegmentsDir;
            for (OsmFile[] fileRow : this.fileRows = oldCache.fileRows) {
                if (fileRow == null) continue;
                for (OsmFile osmf : fileRow) {
                    this.cacheSum += osmf.setGhostState();
                }
            }
        } else {
            this.fileCache = new HashMap(4);
            this.fileRows = new OsmFile[180][];
            this.iobuffer = new byte[65636];
            this.secondarySegmentsDir = StorageConfigHelper.getSecondarySegmentDir(segmentDir);
        }
    }

    private File getFileFromSegmentDir(String filename) {
        File f2;
        if (this.forceSecondaryData) {
            return new File(this.secondarySegmentsDir, filename);
        }
        File f = new File(this.segmentDir, filename);
        if (this.secondarySegmentsDir != null && !f.exists() && (f2 = new File(this.secondarySegmentsDir, filename)).exists()) {
            return f2;
        }
        return f;
    }

    private void checkEnableCacheCleaning() {
        if (this.cacheSum < 200000L || this.garbageCollectionEnabled) {
            return;
        }
        for (int i = 0; i < this.fileRows.length; ++i) {
            OsmFile[] fileRow = this.fileRows[i];
            if (fileRow == null) continue;
            int nghosts = 0;
            for (OsmFile osmf : fileRow) {
                if (osmf.ghost) {
                    ++nghosts;
                    continue;
                }
                osmf.cleanAll();
            }
            if (nghosts == 0) continue;
            int j = 0;
            OsmFile[] frow = new OsmFile[fileRow.length - nghosts];
            for (OsmFile osmf : fileRow) {
                if (osmf.ghost) continue;
                frow[j++] = osmf;
            }
            this.fileRows[i] = frow;
        }
        this.garbageCollectionEnabled = true;
    }

    public int loadSegmentFor(int ilon, int ilat) {
        MicroCache mc = this.getSegmentFor(ilon, ilat);
        return mc == null ? 0 : mc.getSize();
    }

    public MicroCache getSegmentFor(int ilon, int ilat) {
        try {
            int lonIdx80 = ilon / 12500;
            int latIdx80 = ilat / 12500;
            int lonDegree = lonIdx80 / 80;
            int latDegree = latIdx80 / 80;
            OsmFile osmf = null;
            OsmFile[] fileRow = this.fileRows[latDegree];
            int ndegrees = fileRow == null ? 0 : fileRow.length;
            for (int i = 0; i < ndegrees; ++i) {
                if (fileRow[i].lonDegree != lonDegree) continue;
                osmf = fileRow[i];
                break;
            }
            if (osmf == null) {
                osmf = this.fileForSegment(lonDegree, latDegree);
                OsmFile[] newFileRow = new OsmFile[ndegrees + 1];
                for (int i = 0; i < ndegrees; ++i) {
                    newFileRow[i] = fileRow[i];
                }
                newFileRow[ndegrees] = osmf;
                this.fileRows[latDegree] = newFileRow;
            }
            osmf.ghost = false;
            this.currentFileName = osmf.filename;
            if (osmf.microCaches == null) {
                return null;
            }
            int subIdx = (latIdx80 - 80 * latDegree) * 80 + (lonIdx80 - 80 * lonDegree);
            MicroCache segment = osmf.microCaches[subIdx];
            if (segment == null) {
                this.checkEnableCacheCleaning();
                segment = new MicroCache(osmf, lonIdx80, latIdx80, this.iobuffer, this.readVarLength);
                this.cacheSum += (long)segment.getDataSize();
                osmf.microCaches[subIdx] = segment;
                this.segmentList.add(segment);
            } else if (segment.ghost) {
                segment.unGhost();
                this.segmentList.add(segment);
            }
            return segment;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("error reading datafile " + this.currentFileName + ": " + e);
        }
    }

    public boolean obtainNonHollowNode(OsmNode node) {
        if (!node.isHollow()) {
            return true;
        }
        MicroCache segment = this.getSegmentFor(node.ilon, node.ilat);
        if (segment == null) {
            return false;
        }
        segment.fillNode(node, this.nodesMap, this.distanceChecker, this.garbageCollectionEnabled);
        return !node.isHollow();
    }

    private OsmFile fileForSegment(int lonDegree, int latDegree) throws Exception {
        int lonMod5 = lonDegree % 5;
        int latMod5 = latDegree % 5;
        int tileIndex = lonMod5 * 5 + latMod5;
        int lon = lonDegree - 180 - lonMod5;
        String slon = lon < 0 ? "W" + -lon : "E" + lon;
        int lat = latDegree - 90 - latMod5;
        String slat = lat < 0 ? "S" + -lat : "N" + lat;
        String filenameBase = slon + "_" + slat;
        this.currentFileName = filenameBase + ".rd5/cd5";
        PhysicalFile ra = null;
        if (!this.fileCache.containsKey(filenameBase)) {
            File carFile;
            File f = null;
            if (this.carMode && (carFile = this.getFileFromSegmentDir("carsubset/" + filenameBase + ".cd5")).exists()) {
                f = carFile;
            }
            if (f == null) {
                File fullFile = this.getFileFromSegmentDir(filenameBase + ".rd5");
                if (fullFile.exists()) {
                    f = fullFile;
                }
                if (this.carMode && f != null) {
                    this.oom_carsubset_hint = true;
                }
            }
            if (f != null) {
                this.currentFileName = f.getName();
                ra = new PhysicalFile(f, this.iobuffer, this.lookupVersion, this.lookupMinorVersion);
            }
            this.fileCache.put(filenameBase, ra);
        }
        ra = this.fileCache.get(filenameBase);
        OsmFile osmf = new OsmFile(ra, tileIndex, this.iobuffer);
        osmf.lonDegree = lonDegree;
        osmf.latDegree = latDegree;
        return osmf;
    }

    public List<OsmNode> getAllNodes() {
        ArrayList<OsmNode> all = new ArrayList<OsmNode>();
        for (MicroCache segment : this.segmentList) {
            List<OsmNode> positions = segment.getPositions(this.nodesMap);
            all.addAll(positions);
        }
        return all;
    }

    public void close() {
        for (PhysicalFile f : this.fileCache.values()) {
            try {
                if (f == null) continue;
                f.ra.close();
            }
            catch (IOException iOException) {}
        }
    }
}

