/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.expressions.BExpressionContext;

final class BExpression {
    private static final int OR_EXP = 10;
    private static final int AND_EXP = 11;
    private static final int NOT_EXP = 12;
    private static final int ADD_EXP = 20;
    private static final int MULTIPLY_EXP = 21;
    private static final int MAX_EXP = 22;
    private static final int SWITCH_EXP = 30;
    private static final int ASSIGN_EXP = 31;
    private static final int LOOKUP_EXP = 32;
    private static final int NUMBER_EXP = 33;
    private static final int VARIABLE_EXP = 34;
    private static final int DUMPPOS_EXP = 40;
    private int typ;
    private BExpression op1;
    private BExpression op2;
    private BExpression op3;
    private float numberValue;
    private int variableIdx;
    private int lookupNameIdx;
    private int lookupValueIdx;

    BExpression() {
    }

    public static BExpression parse(BExpressionContext ctx, int level) throws Exception {
        String operator = ctx.parseToken();
        if (operator == null) {
            if (level == 0) {
                return null;
            }
            throw new IllegalArgumentException("unexpected end of file");
        }
        if (level == 0 && !"assign".equals(operator)) {
            throw new IllegalArgumentException("operator " + operator + " is invalid on toplevel (only 'assign' allowed)");
        }
        BExpression exp = new BExpression();
        int nops = 3;
        if ("switch".equals(operator)) {
            exp.typ = 30;
        } else {
            nops = 2;
            if ("or".equals(operator)) {
                exp.typ = 10;
            } else if ("and".equals(operator)) {
                exp.typ = 11;
            } else if ("multiply".equals(operator)) {
                exp.typ = 21;
            } else if ("add".equals(operator)) {
                exp.typ = 20;
            } else if ("max".equals(operator)) {
                exp.typ = 22;
            } else {
                nops = 1;
                if ("assign".equals(operator)) {
                    if (level > 0) {
                        throw new IllegalArgumentException("assign operator within expression");
                    }
                    exp.typ = 31;
                    String variable = ctx.parseToken();
                    if (variable == null) {
                        throw new IllegalArgumentException("unexpected end of file");
                    }
                    exp.variableIdx = ctx.getVariableIdx(variable, true);
                    if (exp.variableIdx < ctx.getMinWriteIdx()) {
                        throw new IllegalArgumentException("cannot assign to readonly variable " + variable);
                    }
                } else if ("not".equals(operator)) {
                    exp.typ = 12;
                } else if ("dumppos".equals(operator)) {
                    exp.typ = 40;
                } else {
                    nops = 0;
                    int idx = operator.indexOf(61);
                    if (idx >= 0) {
                        exp.typ = 32;
                        String name = operator.substring(0, idx);
                        String value = operator.substring(idx + 1);
                        exp.lookupNameIdx = ctx.getLookupNameIdx(name);
                        if (exp.lookupNameIdx < 0) {
                            throw new IllegalArgumentException("unknown lookup name: " + name);
                        }
                        exp.lookupValueIdx = ctx.getLookupValueIdx(exp.lookupNameIdx, value);
                        if (exp.lookupValueIdx < 0) {
                            throw new IllegalArgumentException("unknown lookup value: " + value);
                        }
                    } else {
                        idx = ctx.getVariableIdx(operator, false);
                        if (idx >= 0) {
                            exp.typ = 34;
                            exp.variableIdx = idx;
                        } else {
                            try {
                                exp.numberValue = Float.parseFloat(operator);
                                exp.typ = 33;
                            }
                            catch (NumberFormatException nfe) {
                                throw new IllegalArgumentException("unknown expression: " + operator);
                            }
                        }
                    }
                }
            }
        }
        if (nops > 0) {
            exp.op1 = BExpression.parse(ctx, level + 1);
        }
        if (nops > 1) {
            exp.op2 = BExpression.parse(ctx, level + 1);
        }
        if (nops > 2) {
            exp.op3 = BExpression.parse(ctx, level + 1);
        }
        return exp;
    }

    public float evaluate(BExpressionContext ctx) {
        switch (this.typ) {
            case 10: {
                return this.op1.evaluate(ctx) != 0.0f ? 1.0f : (this.op2.evaluate(ctx) != 0.0f ? 1.0f : 0.0f);
            }
            case 11: {
                return this.op1.evaluate(ctx) != 0.0f ? (this.op2.evaluate(ctx) != 0.0f ? 1.0f : 0.0f) : 0.0f;
            }
            case 20: {
                return this.op1.evaluate(ctx) + this.op2.evaluate(ctx);
            }
            case 21: {
                return this.op1.evaluate(ctx) * this.op2.evaluate(ctx);
            }
            case 22: {
                return this.max(this.op1.evaluate(ctx), this.op2.evaluate(ctx));
            }
            case 30: {
                return this.op1.evaluate(ctx) != 0.0f ? this.op2.evaluate(ctx) : this.op3.evaluate(ctx);
            }
            case 31: {
                return ctx.assign(this.variableIdx, this.op1.evaluate(ctx));
            }
            case 32: {
                return ctx.getLookupMatch(this.lookupNameIdx, this.lookupValueIdx);
            }
            case 33: {
                return this.numberValue;
            }
            case 34: {
                return ctx.getVariableValue(this.variableIdx);
            }
            case 12: {
                return this.op1.evaluate(ctx) == 0.0f ? 1.0f : 0.0f;
            }
            case 40: {
                ctx.expressionWarning("INFO");
                return this.op1.evaluate(ctx);
            }
        }
        throw new IllegalArgumentException("unknown op-code: " + this.typ);
    }

    private float max(float v1, float v2) {
        return v1 > v2 ? v1 : v2;
    }
}

