/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.Crc32;

public final class ByteArrayUnifier {
    private byte[][] byteArrayCache;
    private int[] crcCrosscheck;
    private int size;

    public ByteArrayUnifier(int size, boolean validateImmutability) {
        this.size = size;
        if (!Boolean.getBoolean("disableByteArrayUnifification")) {
            this.byteArrayCache = new byte[size][];
        }
        if (validateImmutability) {
            this.crcCrosscheck = new int[size];
        }
    }

    public byte[] unify(byte[] ab) {
        if (this.byteArrayCache == null) {
            return ab;
        }
        int n = ab.length;
        int crc = Crc32.crc(ab, 0, n);
        int idx = (crc & 0xFFFFFFF) % this.size;
        byte[] abc = this.byteArrayCache[idx];
        if (abc != null && abc.length == n) {
            int i;
            for (i = 0; i < n && ab[i] == abc[i]; ++i) {
            }
            if (i == n) {
                return abc;
            }
        }
        if (this.crcCrosscheck != null) {
            byte[] abold;
            int crcold;
            if (this.byteArrayCache[idx] != null && (crcold = Crc32.crc(abold = this.byteArrayCache[idx], 0, abold.length)) != this.crcCrosscheck[idx]) {
                throw new IllegalArgumentException("ByteArrayUnifier: immutablity validation failed!");
            }
            this.crcCrosscheck[idx] = crc;
        }
        this.byteArrayCache[idx] = ab;
        return ab;
    }
}

