/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

public final class BitCoderContext {
    private byte[] ab;
    private int idx = -1;
    private int bm = 256;
    private int b;

    public BitCoderContext(byte[] ab) {
        this.ab = ab;
    }

    public void encodeVarBits(int value) {
        int range = 0;
        while (value > range) {
            this.encodeBit(false);
            value -= range + 1;
            range = 2 * range + 1;
        }
        this.encodeBit(true);
        this.encode(range, value);
    }

    public int decodeVarBits() {
        int range = 0;
        int value = 0;
        while (!this.decodeBit()) {
            value += range + 1;
            range = 2 * range + 1;
        }
        return value + this.decode(range);
    }

    public void encodeBit(boolean value) {
        if (this.bm == 256) {
            this.bm = 1;
            this.ab[++this.idx] = 0;
        }
        if (value) {
            int n = this.idx;
            this.ab[n] = (byte)(this.ab[n] | this.bm);
        }
        this.bm <<= 1;
    }

    public boolean decodeBit() {
        if (this.bm == 256) {
            this.bm = 1;
            this.b = this.ab[++this.idx];
        }
        boolean value = (this.b & this.bm) != 0;
        this.bm <<= 1;
        return value;
    }

    public void encode(int max, int value) {
        int im = 1;
        while (max != 0) {
            if (this.bm == 256) {
                this.bm = 1;
                this.ab[++this.idx] = 0;
            }
            if ((value & im) != 0) {
                int n = this.idx;
                this.ab[n] = (byte)(this.ab[n] | this.bm);
            }
            max >>= 1;
            this.bm <<= 1;
            im <<= 1;
        }
    }

    public int getEncodedLength() {
        return this.idx + 1;
    }

    public int decode(int max) {
        int value = 0;
        int im = 1;
        while (max != 0) {
            if (this.bm == 256) {
                this.bm = 1;
                this.b = this.ab[++this.idx];
            }
            if ((this.b & this.bm) != 0) {
                value |= im;
            }
            max >>= 1;
            this.bm <<= 1;
            im <<= 1;
        }
        return value;
    }
}

