/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmLinkHolder;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmTransferNode;
import btools.router.OsmPathElement;
import btools.router.OsmTrack;
import btools.router.RoutingContext;

final class OsmPath
implements OsmLinkHolder {
    public OsmPath nextInSet;
    public OsmPath prevInSet;
    public OsmPath nextInIndexSet;
    public OsmPath prevInIndexSet;
    public int cost = 0;
    private int ehbd;
    private int ehbu;
    public short selev;
    public int adjustedCost = 0;
    private OsmNode sourcenode;
    private OsmLink link;
    public OsmPathElement originElement;
    private OsmLinkHolder nextForLink = null;
    public int treedepth = 0;
    public int originLon;
    public int originLat;
    public float lastCostfactor;
    public String message;

    public void setAirDistanceCostAdjustment(int costAdjustment) {
        this.adjustedCost = this.cost + costAdjustment;
    }

    OsmPath() {
    }

    OsmPath(OsmLink link) {
        this();
        this.link = link;
        this.selev = link.targetNode.getSElev();
    }

    OsmPath(OsmNode sourcenode, OsmPath origin, OsmLink link, OsmTrack refTrack, boolean recordTransferNodes, RoutingContext rc) {
        this();
        this.originElement = new OsmPathElement(origin);
        this.link = link;
        this.sourcenode = sourcenode;
        this.cost = origin.cost;
        this.ehbd = origin.ehbd;
        this.ehbu = origin.ehbu;
        this.lastCostfactor = origin.lastCostfactor;
        this.addAddionalPenalty(refTrack, recordTransferNodes, origin, link, rc);
    }

    private void addAddionalPenalty(OsmTrack refTrack, boolean recordTransferNodes, OsmPath origin, OsmLink link, RoutingContext rc) {
        short ele2;
        if (link.descriptionBitmap == null) {
            throw new IllegalArgumentException("null description for class: " + link.getClass());
        }
        rc.nogomatch = false;
        int lon0 = origin.originLon;
        int lat0 = origin.originLat;
        OsmNode p1 = origin.link.targetNode;
        int lon1 = p1.getILon();
        int lat1 = p1.getILat();
        short ele1 = origin.selev;
        int linkdisttotal = 0;
        int linkdist = 0;
        int linkelevationcost = 0;
        int linkturncost = 0;
        int linknodecost = 0;
        int linkinitcost = 0;
        OsmTransferNode transferNode = link.decodeFirsttransfer();
        OsmNode targetNode = link.targetNode;
        String lastMessage = null;
        while (true) {
            byte[] description;
            int lat2;
            int lon2;
            this.originLon = lon1;
            this.originLat = lat1;
            if (transferNode == null) {
                lon2 = targetNode.ilon;
                lat2 = targetNode.ilat;
                ele2 = targetNode.selev;
                description = link.descriptionBitmap;
                if (description == null) {
                    throw new IllegalArgumentException("null description for class: " + link.getClass());
                }
            } else {
                lon2 = transferNode.ilon;
                lat2 = transferNode.ilat;
                ele2 = transferNode.selev;
                description = transferNode.descriptionBitmap;
                if (description == null) {
                    throw new IllegalArgumentException("null description for class: " + transferNode.getClass() + "/" + link.getClass() + " counterlinkwritten=" + link.counterLinkWritten);
                }
            }
            rc.messageHandler.setCurrentPos(lon2, lat2);
            boolean sameData = rc.expctxWay.evaluate(link.counterLinkWritten, description, rc.messageHandler);
            if (lastMessage != null && !sameData) {
                this.originElement.message = lastMessage;
                linkdist = 0;
                linkelevationcost = 0;
                linkturncost = 0;
                linknodecost = 0;
                linkinitcost = 0;
            }
            int dist = rc.calcDistance(lon1, lat1, lon2, lat2);
            int elefactor = 250000;
            boolean stopAtEndpoint = false;
            if (rc.shortestmatch) {
                elefactor = (int)((double)elefactor * rc.wayfraction);
                if (rc.isEndpoint) {
                    stopAtEndpoint = true;
                } else {
                    this.cost = 0;
                    this.ehbd = 0;
                    this.ehbu = 0;
                    if (recordTransferNodes) {
                        this.originElement = rc.wayfraction > 0.0 ? new OsmPathElement(rc.ilonshortest, rc.ilatshortest, ele2, null) : null;
                    }
                }
            }
            linkdist += dist;
            linkdisttotal += dist;
            if (origin.originElement != null) {
                double cos = rc.calcCosAngle(lon0, lat0, lon1, lat1, lon2, lat2);
                int turncost = (int)(cos * (double)rc.expctxWay.getTurncost() + 0.2);
                this.cost += turncost;
                linkturncost += turncost;
            }
            if (ele2 == Short.MIN_VALUE) {
                ele2 = ele1;
            }
            if (ele1 != Short.MIN_VALUE) {
                this.ehbd += (ele1 - ele2) * elefactor - dist * rc.downhillcutoff;
                this.ehbu += (ele2 - ele1) * elefactor - dist * rc.uphillcutoff;
            }
            float downweight = 0.0f;
            if (this.ehbd > rc.elevationpenaltybuffer) {
                downweight = 1.0f;
                int reduce = dist * rc.elevationbufferreduce;
                int excess = this.ehbd - rc.elevationpenaltybuffer;
                if (reduce > excess) {
                    downweight = (float)excess / (float)reduce;
                    reduce = excess;
                }
                if (reduce < (excess = this.ehbd - rc.elevationmaxbuffer)) {
                    reduce = excess;
                }
                this.ehbd -= reduce;
                if (rc.downhillcostdiv > 0) {
                    int elevationCost = reduce / rc.downhillcostdiv;
                    this.cost += elevationCost;
                    linkelevationcost += elevationCost;
                }
            } else if (this.ehbd < 0) {
                this.ehbd = 0;
            }
            float upweight = 0.0f;
            if (this.ehbu > rc.elevationpenaltybuffer) {
                upweight = 1.0f;
                int reduce = dist * rc.elevationbufferreduce;
                int excess = this.ehbu - rc.elevationpenaltybuffer;
                if (reduce > excess) {
                    upweight = (float)excess / (float)reduce;
                    reduce = excess;
                }
                if (reduce < (excess = this.ehbu - rc.elevationmaxbuffer)) {
                    reduce = excess;
                }
                this.ehbu -= reduce;
                if (rc.uphillcostdiv > 0) {
                    int elevationCost = reduce / rc.uphillcostdiv;
                    this.cost += elevationCost;
                    linkelevationcost += elevationCost;
                }
            } else if (this.ehbu < 0) {
                this.ehbu = 0;
            }
            float cfup = rc.expctxWay.getUphillCostfactor();
            float cfdown = rc.expctxWay.getDownhillCostfactor();
            float cf = rc.expctxWay.getCostfactor();
            cfup = cfup == 0.0f ? cf : cfup;
            cfdown = cfdown == 0.0f ? cf : cfdown;
            float costfactor = cfup * upweight + cf * (1.0f - upweight - downweight) + cfdown * downweight;
            float fcost = (float)dist * costfactor + 0.5f;
            if ((double)costfactor > 9999.0 || (double)(fcost + (float)this.cost) >= 2.0E9) {
                this.cost = -1;
                return;
            }
            int waycost = (int)fcost;
            this.cost += waycost;
            float newcostfactor = (cfup + cfdown + cf) / 3.0f;
            float costdiff = newcostfactor - this.lastCostfactor;
            if ((double)costdiff > 5.0E-4 || (double)costdiff < -5.0E-4) {
                this.lastCostfactor = newcostfactor;
                float initialcost = rc.expctxWay.getInitialcost();
                int iicost = (int)initialcost;
                linkinitcost += iicost;
                this.cost += iicost;
            }
            if (recordTransferNodes) {
                int iCost = (int)(costfactor * 1000.0f + 0.5f);
                lastMessage = lon2 - 180000000 + "\t" + (lat2 - 90000000) + "\t" + ele2 / 4 + "\t" + linkdist + "\t" + iCost + "\t" + linkelevationcost + "\t" + linkturncost + "\t" + linknodecost + "\t" + linkinitcost + rc.expctxWay.getKeyValueDescription(link.counterLinkWritten, description);
            }
            if (stopAtEndpoint) {
                if (recordTransferNodes) {
                    this.originElement = new OsmPathElement(rc.ilonshortest, rc.ilatshortest, ele2, this.originElement);
                    this.originElement.cost = this.cost;
                    this.originElement.message = lastMessage;
                }
                if (rc.nogomatch) {
                    this.cost = -1;
                }
                return;
            }
            if (transferNode == null) {
                if (refTrack != null && refTrack.containsNode(targetNode) && refTrack.containsNode(origin.link.targetNode)) {
                    int reftrackcost = linkdisttotal;
                    this.cost += reftrackcost;
                }
                break;
            }
            transferNode = transferNode.next;
            if (recordTransferNodes) {
                this.originElement = new OsmPathElement(lon2, lat2, ele2, this.originElement);
                this.originElement.cost = this.cost;
            }
            lon0 = lon1;
            lat0 = lat1;
            lon1 = lon2;
            lat1 = lat2;
            ele1 = ele2;
        }
        this.message = lastMessage;
        this.selev = ele2;
        if (rc.nogomatch) {
            this.cost = -1;
            return;
        }
        if (targetNode.nodeDescription != null) {
            rc.messageHandler.setCurrentPos(targetNode.ilon, targetNode.ilat);
            rc.expctxNode.evaluate((double)rc.expctxWay.getNodeAccessGranted() != 0.0, targetNode.nodeDescription, rc.messageHandler);
            float initialcost = rc.expctxNode.getInitialcost();
            if ((double)initialcost >= 1000000.0) {
                this.cost = -1;
                return;
            }
            int iicost = (int)initialcost;
            linknodecost += iicost;
            this.cost += iicost;
        }
    }

    public int elevationCorrection(RoutingContext rc) {
        return (rc.downhillcostdiv > 0 ? this.ehbd / rc.downhillcostdiv : 0) + (rc.uphillcostdiv > 0 ? this.ehbu / rc.uphillcostdiv : 0);
    }

    public boolean definitlyWorseThan(OsmPath p, RoutingContext rc) {
        int delta;
        int c = p.cost;
        if (rc.downhillcostdiv > 0 && (delta = p.ehbd - this.ehbd) > 0) {
            c += delta / rc.downhillcostdiv;
        }
        if (rc.uphillcostdiv > 0 && (delta = p.ehbu - this.ehbu) > 0) {
            c += delta / rc.uphillcostdiv;
        }
        return this.cost > c;
    }

    public OsmNode getSourceNode() {
        return this.sourcenode;
    }

    public OsmLink getLink() {
        return this.link;
    }

    @Override
    public void setNextForLink(OsmLinkHolder holder) {
        this.nextForLink = holder;
    }

    @Override
    public OsmLinkHolder getNextForLink() {
        return this.nextForLink;
    }
}

