/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.DistanceChecker;
import btools.mapaccess.OsmFile;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodesMap;
import btools.util.ByteDataReader;
import btools.util.Crc32;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class MicroCache
extends ByteDataReader {
    private long[] faid;
    private int[] fapos;
    private int size = 0;
    private int delcount = 0;
    private int delbytes = 0;
    private int p2size;
    private boolean readVarLength;
    private int aboffsetEnd;
    boolean virgin = true;
    boolean ghost = false;

    public MicroCache(OsmFile segfile, int lonIdx80, int latIdx80, byte[] iobuffer, boolean readVarLength) throws Exception {
        super(null);
        int crc;
        this.readVarLength = readVarLength;
        int lonDegree = lonIdx80 / 80;
        int latDegree = latIdx80 / 80;
        int lonIdxBase = lonIdx80 / 5 * 62500 + 31250;
        int latIdxBase = latIdx80 / 5 * 62500 + 31250;
        int subIdx = (latIdx80 - 80 * latDegree) * 80 + (lonIdx80 - 80 * lonDegree);
        this.ab = iobuffer;
        int asize = segfile.getDataInputForSubIdx(subIdx, this.ab);
        if (asize == 0) {
            this.ab = null;
            return;
        }
        if (asize > iobuffer.length) {
            this.ab = new byte[asize];
            asize = segfile.getDataInputForSubIdx(subIdx, this.ab);
        }
        this.aboffset = 0;
        this.size = this.readInt();
        int nbytes = 0;
        for (int i = 0; i < this.size; ++i) {
            int bodySize;
            short ilon = this.readShort();
            short ilat = this.readShort();
            int n = bodySize = readVarLength ? this.readVarLengthUnsigned() : this.readInt();
            if (!readVarLength && ilon == Short.MAX_VALUE && ilat == Short.MAX_VALUE) {
                int crc2 = Crc32.crc(this.ab, 0, this.aboffset - 8);
                if (crc2 != this.readInt()) {
                    throw new IOException("checkum-error");
                }
                this.size = i;
                break;
            }
            this.aboffset += bodySize;
            nbytes += bodySize;
        }
        if (readVarLength && (crc = Crc32.crc(this.ab, 0, this.aboffset)) != this.readInt()) {
            throw new IOException("checkum error");
        }
        byte[] nab = new byte[nbytes];
        this.aboffset = 4;
        int noffset = 0;
        this.faid = new long[this.size];
        this.fapos = new int[this.size];
        this.p2size = 0x40000000;
        while (this.p2size > this.size) {
            this.p2size >>= 1;
        }
        for (int i = 0; i < this.size; ++i) {
            long nodeId;
            int ilon = this.readShort();
            int ilat = this.readShort();
            this.faid[i] = nodeId = (long)(ilon += lonIdxBase) << 32 | (long)(ilat += latIdxBase);
            int bodySize = readVarLength ? this.readVarLengthUnsigned() : this.readInt();
            this.fapos[i] = noffset;
            System.arraycopy(this.ab, this.aboffset, nab, noffset, bodySize);
            this.aboffset += bodySize;
            noffset += bodySize;
        }
        this.ab = nab;
    }

    public int getSize() {
        return this.size;
    }

    public int getDataSize() {
        return this.ab == null ? 0 : this.ab.length;
    }

    private boolean getAndClear(long id) {
        if (this.size == 0) {
            return false;
        }
        long[] a = this.faid;
        int n = 0;
        for (int offset = this.p2size; offset > 0; offset >>= 1) {
            int nn = n + offset;
            if (nn >= this.size || a[nn] > id) continue;
            n = nn;
        }
        if (a[n] == id) {
            if ((this.fapos[n] & Integer.MIN_VALUE) == 0) {
                this.aboffset = this.fapos[n];
                int ablength = (n + 1 < this.size ? this.fapos[n + 1] & Integer.MAX_VALUE : this.ab.length) - this.aboffset;
                this.aboffsetEnd = this.aboffset + ablength;
                int n2 = n;
                this.fapos[n2] = this.fapos[n2] | Integer.MIN_VALUE;
                this.delbytes += ablength;
                ++this.delcount;
                return true;
            }
            throw new RuntimeException("MicroCache: node already consumed: id=" + id);
        }
        return false;
    }

    public void fillNode(OsmNode node, OsmNodesMap nodesMap, DistanceChecker dc, boolean doCollect) {
        long id = node.getIdFromPos();
        if (this.getAndClear(id)) {
            node.parseNodeBody(this, nodesMap, dc, this.readVarLength);
        }
        if (doCollect && this.delcount > this.size / 2) {
            this.collect();
        }
    }

    void collect() {
        if (this.delcount > 0) {
            this.virgin = false;
            int nsize = this.size - this.delcount;
            if (nsize == 0) {
                this.faid = null;
                this.fapos = null;
            } else {
                long[] nfaid = new long[nsize];
                int[] nfapos = new int[nsize];
                int idx = 0;
                byte[] nab = new byte[this.ab.length - this.delbytes];
                int nab_off = 0;
                for (int i = 0; i < this.size; ++i) {
                    int pos = this.fapos[i];
                    if ((pos & Integer.MIN_VALUE) != 0) continue;
                    int ablength = (i + 1 < this.size ? this.fapos[i + 1] & Integer.MAX_VALUE : this.ab.length) - pos;
                    System.arraycopy(this.ab, pos, nab, nab_off, ablength);
                    nfaid[idx] = this.faid[i];
                    nfapos[idx] = nab_off;
                    nab_off += ablength;
                    ++idx;
                }
                this.faid = nfaid;
                this.fapos = nfapos;
                this.ab = nab;
            }
            this.size = nsize;
            this.delcount = 0;
            this.delbytes = 0;
            this.p2size = 0x40000000;
            while (this.p2size > this.size) {
                this.p2size >>= 1;
            }
        }
    }

    void unGhost() {
        this.ghost = false;
        this.delcount = 0;
        this.delbytes = 0;
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.fapos[n] = this.fapos[n] & Integer.MAX_VALUE;
        }
    }

    public List<OsmNode> getPositions(OsmNodesMap nodesMap) {
        ArrayList<OsmNode> positions = new ArrayList<OsmNode>();
        for (int i = 0; i < this.size; ++i) {
            OsmNode n = new OsmNode(this.faid[i]);
            n.setHollow();
            nodesMap.put(this.faid[i], n);
            positions.add(n);
        }
        return positions;
    }

    public boolean hasMoreData() {
        return this.aboffset < this.aboffsetEnd;
    }
}

