/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.expressions.BExpression;
import btools.expressions.BExpressionLookupValue;
import btools.expressions.BExpressionMetaData;
import btools.expressions.BExpressionReceiver;
import btools.util.BitCoderContext;
import btools.util.Crc32;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public final class BExpressionContext {
    private static final String CONTEXT_TAG = "---context:";
    private String context;
    private boolean _inOurContext = false;
    private BufferedReader _br = null;
    private boolean _readerDone = false;
    private BExpressionReceiver _receiver;
    private Map<String, Integer> lookupNumbers = new HashMap<String, Integer>();
    private ArrayList<BExpressionLookupValue[]> lookupValues = new ArrayList();
    private ArrayList<String> lookupNames = new ArrayList();
    private ArrayList<int[]> lookupHistograms = new ArrayList();
    private boolean lookupDataFrozen = false;
    private int[] lookupData = new int[0];
    private byte[] abBuf = new byte[256];
    private Map<String, Integer> variableNumbers = new HashMap<String, Integer>();
    private float[] variableData;
    private byte[][] _arrayBitmap;
    private int currentHashBucket = -1;
    private byte[] currentByteArray = null;
    public List<BExpression> expressionList;
    private int minWriteIdx;
    private int costfactorIdx;
    private int turncostIdx;
    private int uphillcostfactorIdx;
    private int downhillcostfactorIdx;
    private int initialcostIdx;
    private int nodeaccessgrantedIdx;
    private float[] _arrayCostfactor;
    private float[] _arrayTurncost;
    private float[] _arrayUphillCostfactor;
    private float[] _arrayDownhillCostfactor;
    private float[] _arrayInitialcost;
    private float[] _arrayNodeAccessGranted;
    private int linenr;
    public BExpressionMetaData meta;
    private boolean lookupDataValid = false;
    private int parsedLines = 0;
    private boolean fixTagsWritten = false;

    public float getCostfactor() {
        return this._arrayCostfactor[this.currentHashBucket];
    }

    public float getTurncost() {
        return this._arrayTurncost[this.currentHashBucket];
    }

    public float getUphillCostfactor() {
        return this._arrayUphillCostfactor[this.currentHashBucket];
    }

    public float getDownhillCostfactor() {
        return this._arrayDownhillCostfactor[this.currentHashBucket];
    }

    public float getInitialcost() {
        return this._arrayInitialcost[this.currentHashBucket];
    }

    public float getNodeAccessGranted() {
        return this._arrayNodeAccessGranted[this.currentHashBucket];
    }

    public BExpressionContext(String context, BExpressionMetaData meta) {
        this(context, 4096, meta);
    }

    public BExpressionContext(String context, int hashSize, BExpressionMetaData meta) {
        this.context = context;
        this.meta = meta;
        if (meta != null) {
            meta.registerListener(context, this);
        }
        if (Boolean.getBoolean("disableExpressionCache")) {
            hashSize = 1;
        }
        this._arrayBitmap = new byte[hashSize][];
        this._arrayCostfactor = new float[hashSize];
        this._arrayTurncost = new float[hashSize];
        this._arrayUphillCostfactor = new float[hashSize];
        this._arrayDownhillCostfactor = new float[hashSize];
        this._arrayInitialcost = new float[hashSize];
        this._arrayNodeAccessGranted = new float[hashSize];
    }

    public byte[] encode() {
        if (!this.lookupDataValid) {
            throw new IllegalArgumentException("internal error: encoding undefined data?");
        }
        return this.encode(this.lookupData);
    }

    public byte[] encode(int[] ld) {
        if (!this.meta.readVarLength) {
            return this.encodeFix(ld);
        }
        BitCoderContext ctx = new BitCoderContext(this.abBuf);
        ctx.encodeBit(ld[0] != 0);
        int skippedTags = 0;
        int nonNullTags = 0;
        for (int inum = 1; inum < this.lookupValues.size(); ++inum) {
            int d = ld[inum];
            if (d == 0) {
                ++skippedTags;
                continue;
            }
            ctx.encodeVarBits(skippedTags + 1);
            ++nonNullTags;
            skippedTags = 0;
            int dd = d < 2 ? 7 : (d < 9 ? d - 2 : d - 1);
            ctx.encodeVarBits(dd);
        }
        ctx.encodeVarBits(0);
        if (nonNullTags == 0) {
            return null;
        }
        int len = ctx.getEncodedLength();
        byte[] ab = new byte[len];
        System.arraycopy(this.abBuf, 0, ab, 0, len);
        int[] ld2 = new int[this.lookupValues.size()];
        this.decode(ld2, ab);
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            if (ld2[inum] == ld[inum]) continue;
            throw new RuntimeException("assertion failed encoding " + this.getKeyValueDescription(ab));
        }
        return ab;
    }

    public byte[] encodeFix(int[] ld) {
        long w = 0L;
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            int n = this.lookupValues.get(inum).length - 1;
            int d = ld[inum];
            if (n == 2) {
                n = 1;
                int n2 = d = d == 2 ? 1 : 0;
            }
            while (n != 0) {
                n >>= 1;
                w <<= 1;
            }
            w |= (long)d;
        }
        if (w == 0L) {
            return null;
        }
        byte[] ab = new byte[8];
        int aboffset = 0;
        ab[aboffset++] = (byte)(w >> 56 & 0xFFL);
        ab[aboffset++] = (byte)(w >> 48 & 0xFFL);
        ab[aboffset++] = (byte)(w >> 40 & 0xFFL);
        ab[aboffset++] = (byte)(w >> 32 & 0xFFL);
        ab[aboffset++] = (byte)(w >> 24 & 0xFFL);
        ab[aboffset++] = (byte)(w >> 16 & 0xFFL);
        ab[aboffset++] = (byte)(w >> 8 & 0xFFL);
        ab[aboffset++] = (byte)(w & 0xFFL);
        return ab;
    }

    public void decode(byte[] ab) {
        this.decode(this.lookupData, ab);
        this.lookupDataValid = true;
    }

    public void decode(int[] ld, byte[] ab) {
        int delta;
        if (!this.meta.readVarLength) {
            this.decodeFix(ld, ab);
            return;
        }
        BitCoderContext ctx = new BitCoderContext(ab);
        ld[0] = ctx.decodeBit() ? 2 : 0;
        int inum = 1;
        while ((delta = ctx.decodeVarBits()) != 0 && inum + delta <= ld.length) {
            int d;
            while (delta-- > 1) {
                ld[inum++] = 0;
            }
            int dd = ctx.decodeVarBits();
            int n = dd == 7 ? 1 : (d = dd < 7 ? dd + 2 : dd + 1);
            if (d >= this.lookupValues.get(inum).length) {
                d = 1;
            }
            ld[inum++] = d;
        }
        while (inum < ld.length) {
            ld[inum++] = 0;
        }
    }

    public void decodeFix(int[] ld, byte[] ab) {
        int idx = 0;
        long i7 = ab[idx++] & 0xFF;
        long i6 = ab[idx++] & 0xFF;
        long i5 = ab[idx++] & 0xFF;
        long i4 = ab[idx++] & 0xFF;
        long i3 = ab[idx++] & 0xFF;
        long i2 = ab[idx++] & 0xFF;
        long i1 = ab[idx++] & 0xFF;
        long i0 = ab[idx++] & 0xFF;
        long w = (i7 << 56) + (i6 << 48) + (i5 << 40) + (i4 << 32) + (i3 << 24) + (i2 << 16) + (i1 << 8) + i0;
        for (int inum = this.lookupValues.size() - 1; inum >= 0; --inum) {
            int nv = this.lookupValues.get(inum).length;
            int n = nv == 3 ? 1 : nv - 1;
            int m = 0;
            long ww = w;
            while (n != 0) {
                n >>= 1;
                ww >>= 1;
                m = m << 1 | 1;
            }
            int d = (int)(w & (long)m);
            if (nv == 3 && d == 1) {
                d = 2;
            }
            ld[inum] = d;
            w = ww;
        }
    }

    public String getCsvDescription(boolean inverseDirection, byte[] ab) {
        int inverseBitByteIndex = this.meta.readVarLength ? 0 : 7;
        int abLen = ab.length;
        byte[] ab_copy = new byte[abLen];
        System.arraycopy(ab, 0, ab_copy, 0, abLen);
        if (inverseDirection) {
            int n = inverseBitByteIndex;
            ab_copy[n] = (byte)(ab_copy[n] ^ 1);
        }
        StringBuilder sb = new StringBuilder(200);
        this.decode(this.lookupData, ab_copy);
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            int idx = this.meta.readVarLength ? (inum + 1) % this.lookupValues.size() : inum;
            BExpressionLookupValue[] va = this.lookupValues.get(idx);
            sb.append('\t').append(va[this.lookupData[idx]].toString());
        }
        return sb.toString();
    }

    public String getCsvHeader() {
        StringBuilder sb = new StringBuilder(200);
        for (int inum = 0; inum < this.lookupNames.size(); ++inum) {
            int idx = this.meta.readVarLength ? (inum + 1) % this.lookupValues.size() : inum;
            sb.append('\t').append(this.lookupNames.get(idx));
        }
        return sb.toString();
    }

    public String getKeyValueDescription(byte[] ab) {
        StringBuilder sb = new StringBuilder(200);
        this.decode(this.lookupData, ab);
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            BExpressionLookupValue[] va = this.lookupValues.get(inum);
            String value = va[this.lookupData[inum]].toString();
            if (value == null || value.length() <= 0) continue;
            sb.append(" " + this.lookupNames.get(inum) + "=" + value);
        }
        return sb.toString();
    }

    public void parseMetaLine(String line) {
        ++this.parsedLines;
        StringTokenizer tk = new StringTokenizer(line, " ");
        String name = tk.nextToken();
        String value = tk.nextToken();
        int idx = name.indexOf(59);
        if (idx >= 0) {
            name = name.substring(0, idx);
        }
        if (this.meta.readVarLength) {
            if (!this.fixTagsWritten) {
                this.fixTagsWritten = true;
                if ("way".equals(this.context)) {
                    this.addLookupValue("reversedirection", "yes", null);
                } else if ("node".equals(this.context)) {
                    this.addLookupValue("nodeaccessgranted", "yes", null);
                }
            }
            if ("reversedirection".equals(name)) {
                return;
            }
            if ("nodeaccessgranted".equals(name)) {
                return;
            }
        }
        BExpressionLookupValue newValue = this.addLookupValue(name, value, null);
        while (newValue != null && tk.hasMoreTokens()) {
            newValue.addAlias(tk.nextToken());
        }
    }

    public void finishMetaParsing() {
        if (this.parsedLines == 0 && !"global".equals(this.context)) {
            throw new IllegalArgumentException("lookup table does not contain data for context " + this.context + " (old version?)");
        }
        this.lookupDataFrozen = true;
    }

    public void evaluate(int[] lookupData2) {
        this.lookupData = lookupData2;
        for (BExpression exp : this.expressionList) {
            exp.evaluate(this);
        }
    }

    public boolean evaluate(boolean inverseDirection, byte[] ab, BExpressionReceiver receiver) {
        boolean equalsCurrent;
        this.lookupDataValid = false;
        int inverseBitByteIndex = this.meta.readVarLength ? 0 : 7;
        int abLen = ab.length;
        boolean bl = equalsCurrent = this.currentHashBucket >= 0 && abLen == this.currentByteArray.length;
        if (equalsCurrent) {
            for (int i = 0; i < abLen; ++i) {
                byte b = ab[i];
                if (i == inverseBitByteIndex && inverseDirection) {
                    b = (byte)(b ^ 1);
                }
                if (b == this.currentByteArray[i]) continue;
                equalsCurrent = false;
                break;
            }
        }
        if (equalsCurrent) {
            return true;
        }
        int crc = Crc32.crc(this.abBuf, 0, abLen);
        int hashSize = this._arrayBitmap.length;
        this.currentHashBucket = (crc & 0xFFFFFFF) % hashSize;
        this.currentByteArray = new byte[abLen];
        System.arraycopy(ab, 0, this.currentByteArray, 0, abLen);
        if (inverseDirection) {
            int n = inverseBitByteIndex;
            this.currentByteArray[n] = (byte)(this.currentByteArray[n] ^ 1);
        }
        boolean hashBucketEquals = false;
        byte[] abBucket = this._arrayBitmap[this.currentHashBucket];
        if (abBucket != null && abBucket.length == abLen) {
            hashBucketEquals = true;
            for (int i = 0; i < abLen; ++i) {
                if (abBucket[i] == this.currentByteArray[i]) continue;
                hashBucketEquals = false;
                break;
            }
        }
        if (hashBucketEquals) {
            return false;
        }
        this._arrayBitmap[this.currentHashBucket] = this.currentByteArray;
        this._receiver = receiver;
        this.decode(this.lookupData, this.currentByteArray);
        this.evaluate(this.lookupData);
        this._arrayCostfactor[this.currentHashBucket] = this.variableData[this.costfactorIdx];
        this._arrayTurncost[this.currentHashBucket] = this.variableData[this.turncostIdx];
        this._arrayUphillCostfactor[this.currentHashBucket] = this.variableData[this.uphillcostfactorIdx];
        this._arrayDownhillCostfactor[this.currentHashBucket] = this.variableData[this.downhillcostfactorIdx];
        this._arrayInitialcost[this.currentHashBucket] = this.variableData[this.initialcostIdx];
        this._arrayNodeAccessGranted[this.currentHashBucket] = this.variableData[this.nodeaccessgrantedIdx];
        this._receiver = null;
        return false;
    }

    public void dumpStatistics() {
        int[] histo;
        TreeMap<String, String> counts = new TreeMap<String, String>();
        for (String name : this.lookupNumbers.keySet()) {
            int cnt = 0;
            int inum = this.lookupNumbers.get(name);
            histo = this.lookupHistograms.get(inum);
            for (int i = 2; i < histo.length; ++i) {
                cnt += histo[i];
            }
            counts.put("" + (1000000000 + cnt) + "_" + name, name);
        }
        while (counts.size() > 0) {
            int i;
            String name;
            String key = (String)counts.lastEntry().getKey();
            name = (String)counts.get(key);
            counts.remove(key);
            int inum = this.lookupNumbers.get(name);
            BExpressionLookupValue[] values = this.lookupValues.get(inum);
            histo = this.lookupHistograms.get(inum);
            if (values.length == 1000) continue;
            Object[] svalues = new String[values.length];
            for (i = 0; i < values.length; ++i) {
                String scnt = "0000000000" + histo[i];
                scnt = scnt.substring(scnt.length() - 10);
                svalues[i] = scnt + " " + values[i].toString();
            }
            Arrays.sort(svalues);
            for (i = svalues.length - 1; i >= 0; --i) {
                System.out.println(name + ";" + (String)svalues[i]);
            }
        }
    }

    public int[] createNewLookupData() {
        if (this.lookupDataFrozen) {
            return new int[this.lookupValues.size()];
        }
        return null;
    }

    public BExpressionLookupValue addLookupValue(String name, String value, int[] lookupData2) {
        BExpressionLookupValue v;
        int i;
        BExpressionLookupValue newValue = null;
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            if (lookupData2 != null) {
                return newValue;
            }
            num = new Integer(this.lookupValues.size());
            this.lookupNumbers.put(name, num);
            this.lookupNames.add(name);
            this.lookupValues.add(new BExpressionLookupValue[]{new BExpressionLookupValue(""), new BExpressionLookupValue("unknown")});
            this.lookupHistograms.add(new int[2]);
            int[] ndata = new int[this.lookupData.length + 1];
            System.arraycopy(this.lookupData, 0, ndata, 0, this.lookupData.length);
            this.lookupData = ndata;
        }
        int inum = num;
        BExpressionLookupValue[] values = this.lookupValues.get(inum);
        int[] histo = this.lookupHistograms.get(inum);
        for (i = 0; i < values.length && !(v = values[i]).matches(value); ++i) {
        }
        if (i == values.length) {
            if (lookupData2 != null) {
                lookupData2[inum] = 1;
                return newValue;
            }
            if (i == 499) {
                // empty if block
            }
            if (i == 500) {
                return newValue;
            }
            BExpressionLookupValue[] nvalues = new BExpressionLookupValue[values.length + 1];
            int[] nhisto = new int[values.length + 1];
            System.arraycopy(values, 0, nvalues, 0, values.length);
            System.arraycopy(histo, 0, nhisto, 0, histo.length);
            values = nvalues;
            histo = nhisto;
            values[i] = newValue = new BExpressionLookupValue(value);
            this.lookupHistograms.set(inum, histo);
            this.lookupValues.set(inum, values);
        }
        int n = i;
        histo[n] = histo[n] + 1;
        if (lookupData2 != null) {
            lookupData2[inum] = i;
        } else {
            this.lookupData[inum] = i;
        }
        return newValue;
    }

    public void addLookupValue(String name, int valueIndex) {
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            return;
        }
        int inum = num;
        int nvalues = this.lookupValues.get(inum).length;
        if (valueIndex < 0 || valueIndex >= nvalues) {
            throw new IllegalArgumentException("value index out of range for name " + name + ": " + valueIndex);
        }
        this.lookupData[inum] = valueIndex;
    }

    public boolean getBooleanLookupValue(String name) {
        Integer num = this.lookupNumbers.get(name);
        return num != null && this.lookupData[num] == 2;
    }

    public void parseFile(File file, String readOnlyContext) {
        try {
            if (readOnlyContext != null) {
                this.linenr = 1;
                String realContext = this.context;
                this.context = readOnlyContext;
                this.expressionList = this._parseFile(file);
                this.variableData = new float[this.variableNumbers.size()];
                this.evaluate(this.lookupData);
                this.context = realContext;
            }
            this.linenr = 1;
            this.minWriteIdx = this.variableData == null ? 0 : this.variableData.length;
            this.costfactorIdx = this.getVariableIdx("costfactor", true);
            this.turncostIdx = this.getVariableIdx("turncost", true);
            this.uphillcostfactorIdx = this.getVariableIdx("uphillcostfactor", true);
            this.downhillcostfactorIdx = this.getVariableIdx("downhillcostfactor", true);
            this.initialcostIdx = this.getVariableIdx("initialcost", true);
            this.nodeaccessgrantedIdx = this.getVariableIdx("nodeaccessgranted", true);
            this.expressionList = this._parseFile(file);
            float[] readOnlyData = this.variableData;
            this.variableData = new float[this.variableNumbers.size()];
            for (int i = 0; i < this.minWriteIdx; ++i) {
                this.variableData[i] = readOnlyData[i];
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalArgumentException("ParseException at line " + this.linenr + ": " + e.getMessage());
            }
            throw new RuntimeException(e);
        }
        if (this.expressionList.size() == 0) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " does not contain expressions for context " + this.context + " (old version?)");
        }
    }

    private List<BExpression> _parseFile(File file) throws Exception {
        BExpression exp;
        this._br = new BufferedReader(new FileReader(file));
        this._readerDone = false;
        ArrayList<BExpression> result = new ArrayList<BExpression>();
        while ((exp = BExpression.parse(this, 0)) != null) {
            result.add(exp);
        }
        this._br.close();
        this._br = null;
        return result;
    }

    public float getVariableValue(String name, float defaultValue) {
        Integer num = this.variableNumbers.get(name);
        return num == null ? defaultValue : this.getVariableValue(num);
    }

    float getVariableValue(int variableIdx) {
        return this.variableData[variableIdx];
    }

    int getVariableIdx(String name, boolean create) {
        Integer num = this.variableNumbers.get(name);
        if (num == null) {
            if (create) {
                num = new Integer(this.variableNumbers.size());
                this.variableNumbers.put(name, num);
            } else {
                return -1;
            }
        }
        return num;
    }

    int getMinWriteIdx() {
        return this.minWriteIdx;
    }

    float getLookupMatch(int nameIdx, int valueIdx) {
        return this.lookupData[nameIdx] == valueIdx ? 1.0f : 0.0f;
    }

    public int getLookupNameIdx(String name) {
        Integer num = this.lookupNumbers.get(name);
        return num == null ? -1 : num;
    }

    int getLookupValueIdx(int nameIdx, String value) {
        BExpressionLookupValue[] values = this.lookupValues.get(nameIdx);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    String parseToken() throws Exception {
        String token;
        while (true) {
            if ((token = this._parseToken()) == null) {
                return null;
            }
            if (token.startsWith(CONTEXT_TAG)) {
                this._inOurContext = token.substring(CONTEXT_TAG.length()).equals(this.context);
                continue;
            }
            if (this._inOurContext) break;
        }
        return token;
    }

    private String _parseToken() throws Exception {
        StringBuilder sb = new StringBuilder(32);
        boolean inComment = false;
        while (true) {
            int ic;
            int n = ic = this._readerDone ? -1 : this._br.read();
            if (ic < 0) {
                if (sb.length() == 0) {
                    return null;
                }
                this._readerDone = true;
                return sb.toString();
            }
            char c = (char)ic;
            if (c == '\n') {
                ++this.linenr;
            }
            if (inComment) {
                if (c != '\r' && c != '\n') continue;
                inComment = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
            if (c == '#' && sb.length() == 0) {
                inComment = true;
                continue;
            }
            sb.append(c);
        }
    }

    float assign(int variableIdx, float value) {
        this.variableData[variableIdx] = value;
        return value;
    }

    void expressionWarning(String message) {
        this._arrayBitmap[this.currentHashBucket] = null;
        if (this._receiver != null) {
            this._receiver.expressionWarning(this.context, message);
        }
    }
}

