/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.DenseLongMap;

public class TinyDenseLongMap
extends DenseLongMap {
    private long[][] al;
    private int[] pa = new int[31];
    private int size = 0;
    private int _maxKeepExponent = 14;
    protected static final int MAXLISTS = 31;
    private byte[][] vla;

    public TinyDenseLongMap() {
        super(1);
        this.al = new long[31][];
        this.al[0] = new long[1];
        this.vla = new byte[31][];
        this.vla[0] = new byte[1];
    }

    private void fillReturnValue(byte[] rv, int idx, int p) {
        rv[0] = this.vla[idx][p];
        if (rv.length == 2) {
            this.vla[idx][p] = rv[1];
        }
    }

    @Override
    public void put(long id, int value) {
        byte[] rv = new byte[2];
        rv[1] = (byte)value;
        if (this.contains(id, rv)) {
            return;
        }
        this.vla[0][0] = (byte)value;
        this._add(id);
    }

    @Override
    public int getInt(long id) {
        byte[] rv = new byte[1];
        if (this.contains(id, rv)) {
            return rv[0];
        }
        return -1;
    }

    private boolean _add(long id) {
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("cannot grow beyond size Integer.MAX_VALUE");
        }
        this.al[0][0] = id;
        int bp = this.size++;
        int idx = 1;
        int n = 1;
        this.pa[0] = 1;
        this.pa[1] = 1;
        while ((bp & 1) == 1) {
            bp >>= 1;
            this.pa[idx++] = n;
            n <<= 1;
        }
        if (this.al[idx] == null) {
            this.al[idx] = new long[n];
            this.vla[idx] = new byte[n];
        }
        while (n > 0) {
            long maxId = 0L;
            int maxIdx = -1;
            for (int i = 0; i < idx; ++i) {
                int p = this.pa[i];
                if (p <= 0) continue;
                long currentId = this.al[i][p - 1];
                if (maxIdx >= 0 && currentId <= maxId) continue;
                maxIdx = i;
                maxId = currentId;
            }
            if (n < this.al[idx].length && maxId == this.al[idx][n]) {
                throw new IllegalArgumentException("duplicate key found in late check: " + maxId);
            }
            this.al[idx][--n] = maxId;
            this.vla[idx][n] = this.vla[maxIdx][this.pa[maxIdx] - 1];
            int n2 = maxIdx;
            this.pa[n2] = this.pa[n2] - 1;
        }
        while (idx-- > this._maxKeepExponent) {
            this.al[idx] = null;
            this.vla[idx] = null;
        }
        return false;
    }

    private boolean contains(long id, byte[] rv) {
        int idx = 1;
        for (int bp = this.size; bp != 0; bp >>= 1) {
            if ((bp & 1) == 1 && this.contains(idx, id, rv)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private boolean contains(int idx, long id, byte[] rv) {
        long[] a = this.al[idx];
        int offset = a.length;
        int n = 0;
        while ((offset >>= 1) > 0) {
            int nn = n + offset;
            if (a[nn] > id) continue;
            n = nn;
        }
        if (a[n] == id) {
            if (rv != null) {
                this.fillReturnValue(rv, idx, n);
            }
            return true;
        }
        return false;
    }
}

