/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

public final class ByteDataWriter {
    private byte[] ab;
    private int aboffset;

    public ByteDataWriter(byte[] byteArray) {
        this.ab = byteArray;
    }

    public void writeInt(int v) {
        this.ab[this.aboffset++] = (byte)(v >> 24 & 0xFF);
        this.ab[this.aboffset++] = (byte)(v >> 16 & 0xFF);
        this.ab[this.aboffset++] = (byte)(v >> 8 & 0xFF);
        this.ab[this.aboffset++] = (byte)(v & 0xFF);
    }

    public void writeLong(long v) {
        this.ab[this.aboffset++] = (byte)(v >> 56 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 48 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 40 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 32 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 24 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 16 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v >> 8 & 0xFFL);
        this.ab[this.aboffset++] = (byte)(v & 0xFFL);
    }

    public void writeBoolean(boolean v) {
        this.ab[this.aboffset++] = (byte)(v ? 1 : 0);
    }

    public void writeByte(int v) {
        this.ab[this.aboffset++] = (byte)(v & 0xFF);
    }

    public void writeShort(int v) {
        this.ab[this.aboffset++] = (byte)(v >> 8 & 0xFF);
        this.ab[this.aboffset++] = (byte)(v & 0xFF);
    }

    public void write(byte[] sa) {
        System.arraycopy(sa, 0, this.ab, this.aboffset, sa.length);
        this.aboffset += sa.length;
    }

    public void write(byte[] sa, int offset, int len) {
        System.arraycopy(sa, offset, this.ab, this.aboffset, len);
        this.aboffset += len;
    }

    public void ensureCapacity(int len) {
    }

    public byte[] toByteArray() {
        byte[] c = new byte[this.aboffset];
        System.arraycopy(this.ab, 0, c, 0, this.aboffset);
        return c;
    }

    public int writeVarLengthSigned(int v) {
        return this.writeVarLengthUnsigned(v < 0 ? -v << 1 | 1 : v << 1);
    }

    public int writeVarLengthUnsigned(int v) {
        int start = this.aboffset;
        do {
            int i7 = v & 0x7F;
            if ((v >>= 7) != 0) {
                i7 |= 0x80;
            }
            this.ab[this.aboffset++] = (byte)(i7 & 0xFF);
        } while (v != 0);
        return this.aboffset - start;
    }

    public int size() {
        return this.aboffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.ab.length; ++i) {
            sb.append(i == 0 ? " " : ", ").append(Integer.toString(this.ab[i]));
        }
        sb.append(" ]");
        return sb.toString();
    }
}

