/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.expressions.BExpressionContext;
import btools.expressions.BExpressionMetaData;
import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.OsmParser;
import btools.mapcreator.RelationData;
import btools.mapcreator.WayData;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class OsmCutter
extends MapCreatorBase {
    private long recordCnt;
    private long nodesParsed;
    private long waysParsed;
    private long relsParsed;
    private long changesetsParsed;
    private DataOutputStream wayDos;
    private DataOutputStream cyclewayDos;
    private BExpressionContext _expctxWay;
    private BExpressionContext _expctxNode;
    private BExpressionContext _expctxWayStat;
    private BExpressionContext _expctxNodeStat;

    public static void main(String[] args) throws Exception {
        System.out.println("*** OsmCutter: cut an osm map in node-tiles + a way file");
        if (args.length != 5 && args.length != 6) {
            System.out.println("usage: bzip2 -dc <map> | java OsmCutter <lookup-file> <out-tile-dir> <out-way-file> <out-rel-file> <filter-profile>");
            System.out.println("or   : java OsmCutter <lookup-file> <out-tile-dir> <out-way-file> <out-rel-file> <filter-profile> <inputfile> ");
            return;
        }
        new OsmCutter().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]), new File(args[4]), args.length > 5 ? new File(args[5]) : null);
    }

    public void process(File lookupFile, File outTileDir, File wayFile, File relFile, File profileFile, File mapFile) throws Exception {
        if (!lookupFile.exists()) {
            throw new IllegalArgumentException("lookup-file: " + lookupFile + " does not exist");
        }
        BExpressionMetaData meta = new BExpressionMetaData();
        this._expctxWay = new BExpressionContext("way", meta);
        this._expctxNode = new BExpressionContext("node", meta);
        meta.readMetaData(lookupFile);
        this._expctxWay.parseFile(profileFile, "global");
        this._expctxWayStat = new BExpressionContext("way", null);
        this._expctxNodeStat = new BExpressionContext("node", null);
        this.outTileDir = outTileDir;
        if (!outTileDir.isDirectory()) {
            throw new RuntimeException("out tile directory " + outTileDir + " does not exist");
        }
        this.wayDos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(wayFile)));
        this.cyclewayDos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(relFile)));
        long t0 = System.currentTimeMillis();
        new OsmParser().readMap(mapFile, this, this, this);
        long t1 = System.currentTimeMillis();
        System.out.println("parsing time (ms) =" + (t1 - t0));
        this.closeTileOutStreams();
        this.wayDos.close();
        this.cyclewayDos.close();
        System.out.println("-------- way-statistics -------- ");
        this._expctxWayStat.dumpStatistics();
        System.out.println("-------- node-statistics -------- ");
        this._expctxNodeStat.dumpStatistics();
        System.out.println(this.statsLine());
    }

    private void checkStats() {
        if (++this.recordCnt % 100000L == 0L) {
            System.out.println(this.statsLine());
        }
    }

    private String statsLine() {
        return "records read: " + this.recordCnt + " nodes=" + this.nodesParsed + " ways=" + this.waysParsed + " rels=" + this.relsParsed + " changesets=" + this.changesetsParsed;
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        int tileIndex;
        ++this.nodesParsed;
        this.checkStats();
        if (n.getTagsOrNull() != null) {
            int[] lookupData = this._expctxNode.createNewLookupData();
            for (String key : n.getTagsOrNull().keySet()) {
                String value = n.getTag(key);
                this._expctxNode.addLookupValue(key, value, lookupData);
                this._expctxNodeStat.addLookupValue(key, value, null);
            }
            n.description = this._expctxNode.encode(lookupData);
        }
        if ((tileIndex = this.getTileIndex(n.ilon, n.ilat)) >= 0) {
            n.writeTo(this.getOutStreamForTile(tileIndex));
        }
    }

    @Override
    public void nextWay(WayData w) throws Exception {
        ++this.waysParsed;
        this.checkStats();
        if (w.getTagsOrNull() == null) {
            return;
        }
        int[] lookupData = this._expctxWay.createNewLookupData();
        for (String key : w.getTagsOrNull().keySet()) {
            String value = w.getTag(key);
            this._expctxWay.addLookupValue(key, value, lookupData);
            this._expctxWayStat.addLookupValue(key, value, null);
        }
        w.description = this._expctxWay.encode(lookupData);
        if (w.description == null) {
            return;
        }
        this._expctxWay.evaluate(false, w.description, null);
        boolean ok = (double)this._expctxWay.getCostfactor() < 10000.0;
        this._expctxWay.evaluate(true, w.description, null);
        if (!(ok |= (double)this._expctxWay.getCostfactor() < 10000.0)) {
            return;
        }
        w.writeTo(this.wayDos);
    }

    @Override
    public void nextRelation(RelationData r) throws Exception {
        ++this.relsParsed;
        this.checkStats();
        String route = r.getTag("route");
        if (route == null) {
            return;
        }
        String network = r.getTag("network");
        if (network == null) {
            network = "";
        }
        OsmCutter.writeId(this.cyclewayDos, r.rid);
        this.cyclewayDos.writeUTF(route);
        this.cyclewayDos.writeUTF(network);
        for (int i = 0; i < r.ways.size(); ++i) {
            long wid = r.ways.get(i);
            OsmCutter.writeId(this.cyclewayDos, wid);
        }
        OsmCutter.writeId(this.cyclewayDos, -1L);
    }

    private int getTileIndex(int ilon, int ilat) {
        int lon = ilon / 45000000;
        int lat = ilat / 30000000;
        if (lon < 0 || lon > 7 || lat < 0 || lat > 5) {
            System.out.println("warning: ignoring illegal pos: " + ilon + "," + ilat);
            return -1;
        }
        return lon * 6 + lat;
    }

    @Override
    protected String getNameForTile(int tileIndex) {
        int lon = tileIndex / 6 * 45 - 180;
        int lat = tileIndex % 6 * 30 - 90;
        String slon = lon < 0 ? "W" + -lon : "E" + lon;
        String slat = lat < 0 ? "S" + -lat : "N" + lat;
        return slon + "_" + slat + ".tls";
    }
}

