/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContext;
import btools.mapaccess.DistanceChecker;
import btools.mapaccess.OsmTransferNode;
import btools.router.OsmNodeNamed;
import btools.router.RoutingMessageHandler;
import java.util.ArrayList;
import java.util.List;

public final class RoutingContext
implements DistanceChecker {
    public int alternativeIdx = 0;
    public String localFunction;
    public String rawTrackPath;
    public BExpressionContext expctxWay;
    public BExpressionContext expctxNode;
    public int downhillcostdiv;
    public int downhillcutoff;
    public int uphillcostdiv;
    public int uphillcutoff;
    public boolean carMode;
    public double pass1coefficient;
    public double pass2coefficient;
    public RoutingMessageHandler messageHandler = new RoutingMessageHandler();
    public List<OsmNodeNamed> nogopoints = null;
    private List<OsmNodeNamed> keepnogopoints = null;
    private double coslat;
    public boolean nogomatch = false;
    public boolean isEndpoint = false;
    public boolean shortestmatch = false;
    public double wayfraction;
    public int ilatshortest;
    public int ilonshortest;

    public void setAlternativeIdx(int idx) {
        if (idx < 0) {
            idx = 0;
        }
        if (idx > 3) {
            idx = 3;
        }
        this.alternativeIdx = idx;
    }

    public int getAlternativeIdx() {
        return this.alternativeIdx;
    }

    public String getProfileName() {
        int idx;
        String name;
        String string = name = this.localFunction == null ? "unknown" : this.localFunction;
        if (name.endsWith(".brf")) {
            name = name.substring(0, this.localFunction.length() - 4);
        }
        if ((idx = name.lastIndexOf(47)) >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public void readGlobalConfig(BExpressionContext expctxGlobal) {
        this.downhillcostdiv = (int)expctxGlobal.getVariableValue("downhillcost", 0.0f);
        this.downhillcutoff = (int)(expctxGlobal.getVariableValue("downhillcutoff", 0.0f) * 10000.0f);
        this.uphillcostdiv = (int)expctxGlobal.getVariableValue("uphillcost", 0.0f);
        this.uphillcutoff = (int)(expctxGlobal.getVariableValue("uphillcutoff", 0.0f) * 10000.0f);
        if (this.downhillcostdiv != 0) {
            this.downhillcostdiv = 1000000 / this.downhillcostdiv;
        }
        if (this.uphillcostdiv != 0) {
            this.uphillcostdiv = 1000000 / this.uphillcostdiv;
        }
        this.carMode = 0.0f != expctxGlobal.getVariableValue("validForCars", 0.0f);
        this.pass1coefficient = expctxGlobal.getVariableValue("pass1coefficient", 1.5f);
        this.pass2coefficient = expctxGlobal.getVariableValue("pass2coefficient", 0.0f);
    }

    public static void prepareNogoPoints(List<OsmNodeNamed> nogos) {
        for (OsmNodeNamed nogo : nogos) {
            String s = nogo.name;
            int idx = s.indexOf(32);
            if (idx > 0) {
                s = s.substring(0, idx);
            }
            int ir = 20;
            if (s.length() > 4) {
                try {
                    ir = Integer.parseInt(s.substring(4));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            nogo.radius = (double)ir / 111894.0;
        }
    }

    public long[] getNogoChecksums() {
        long[] cs = new long[3];
        int n = this.nogopoints == null ? 0 : this.nogopoints.size();
        for (int i = 0; i < n; ++i) {
            OsmNodeNamed nogo = this.nogopoints.get(i);
            cs[0] = cs[0] + (long)nogo.ilon;
            cs[1] = cs[1] + (long)nogo.ilat;
            cs[2] = cs[2] + (long)(nogo.radius * 111894.0 * 10.0);
        }
        return cs;
    }

    public void setWaypoint(OsmNodeNamed wp, boolean endpoint) {
        this.keepnogopoints = this.nogopoints;
        this.nogopoints = new ArrayList<OsmNodeNamed>();
        this.nogopoints.add(wp);
        if (this.keepnogopoints != null) {
            this.nogopoints.addAll(this.keepnogopoints);
        }
        this.isEndpoint = endpoint;
    }

    public void unsetWaypoint() {
        this.nogopoints = this.keepnogopoints;
        this.isEndpoint = false;
    }

    public int calcDistance(int lon1, int lat1, int lon2, int lat2) {
        double l = (double)(lat2 - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        this.coslat = 1.0 - l2 + l4 / 6.0;
        double coslat6 = this.coslat * 1.0E-6;
        double dx = (double)(lon2 - lon1) * coslat6;
        double dy = (double)(lat2 - lat1) * 1.0E-6;
        double d = Math.sqrt(dy * dy + dx * dx);
        this.shortestmatch = false;
        if (d > 0.0 && this.nogopoints != null) {
            for (OsmNodeNamed nogo : this.nogopoints) {
                double x1 = (double)(lon1 - nogo.ilon) * coslat6;
                double y1 = (double)(lat1 - nogo.ilat) * 1.0E-6;
                double r12 = x1 * x1 + y1 * y1;
                double x2 = (double)(lon2 - nogo.ilon) * coslat6;
                double y2 = (double)(lat2 - nogo.ilat) * 1.0E-6;
                double r22 = x2 * x2 + y2 * y2;
                double d2 = r12 < r22 ? y1 * dx - x1 * dy : y2 * dx - x2 * dy;
                double radius = Math.abs(d2) / d;
                if (!(radius < nogo.radius)) continue;
                double s1 = x1 * dx + y1 * dy;
                double s2 = x2 * dx + y2 * dy;
                if (s1 < 0.0) {
                    s1 = -s1;
                    s2 = -s2;
                }
                if (s2 > 0.0 && (radius = Math.sqrt(s1 < s2 ? r12 : r22)) > nogo.radius) continue;
                if (nogo.isNogo) {
                    this.nogomatch = true;
                    continue;
                }
                this.shortestmatch = true;
                nogo.radius = radius;
                if (s2 < 0.0) {
                    double distance = d > 0.0 ? -s2 / d : 0.0;
                    this.wayfraction = d > 0.0 ? distance / d : 0.0;
                    double xm = x2 - this.wayfraction * dx;
                    double ym = y2 - this.wayfraction * dy;
                    this.ilonshortest = (int)(xm / coslat6 + (double)nogo.ilon);
                    this.ilatshortest = (int)(ym / 1.0E-6 + (double)nogo.ilat);
                } else if (s1 > s2) {
                    this.wayfraction = 0.0;
                    this.ilonshortest = lon2;
                    this.ilatshortest = lat2;
                } else {
                    this.wayfraction = 1.0;
                    this.ilonshortest = lon1;
                    this.ilatshortest = lat1;
                }
                if (this.isEndpoint) {
                    this.wayfraction = 1.0 - this.wayfraction;
                    lon2 = this.ilonshortest;
                    lat2 = this.ilatshortest;
                } else {
                    this.nogomatch = false;
                    lon1 = this.ilonshortest;
                    lat1 = this.ilatshortest;
                }
                dx = (double)(lon2 - lon1) * coslat6;
                dy = (double)(lat2 - lat1) * 1.0E-6;
                d = Math.sqrt(dy * dy + dx * dx);
            }
        }
        double dd = d * 111894.7368;
        return (int)(dd + 1.0);
    }

    public double calcCosAngle(int lon0, int lat0, int lon1, int lat1, int lon2, int lat2) {
        double dlat1 = lat1 - lat0;
        double dlon1 = (double)(lon1 - lon0) * this.coslat;
        double dlat2 = lat2 - lat1;
        double dlon2 = (double)(lon2 - lon1) * this.coslat;
        double dd = Math.sqrt((dlat1 * dlat1 + dlon1 * dlon1) * (dlat2 * dlat2 + dlon2 * dlon2));
        if (dd == 0.0) {
            return 0.0;
        }
        double cosp = (dlat1 * dlat2 + dlon1 * dlon2) / dd;
        return 1.0 - cosp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWithinRadius(int ilon0, int ilat0, OsmTransferNode firstTransfer, int ilon1, int ilat1) {
        OsmNodeNamed wp = this.nogopoints.get(0);
        double keepRadius = wp.radius;
        try {
            int ilon = ilon0;
            int ilat = ilat0;
            OsmTransferNode trans = firstTransfer;
            while (trans != null) {
                this.calcDistance(ilon, ilat, trans.ilon, trans.ilat);
                ilon = trans.ilon;
                ilat = trans.ilat;
                trans = trans.next;
            }
            this.calcDistance(ilon, ilat, ilon1, ilat1);
            boolean bl = wp.radius < keepRadius;
            return bl;
        }
        finally {
            wp.radius = keepRadius;
        }
    }
}

