/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SrtmData {
    public int ncols;
    public int nrows;
    public double xllcorner;
    public double yllcorner;
    public double cellsize;
    public short[] eval_array;
    private double minlon;
    private double minlat;
    private boolean missingData = false;

    public void init() {
        this.minlon = this.xllcorner;
        this.minlat = this.yllcorner;
    }

    public short getElevation(int ilon, int ilat) {
        double lon = (double)ilon / 1000000.0 - 180.0;
        double lat = (double)ilat / 1000000.0 - 90.0;
        double dcol = (lon - this.minlon) / this.cellsize - 0.5;
        double drow = (lat - this.minlat) / this.cellsize - 0.5;
        int row = (int)drow;
        int col = (int)dcol;
        if (col < 0) {
            col = 0;
        }
        if (col >= this.ncols - 1) {
            col = this.ncols - 2;
        }
        if (row < 0) {
            row = 0;
        }
        if (row >= this.nrows - 1) {
            row = this.nrows - 2;
        }
        double wrow = drow - (double)row;
        double wcol = dcol - (double)col;
        this.missingData = false;
        double eval = (1.0 - wrow) * (1.0 - wcol) * (double)this.get(row, col) + wrow * (1.0 - wcol) * (double)this.get(row + 1, col) + (1.0 - wrow) * wcol * (double)this.get(row, col + 1) + wrow * wcol * (double)this.get(row + 1, col + 1);
        return this.missingData ? (short)Short.MIN_VALUE : (short)eval;
    }

    private short get(int r, int c) {
        short e = this.eval_array[r * this.ncols + c];
        if (e == Short.MIN_VALUE) {
            this.missingData = true;
        }
        return e;
    }

    public SrtmData(File file) throws Exception {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        try {
            while (true) {
                ZipEntry ze;
                if (!(ze = zis.getNextEntry()).getName().endsWith(".asc")) continue;
                this.readFromStream(zis);
                return;
            }
        }
        finally {
            zis.close();
        }
    }

    private String secondToken(String s) {
        StringTokenizer tk = new StringTokenizer(s, " ");
        tk.nextToken();
        return tk.nextToken();
    }

    public void readFromStream(InputStream is) throws Exception {
        int c;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int linenr = 0;
        while (++linenr <= 6) {
            String line = br.readLine();
            if (linenr == 1) {
                this.ncols = Integer.parseInt(this.secondToken(line));
                continue;
            }
            if (linenr == 2) {
                this.nrows = Integer.parseInt(this.secondToken(line));
                continue;
            }
            if (linenr == 3) {
                this.xllcorner = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr == 4) {
                this.yllcorner = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr == 5) {
                this.cellsize = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr != 6) continue;
            this.eval_array = new short[this.ncols * this.nrows];
        }
        int row = 0;
        int col = 0;
        int n = 0;
        boolean negative = false;
        while ((c = br.read()) >= 0) {
            if (c == 32) {
                int val;
                if (negative) {
                    n = -n;
                }
                this.eval_array[(this.nrows - 1 - row) * this.ncols + col] = val = (short)(n < -250 ? Short.MIN_VALUE : (short)(n * 4));
                if (++col == this.ncols) {
                    col = 0;
                    ++row;
                }
                n = 0;
                negative = false;
                continue;
            }
            if (c >= 48 && c <= 57) {
                n = 10 * n + (c - 48);
                continue;
            }
            if (c != 45) continue;
            negative = true;
        }
        this.init();
        br.close();
    }

    private void test() {
        int[] ca = new int[]{50477121, 8051915, 50477742, 8047408, 50477189, 0x7ACACC};
        for (int i = 0; i < ca.length; i += 2) {
            int lat = ca[i] + 90000000;
            int lon = ca[i + 1] + 180000000;
            System.err.println("lat=" + lat + " lon=" + lon + " elev=" + (double)this.getElevation(lon, lat) / 4.0);
        }
    }

    public static void main(String[] args) throws Exception {
        SrtmData data = new SrtmData(new File(args[0]));
        data.test();
    }
}

