/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.util.HashMap;

public class RelationStatistics
extends MapCreatorBase {
    public static void main(String[] args) throws Exception {
        System.out.println("*** RelationStatistics: count relation networks");
        if (args.length != 1) {
            System.out.println("usage: java WayCutter <relation-file>");
            return;
        }
        new RelationStatistics().process(new File(args[0]));
    }

    public void process(File relationFileIn) throws Exception {
        HashMap<String, long[]> relstats = new HashMap<String, long[]>();
        DataInputStream dis = this.createInStream(relationFileIn);
        try {
            while (true) {
                long wid;
                long rid = RelationStatistics.readId(dis);
                String network = dis.readUTF();
                int waycount = 0;
                while ((wid = RelationStatistics.readId(dis)) != -1L) {
                    ++waycount;
                }
                long[] stat = (long[])relstats.get(network);
                if (stat == null) {
                    stat = new long[2];
                    relstats.put(network, stat);
                }
                stat[0] = stat[0] + 1L;
                stat[1] = stat[1] + (long)waycount;
            }
        }
        catch (EOFException eof) {
            dis.close();
            for (String network : relstats.keySet()) {
                long[] stat = (long[])relstats.get(network);
                System.out.println("network: " + network + " has " + stat[0] + " relations with " + stat[1] + " ways");
            }
            return;
        }
    }
}

