/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.expressions.BExpressionContext;
import btools.expressions.BExpressionMetaData;
import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.WayData;
import btools.mapcreator.WayIterator;
import btools.util.CompactLongSet;
import btools.util.FrozenLongSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.util.HashMap;

public class RelationMerger
extends MapCreatorBase {
    private HashMap<String, CompactLongSet> routesets;
    private CompactLongSet routesetall;
    private BExpressionContext expctxReport;
    private BExpressionContext expctxCheck;
    private DataOutputStream wayOutStream;

    public static void main(String[] args) throws Exception {
        System.out.println("*** RelationMerger: merge relations into ways");
        if (args.length != 6) {
            System.out.println("usage: java RelationMerger <way-file-in> <way-file-out> <relation-file> <lookup-file> <report-profile> <check-profile>");
            return;
        }
        new RelationMerger().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]), new File(args[4]), new File(args[5]));
    }

    public void process(File wayFileIn, File wayFileOut, File relationFileIn, File lookupFile, File reportProfile, File checkProfile) throws Exception {
        BExpressionMetaData metaReport = new BExpressionMetaData();
        this.expctxReport = new BExpressionContext("way", metaReport);
        metaReport.readMetaData(lookupFile);
        BExpressionMetaData metaCheck = new BExpressionMetaData();
        this.expctxCheck = new BExpressionContext("way", metaCheck);
        metaCheck.readMetaData(lookupFile);
        this.expctxReport.parseFile(reportProfile, "global");
        this.expctxCheck.parseFile(checkProfile, "global");
        this.routesets = new HashMap();
        this.routesetall = new CompactLongSet();
        DataInputStream dis = this.createInStream(relationFileIn);
        try {
            block2: while (true) {
                long rid = RelationMerger.readId(dis);
                String route = dis.readUTF();
                String network = dis.readUTF();
                String tagname = "route_" + route + "_" + network;
                CompactLongSet routeset = null;
                if (this.expctxCheck.getLookupNameIdx(tagname) >= 0 && (routeset = this.routesets.get(tagname)) == null) {
                    routeset = new CompactLongSet();
                    this.routesets.put(tagname, routeset);
                }
                while (true) {
                    long wid;
                    if ((wid = RelationMerger.readId(dis)) == -1L) continue block2;
                    if (routeset == null || routeset.contains(wid)) continue;
                    routeset.add(wid);
                    this.routesetall.add(wid);
                }
                break;
            }
        }
        catch (EOFException eof) {
            dis.close();
            for (String tagname : this.routesets.keySet()) {
                FrozenLongSet routeset = new FrozenLongSet(this.routesets.get(tagname));
                this.routesets.put(tagname, routeset);
                System.out.println("marked " + ((CompactLongSet)routeset).size() + " routes for tag: " + tagname);
            }
            this.wayOutStream = this.createOutStream(wayFileOut);
            new WayIterator(this, true).processFile(wayFileIn);
            this.wayOutStream.close();
            return;
        }
    }

    @Override
    public void nextWay(WayData data) throws Exception {
        if (this.routesetall.contains(data.wid)) {
            boolean warn;
            boolean ok = true;
            this.expctxReport.evaluate(false, data.description, null);
            boolean bl = warn = (double)this.expctxReport.getCostfactor() >= 10000.0;
            if (warn) {
                this.expctxCheck.evaluate(false, data.description, null);
                ok = (double)this.expctxCheck.getCostfactor() < 10000.0;
                System.out.println("** relation access conflict for wid = " + data.wid + " tags:" + this.expctxReport.getKeyValueDescription(data.description) + " (ok=" + ok + ")");
            }
            if (ok) {
                this.expctxReport.decode(data.description);
                for (String tagname : this.routesets.keySet()) {
                    CompactLongSet routeset = this.routesets.get(tagname);
                    if (!routeset.contains(data.wid)) continue;
                    this.expctxReport.addLookupValue(tagname, 2);
                }
                data.description = this.expctxReport.encode();
            }
        }
        data.writeTo(this.wayOutStream);
    }
}

