/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.util.DiffCoderDataInputStream;
import btools.util.DiffCoderDataOutputStream;

public class NodeData
extends MapCreatorBase {
    public long nid;
    public int ilon;
    public int ilat;
    public byte[] description;
    public short selev = Short.MIN_VALUE;

    public NodeData(long id, double lon, double lat) {
        this.nid = id;
        this.ilat = (int)((lat + 90.0) * 1000000.0 + 0.5);
        this.ilon = (int)((lon + 180.0) * 1000000.0 + 0.5);
    }

    public NodeData(DiffCoderDataInputStream dis) throws Exception {
        this.nid = dis.readDiffed(0);
        this.ilon = (int)dis.readDiffed(1);
        this.ilat = (int)dis.readDiffed(2);
        byte mode = dis.readByte();
        if ((mode & 1) != 0) {
            byte dlen = dis.readByte();
            this.description = new byte[dlen];
            dis.readFully(this.description);
        }
        if ((mode & 2) != 0) {
            this.selev = dis.readShort();
        }
    }

    public void writeTo(DiffCoderDataOutputStream dos) throws Exception {
        dos.writeDiffed(this.nid, 0);
        dos.writeDiffed(this.ilon, 1);
        dos.writeDiffed(this.ilat, 2);
        int mode = (this.description == null ? 0 : 1) | (this.selev == Short.MIN_VALUE ? 0 : 2);
        dos.writeByte((byte)mode);
        if ((mode & 1) != 0) {
            dos.writeByte(this.description.length);
            dos.write(this.description);
        }
        if ((mode & 2) != 0) {
            dos.writeShort(this.selev);
        }
    }
}

