/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import btools.router.OsmNodeNamed;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import btools.server.ServiceContext;
import btools.server.request.RequestHandler;
import btools.server.request.ServerHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class RouteServer
extends Thread {
    public ServiceContext serviceContext;
    private Socket clientSocket = null;
    private RoutingEngine cr = null;

    public void stopRouter() {
        RoutingEngine e = this.cr;
        if (e != null) {
            e.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            bw = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
            String getline = br.readLine();
            if (getline == null || getline.startsWith("GET /favicon.ico")) {
                return;
            }
            InetAddress ip = this.clientSocket.getInetAddress();
            System.out.println("ip=" + (ip == null ? "null" : ip.toString()) + " -> " + getline);
            String url = getline.split(" ")[1];
            HashMap<String, String> params = RouteServer.getUrlParams(url);
            long maxRunningTime = RouteServer.getMaxRunningTime();
            if (!params.containsKey("lonlats") || !params.containsKey("profile")) {
                throw new IllegalArgumentException("unknown request syntax: " + getline);
            }
            ServerHandler handler = new ServerHandler(this.serviceContext, params);
            RoutingContext rc = ((RequestHandler)handler).readRoutingContext();
            List<OsmNodeNamed> wplist = ((RequestHandler)handler).readWayPointList();
            this.cr = new RoutingEngine(null, null, this.serviceContext.segmentDir, wplist, rc);
            this.cr.quite = true;
            this.cr.doRun(maxRunningTime);
            bw.write("HTTP/1.1 200 OK\n");
            bw.write("Connection: close\n");
            bw.write("Content-Type: text/xml; charset=utf-8\n");
            bw.write("Access-Control-Allow-Origin: *\n");
            bw.write("\n");
            if (this.cr.getErrorMessage() != null) {
                bw.write(this.cr.getErrorMessage());
                bw.write("\n");
            } else {
                OsmTrack track = this.cr.getFoundTrack();
                if (track != null) {
                    bw.write(((RequestHandler)handler).formatTrack(track));
                }
            }
            bw.flush();
        }
        catch (Throwable e) {
            System.out.println("RouteServer got exception (will continue): " + e);
            e.printStackTrace();
        }
        finally {
            this.cr = null;
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {}
            }
            if (this.clientSocket != null) {
                try {
                    this.clientSocket.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("BRouter 0.9.9 / 18042014 / abrensch");
        if (args.length != 4) {
            System.out.println("serve BRouter protocol");
            System.out.println("usage: java RouteServer <segmentdir> <profiledir> <port> <maxthreads>");
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.segmentDir = args[0];
        System.setProperty("profileBaseDir", args[1]);
        int maxthreads = Integer.parseInt(args[3]);
        TreeMap<Long, RouteServer> threadMap = new TreeMap<Long, RouteServer>();
        ServerSocket serverSocket = new ServerSocket(Integer.parseInt(args[2]));
        long last_ts = 0L;
        while (true) {
            long ts;
            Socket clientSocket = serverSocket.accept();
            RouteServer server = new RouteServer();
            server.serviceContext = serviceContext;
            server.clientSocket = clientSocket;
            if (threadMap.size() >= maxthreads) {
                Long k = (Long)threadMap.firstKey();
                RouteServer victim = (RouteServer)threadMap.get(k);
                threadMap.remove(k);
                victim.stopRouter();
            }
            for (ts = System.currentTimeMillis(); ts <= last_ts; ++ts) {
            }
            threadMap.put(ts, server);
            last_ts = ts;
            server.start();
        }
    }

    private static HashMap<String, String> getUrlParams(String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringTokenizer tk = new StringTokenizer(url, "?&");
        while (tk.hasMoreTokens()) {
            String t = tk.nextToken();
            StringTokenizer tk2 = new StringTokenizer(t, "=");
            if (!tk2.hasMoreTokens()) continue;
            String key = tk2.nextToken();
            if (!tk2.hasMoreTokens()) continue;
            String value = tk2.nextToken();
            params.put(key, value);
        }
        return params;
    }

    private static long getMaxRunningTime() {
        long maxRunningTime = 60000L;
        String sMaxRunningTime = System.getProperty("maxRunningTime");
        if (sMaxRunningTime != null) {
            maxRunningTime = Integer.parseInt(sMaxRunningTime) * 1000;
        }
        return maxRunningTime;
    }
}

