/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.ByteDataReader;
import btools.mapaccess.MicroCache;
import btools.mapaccess.OsmFile;
import btools.util.Crc32;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class PhysicalFile {
    RandomAccessFile ra = null;
    long[] fileIndex = new long[25];
    int[] fileHeaderCrcs;
    private int fileIndexCrc;
    public long creationTime;
    String fileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkFileIntegrity(File f) {
        PhysicalFile pf = null;
        try {
            byte[] iobuffer = new byte[65636];
            pf = new PhysicalFile(f, new byte[65636], -1);
            for (int tileIndex = 0; tileIndex < 25; ++tileIndex) {
                OsmFile osmf = new OsmFile(pf, tileIndex, iobuffer);
                if (osmf.microCaches == null) continue;
                for (int lonIdx80 = 0; lonIdx80 < 80; ++lonIdx80) {
                    for (int latIdx80 = 0; latIdx80 < 80; ++latIdx80) {
                        new MicroCache(osmf, lonIdx80, latIdx80, iobuffer);
                    }
                }
            }
        }
        catch (IllegalArgumentException iae) {
            String string = iae.getMessage();
            return string;
        }
        catch (Exception e) {
            String string = e.toString();
            return string;
        }
        finally {
            if (pf != null) {
                try {
                    pf.ra.close();
                }
                catch (Exception ee) {}
            }
        }
        return null;
    }

    public PhysicalFile(File f, byte[] iobuffer, int lookupVersion) throws Exception {
        this.fileName = f.getName();
        this.ra = new RandomAccessFile(f, "r");
        this.ra.readFully(iobuffer, 0, 200);
        this.fileIndexCrc = Crc32.crc(iobuffer, 0, 200);
        ByteDataReader dis = new ByteDataReader(iobuffer);
        for (int i = 0; i < 25; ++i) {
            long lv = dis.readLong();
            short readVersion = (short)(lv >> 48);
            if (readVersion != lookupVersion && lookupVersion != -1) {
                throw new IllegalArgumentException("lookup version mismatch (old rd5?) lookups.dat=" + lookupVersion + " " + f.getAbsolutePath() + "=" + readVersion);
            }
            this.fileIndex[i] = lv & 0xFFFFFFFFFFFFL;
        }
        long len = this.ra.length();
        long pos = this.fileIndex[24];
        int extraLen = 112;
        if (len == pos) {
            return;
        }
        if (len < pos + (long)extraLen) {
            throw new IOException("file of size " + len + " + too short, should be " + (pos + (long)extraLen));
        }
        this.ra.seek(pos);
        this.ra.readFully(iobuffer, 0, extraLen);
        dis = new ByteDataReader(iobuffer);
        this.creationTime = dis.readLong();
        if (dis.readInt() != this.fileIndexCrc) {
            throw new IOException("top index checksum error");
        }
        this.fileHeaderCrcs = new int[25];
        for (int i = 0; i < 25; ++i) {
            this.fileHeaderCrcs[i] = dis.readInt();
        }
    }
}

